/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.Criticalidad;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import com.asbestosstar.crashdetector.waifu.RespuestaWaifu;
import com.asbestosstar.crashdetector.waifu.VersionWaifu;
import com.asbestosstar.crashdetector.waifu.WaifuAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AdvertenciaFaltasClases
implements Verificaciones {
    private boolean activado = false;
    private final Set<String> clases = new LinkedHashSet<String>();
    private final Map<String, String> enlacesPorClase = new HashMap<String, String>();

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (linea == null) {
            return;
        }
        if (linea.contains("Error loading class:") && linea.contains("WARN")) {
            try {
                String clase = linea.split("Error loading class: ")[1].split(" ")[0].trim();
                String claseFormateada = clase.replace(".", "/");
                if (this.clases.add(claseFormateada)) {
                    String enlace = consola.agregarErrorALectador(numero_de_linea, this);
                    this.enlacesPorClase.put(claseFormateada, enlace);
                }
            }
            catch (Exception ignored) {
                consola.agregarErrorALectador(numero_de_linea, this);
            }
        }
        this.activado = !this.clases.isEmpty();
    }

    @Override
    public Verificaciones nueva() {
        return new AdvertenciaFaltasClases();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 2.0f;
    }

    @Override
    public String mensaje() {
        if (this.clases.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder("<ul>");
        for (String clase : this.clases) {
            String enlace = this.enlacesPorClase.get(clase);
            html.append("<li>").append(clase).append(" - ").append(enlace).append("</li>");
        }
        html.append("</ul>");
        return MonitorDePID.idioma.faltar_de_clases_advertencia() + html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_faltar_de_clases_advertencia();
    }

    @Override
    public QuickFix solucion() {
        JComboBox<String> cargadorCombo = new JComboBox<String>();
        JComboBox<String> versionCombo = new JComboBox<String>();
        JComboBox<String> claseCombo = new JComboBox<String>();
        HashMap<String, List> versionesPorCargador = new HashMap<String, List>();
        for (VersionWaifu version : WaifuAPI.versiones) {
            versionesPorCargador.computeIfAbsent(version.cargador, k -> new ArrayList()).add(version.version_del_juego);
        }
        cargadorCombo.setModel(new DefaultComboBoxModel<String>(versionesPorCargador.keySet().toArray(new String[0])));
        cargadorCombo.addActionListener(e -> {
            String cargador = (String)cargadorCombo.getSelectedItem();
            if (cargador != null) {
                versionCombo.setModel(new DefaultComboBoxModel<String>(((List)versionesPorCargador.get(cargador)).toArray(new String[0])));
            }
        });
        claseCombo.setModel(new DefaultComboBoxModel<String>(this.clases.toArray(new String[0])));
        if (cargadorCombo.getItemCount() > 0) {
            cargadorCombo.setSelectedIndex(0);
            versionCombo.setModel(new DefaultComboBoxModel<String>(((List)versionesPorCargador.get(cargadorCombo.getSelectedItem())).toArray(new String[0])));
        }
        if (claseCombo.getItemCount() > 0) {
            claseCombo.setSelectedIndex(0);
        }
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionParaAdvertenciaFaltasClases()).agregarComponente(new QuickFix.SelectorGUI(cargadorCombo)).agregarComponente(new QuickFix.SelectorGUI(versionCombo)).agregarComponente(new QuickFix.SelectorGUI(claseCombo)).agregarBoton(MonitorDePID.idioma.buscar(), retener -> {
            ArrayList<RespuestaWaifu.Mod> modsEncontrados = new ArrayList<RespuestaWaifu.Mod>();
            String cargador = (String)cargadorCombo.getSelectedItem();
            String version = (String)versionCombo.getSelectedItem();
            String clase = (String)claseCombo.getSelectedItem();
            if (cargador != null && version != null && clase != null) {
                VersionWaifu versionSeleccionada = WaifuAPI.obtainerVersion(cargador, version);
                modsEncontrados.addAll(WaifuAPI.obtanerModDesdeClase(clase, versionSeleccionada));
                JTextArea textoResultados = new JTextArea(15, 40);
                textoResultados.setEditable(false);
                if (modsEncontrados.isEmpty()) {
                    textoResultados.setText(MonitorDePID.idioma.noResultados() + " " + clase);
                } else {
                    StringBuilder sb = new StringBuilder("Mods encontrados para ").append(clase).append(":\n");
                    for (RespuestaWaifu.Mod mod : modsEncontrados) {
                        sb.append("\nMod: ").append(mod.name);
                        if (mod.curseforgeProjectId != null) {
                            sb.append("\nCurseForge URL: https://api.waifu.neoforged.net/mod_url/").append(mod.curseforgeProjectId);
                        }
                        if (mod.modrinthProjectId != null) {
                            sb.append("\nModrinth URL: https://api.waifu.neoforged.net/mod_url/").append(mod.modrinthProjectId);
                        }
                        sb.append("\n-------------------");
                    }
                    textoResultados.setText(sb.toString());
                }
                JOptionPane.showMessageDialog(null, new JScrollPane(textoResultados), "Resultados de b\u00fasqueda", 1);
            }
        }, true).construir();
    }

    @Override
    public Criticalidad nivel_de_criticalidad() {
        return Criticalidad.ADVERTENCIA;
    }

    @Override
    public String id() {
        return "advertencia_faltas_clases";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

