/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import com.asbestosstar.crashdetector.json.Json;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class AntiManipulacion
implements Verificaciones {
    public static final Path ARCHIVO_ANTIMANIPULACION = Statics.carpeta.resolve("antimanipulacion.json");
    private boolean activado = false;
    private String mensaje = "";
    boolean completa = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void verificar(Consola consola) {
        if (this.completa) {
            return;
        }
        this.completa = true;
        if (!AntiManipulacion.ARCHIVO_ANTIMANIPULACION.toFile().exists()) {
            return;
        }
        try {
            contenido = new String(Files.readAllBytes(AntiManipulacion.ARCHIVO_ANTIMANIPULACION), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return;
        }
        if (contenido == null || contenido.trim().isEmpty()) {
            return;
        }
        try {
            raiz = Json.leer(contenido);
        }
        catch (Exception e) {
            return;
        }
        if (!raiz.esArreglo()) {
            return;
        }
        errores = new ArrayList<String>();
        tam = raiz.tamano();
        numHilos = Runtime.getRuntime().availableProcessors();
        pool = new ForkJoinPool(numHilos);
lbl24:
        // 2 sources

        try {
            for (i = 0; i < tam; ++i) {
                block35: {
                    item = raiz.en(i);
                    if (item == null || !item.esObjeto() || (nodoRuta = item.obtener("ruta")) == null || nodoRuta.esObjeto() || nodoRuta.esArreglo() || (rutaRelativa = nodoRuta.comoCadena()) == null || rutaRelativa.trim().isEmpty()) continue;
                    rutaAbsoluta = Paths.get(rutaRelativa, new String[0]);
                    if (!rutaAbsoluta.isAbsolute()) {
                        userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
                        rutaAbsoluta = userDir.resolve(rutaRelativa);
                    }
                    nodoCarpetas = item.obtener("es_carpeta");
                    esCarpeta = false;
                    if (nodoCarpetas != null) {
                        try {
                            esCarpeta = nodoCarpetas.comoBooleano();
                        }
                        catch (Exception ignored) {
                            esCarpeta = false;
                        }
                    }
                    if (!esCarpeta) break block35;
                    nodoHashes = item.obtener("hashes");
                    if (nodoHashes == null || !nodoHashes.esObjeto()) {
                        errores.add("Entrada de carpeta inv\u00e1lida: " + rutaRelativa);
                        continue;
                    }
                    hashesEsperados = new HashMap<String, String>();
                    numHashes = 0;
                    while ((clave = nodoHashes.obtener(String.valueOf(numHashes))) != null) {
                        if (clave.esArreglo() && clave.tamano() == 2) {
                            subRuta = clave.en(0);
                            hash = clave.en(1);
                            if (subRuta != null && hash != null) {
                                r = subRuta.comoCadena();
                                h = hash.comoCadena();
                                if (r != null && h != null) {
                                    hashesEsperados.put(r, h);
                                }
                            }
                        }
                        ++numHashes;
                    }
                    if (hashesEsperados.isEmpty()) {
                        errores.add("Carpeta sin hashes: " + rutaRelativa);
                        continue;
                    }
                    hashesReales = new ConcurrentHashMap<String, String>();
                    archivosParaHash = new ArrayList<Path>();
                    try {
                        Files.walk(rutaAbsoluta, new FileVisitOption[0]).filter((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$verificar$0(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)()).forEach((Consumer<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$verificar$1(java.util.List java.nio.file.Path ), (Ljava/nio/file/Path;)V)(archivosParaHash));
                    }
                    catch (IOException e) {
                        errores.add("No se pudo acceder a la carpeta: " + rutaRelativa);
                        continue;
                    }
                    pool.submit(new HashTask(archivosParaHash, rutaAbsoluta, hashesReales)).join();
                    for (Map.Entry<K, V> entry : hashesEsperados.entrySet()) {
                        subRuta = (String)entry.getKey();
                        hashEsperado = (String)entry.getValue();
                        hashReal = (String)hashesReales.get(subRuta);
                        if (hashReal == null) {
                            errores.add("Archivo faltante en carpeta: " + rutaRelativa + "/" + subRuta);
                            continue;
                        }
                        if (hashReal.equals(hashEsperado)) continue;
                        errores.add("Hash incorrecto en: " + rutaRelativa + "/" + subRuta);
                    }
                    for (String subRuta : hashesReales.keySet()) {
                        if (hashesEsperados.containsKey(subRuta)) continue;
                        errores.add("Archivo no autorizado en carpeta: " + rutaRelativa + "/" + subRuta);
                    }
                    ** GOTO lbl24
                }
                nodoHash = item.obtener("hash");
                if (nodoHash == null || nodoHash.esObjeto() || nodoHash.esArreglo()) {
                    errores.add("Entrada de archivo inv\u00e1lida: " + rutaRelativa);
                    continue;
                }
                hashEsperado = nodoHash.comoCadena();
                if (hashEsperado == null || hashEsperado.trim().isEmpty()) {
                    errores.add("Hash faltante para archivo: " + rutaRelativa);
                    continue;
                }
                if (!Files.exists(rutaAbsoluta, new LinkOption[0])) {
                    errores.add("Archivo faltante: " + rutaRelativa);
                    continue;
                }
                try {
                    hashReal = AntiManipulacion.calcularHash(rutaAbsoluta);
                }
                catch (IOException e) {
                    errores.add("Error al leer archivo: " + rutaRelativa);
                    continue;
                }
                if (hashReal.equals(hashEsperado)) continue;
                errores.add("Hash incorrecto para archivo: " + rutaRelativa);
            }
        }
        finally {
            pool.shutdown();
        }
        if (!errores.isEmpty()) {
            sb = new StringBuilder();
            sb.append(MonitorDePID.idioma.antimanipulacion_titulo());
            sb.append("<ul>");
            for (String error : errores) {
                errorRel = error.replace(Paths.get(System.getProperty("user.dir"), new String[0]).toString(), ".");
                sb.append("<li>").append(errorRel).append("</li>");
            }
            sb.append("</ul>");
            this.mensaje = sb.toString();
            this.activado = true;
        }
    }

    private static String calcularHash(Path archivo) throws IOException {
        try (InputStream in = Files.newInputStream(archivo, new OpenOption[0]);){
            int n;
            long hash = 2654435761L;
            byte[] buffer = new byte[8192];
            while ((n = in.read(buffer)) != -1) {
                for (int i = 0; i < n; ++i) {
                    hash ^= (hash << 5) + (hash >>> 2) + (long)(buffer[i] & 0xFF);
                }
            }
            String string = String.format("%08x", hash & 0xFFFFFFFFL);
            return string;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new AntiManipulacion();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1500.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_antimanipulacion();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        builder.agregarEtiqueta(MonitorDePID.idioma.antimanipulacion_reinstalar());
        return builder.construir();
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public String id() {
        return "antimanipulacion";
    }

    @Override
    public boolean anularNormal() {
        return this.activado;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    private static /* synthetic */ void lambda$verificar$1(List archivosParaHash, Path p) {
        archivosParaHash.add(p);
    }

    private static /* synthetic */ boolean lambda$verificar$0(Path x$0) {
        return Files.isRegularFile(x$0, new LinkOption[0]);
    }

    private static class HashTask
    extends RecursiveAction {
        private final List<Path> archivos;
        private final Path raiz;
        private final Map<String, String> resultado;

        HashTask(List<Path> archivos, Path raiz, Map<String, String> resultado) {
            this.archivos = archivos;
            this.raiz = raiz;
            this.resultado = resultado;
        }

        @Override
        protected void compute() {
            if (this.archivos.size() <= 100) {
                for (Path archivo : this.archivos) {
                    try {
                        String rel = this.raiz.relativize(archivo).toString();
                        String hash = AntiManipulacion.calcularHash(archivo);
                        this.resultado.put(rel, hash);
                    }
                    catch (IOException rel) {}
                }
            } else {
                int mitad = this.archivos.size() / 2;
                List<Path> izq = this.archivos.subList(0, mitad);
                List<Path> der = this.archivos.subList(mitad, this.archivos.size());
                HashTask.invokeAll(new HashTask(izq, this.raiz, this.resultado), new HashTask(der, this.raiz, this.resultado));
            }
        }
    }
}

