/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContenidoDeTrazos
implements Verificaciones {
    public boolean activado = false;
    public final Set<String> todos_identificadores = new HashSet<String>();
    public final Set<String> todos_sm_configs = new HashSet<String>();
    public final Map<String, StringBuilder> contento = new HashMap<String, StringBuilder>();
    private static final int MULTIPLICADOR_HILOS = 2;
    private static final Set<String> TRAZOS_GLOBALES_VISTOS = Collections.synchronizedSet(new HashSet());

    private static List<Integer> extraerNumerosDeNivel(String texto) {
        ArrayList<Integer> numeros = new ArrayList<Integer>();
        if (texto == null) {
            return numeros;
        }
        int indice = texto.lastIndexOf(32);
        String segmento = indice == -1 ? texto : texto.substring(indice + 1);
        Matcher emparejador = Pattern.compile("\\d+").matcher(segmento);
        while (emparejador.find()) {
            try {
                numeros.add(Integer.parseInt(emparejador.group()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return numeros;
    }

    private static <T> Comparator<T> comparadorNumerico(Function<T, String> extractor) {
        return Comparator.comparingInt(elemento -> {
            List<Integer> n = ContenidoDeTrazos.extraerNumerosDeNivel((String)extractor.apply(elemento));
            return n.isEmpty() ? Integer.MAX_VALUE : n.get(0);
        }).thenComparingInt(elemento -> {
            List<Integer> n = ContenidoDeTrazos.extraerNumerosDeNivel((String)extractor.apply(elemento));
            return n.size() > 1 ? n.get(1) : Integer.MAX_VALUE;
        }).thenComparingInt(elemento -> {
            List<Integer> n = ContenidoDeTrazos.extraerNumerosDeNivel((String)extractor.apply(elemento));
            return n.size() > 2 ? n.get(2) : Integer.MAX_VALUE;
        });
    }

    private static Set<Integer> calcularNivelesOcupados(VerificacionDeStackTrace vdst) {
        int desde;
        if (vdst == null || vdst.nivel_trazo == null || vdst.nivel_trazo.isEmpty() || MonitorDePID.analizador == null || MonitorDePID.analizador.verificaciones_activados == null || MonitorDePID.analizador.verificaciones_activados.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<Map.Entry<Integer, VerificacionDeStackTrace.TraceInfo>> entradas_nivel_trazo = new ArrayList<Map.Entry<Integer, VerificacionDeStackTrace.TraceInfo>>(vdst.nivel_trazo.entrySet());
        ArrayList<Verificaciones> verificaciones_activadas = new ArrayList<Verificaciones>(MonitorDePID.analizador.verificaciones_activados);
        int total = entradas_nivel_trazo.size();
        int numero_hilos = Runtime.getRuntime().availableProcessors() * 2;
        if (numero_hilos < 1) {
            numero_hilos = 1;
        }
        if (numero_hilos > total) {
            numero_hilos = total;
        }
        if (numero_hilos <= 1) {
            HashSet<Integer> niveles_ocupados = new HashSet<Integer>();
            block5: for (Map.Entry entry : entradas_nivel_trazo) {
                Integer nivel = (Integer)entry.getKey();
                VerificacionDeStackTrace.TraceInfo trazo = (VerificacionDeStackTrace.TraceInfo)entry.getValue();
                for (Verificaciones verif : verificaciones_activadas) {
                    try {
                        if (!verif.ocupaTrazo(trazo)) continue;
                        niveles_ocupados.add(nivel);
                        continue block5;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            return niveles_ocupados;
        }
        int tamano_bloque = (total + numero_hilos - 1) / numero_hilos;
        ExecutorService servicio_ejecucion = Executors.newFixedThreadPool(numero_hilos);
        ArrayList<Future<Set>> arrayList = new ArrayList<Future<Set>>();
        for (int indice_hilo = 0; indice_hilo < numero_hilos && (desde = indice_hilo * tamano_bloque) < total; ++indice_hilo) {
            int n = Math.min(total, desde + tamano_bloque);
            Callable<Set> tarea = () -> {
                HashSet<Integer> niveles_locales = new HashSet<Integer>();
                block2: for (int i = desde; i < hasta; ++i) {
                    Map.Entry entrada = (Map.Entry)entradas_nivel_trazo.get(i);
                    Integer nivel = (Integer)entrada.getKey();
                    VerificacionDeStackTrace.TraceInfo trazo = (VerificacionDeStackTrace.TraceInfo)entrada.getValue();
                    for (Verificaciones verif : verificaciones_activadas) {
                        try {
                            if (!verif.ocupaTrazo(trazo)) continue;
                            niveles_locales.add(nivel);
                            continue block2;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                return niveles_locales;
            };
            arrayList.add(servicio_ejecucion.submit(tarea));
        }
        HashSet<Integer> niveles_ocupados = new HashSet<Integer>();
        for (Future future : arrayList) {
            try {
                niveles_ocupados.addAll((Collection)future.get());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                CrashDetectorLogger.logException(e);
            }
        }
        servicio_ejecucion.shutdown();
        return niveles_ocupados;
    }

    private static boolean esTrazoOcupado(Set<Integer> niveles_ocupados, int nivel) {
        return niveles_ocupados != null && !niveles_ocupados.isEmpty() && niveles_ocupados.contains(nivel);
    }

    private static String normalizarOrigen(String origen) {
        if (origen == null) {
            return "";
        }
        String t = origen.trim();
        t = t.replaceAll("\\s+", " ");
        return t;
    }

    private static String claveGlobalLinea(VerificacionDeStackTrace.LineaTrazo lt) {
        return (lt.clase == null ? "" : lt.clase) + "|" + lt.lineaConsola;
    }

    private static String claveItemGlobal(VerificacionDeStackTrace.LineaTrazo lt) {
        String origen = ContenidoDeTrazos.normalizarOrigen(lt.origen);
        String clase = lt.clase == null ? "" : lt.clase;
        return origen + "|" + clase + "|" + lt.nivel + "|" + lt.lineaConsola;
    }

    private static String construirEnlaceCfr(String clase) {
        if (clase == null || clase.trim().isEmpty()) {
            return "";
        }
        return "<a href=\"cfr://" + clase + "\">[CFR]</a>";
    }

    @Override
    public void verificar(Consola consola) {
        VerificacionDeStackTrace vdst = consola.verificacion_de_stacktrace;
        if (vdst == null) {
            return;
        }
        Set<Integer> niveles_ocupados = ContenidoDeTrazos.calcularNivelesOcupados(vdst);
        List<VerificacionDeStackTrace.TraceInfo> traces = vdst.trazos_completos;
        if (traces == null || traces.isEmpty()) {
            traces = new ArrayList<VerificacionDeStackTrace.TraceInfo>();
            if (vdst.nivel_trazo != null) {
                traces.addAll(vdst.nivel_trazo.values());
            }
        }
        if (traces.isEmpty()) {
            return;
        }
        HashMap<String, Problema> mejorPorOrigen = new HashMap<String, Problema>();
        for (VerificacionDeStackTrace.TraceInfo info : traces) {
            int nivelTrace;
            if (info == null) continue;
            int n = nivelTrace = info.nivel > 0 ? info.nivel : -1;
            if (nivelTrace > 0 && ContenidoDeTrazos.esTrazoOcupado(niveles_ocupados, nivelTrace)) continue;
            List<Object> lineas = info.lineas == null ? Collections.emptyList() : info.lineas;
            for (VerificacionDeStackTrace.LineaTrazo lineaTrazo : lineas) {
                int lineaActual;
                int lineaNuevo;
                int nivelActual;
                String claveLineaGlobal;
                if (lineaTrazo == null || lineaTrazo.nivel > 0 && ContenidoDeTrazos.esTrazoOcupado(niveles_ocupados, lineaTrazo.nivel) || !TRAZOS_GLOBALES_VISTOS.add(claveLineaGlobal = ContenidoDeTrazos.claveGlobalLinea(lineaTrazo))) continue;
                String origenNorm = ContenidoDeTrazos.normalizarOrigen(lineaTrazo.origen);
                if (origenNorm.isEmpty()) {
                    String string = origenNorm = lineaTrazo.clase == null ? "" : lineaTrazo.clase;
                }
                if (origenNorm.isEmpty()) continue;
                String textoNivel = MonitorDePID.idioma.nivel() + lineaTrazo.nivel + "," + lineaTrazo.lineaConsola;
                String enlaceLinea = consola.agregarErrorALectador(lineaTrazo.lineaConsola, this);
                String enlaceCfr = ContenidoDeTrazos.construirEnlaceCfr(lineaTrazo.clase);
                String enlace = enlaceLinea + (enlaceCfr.isEmpty() ? "" : " " + enlaceCfr);
                Problema nuevo = new Problema(origenNorm, textoNivel, lineaTrazo.fatal, enlace);
                Problema actual = (Problema)mejorPorOrigen.get(origenNorm);
                if (actual == null) {
                    mejorPorOrigen.put(origenNorm, nuevo);
                    continue;
                }
                List<Integer> nNuevo = ContenidoDeTrazos.extraerNumerosDeNivel(nuevo.nivel);
                List<Integer> nActual = ContenidoDeTrazos.extraerNumerosDeNivel(actual.nivel);
                int nivelNuevo = nNuevo.isEmpty() ? Integer.MAX_VALUE : nNuevo.get(0);
                int n2 = nivelActual = nActual.isEmpty() ? Integer.MAX_VALUE : nActual.get(0);
                if (nivelNuevo < nivelActual) {
                    mejorPorOrigen.put(origenNorm, nuevo);
                    continue;
                }
                if (nivelNuevo != nivelActual || (lineaNuevo = nNuevo.size() > 1 ? nNuevo.get(1) : Integer.MAX_VALUE) >= (lineaActual = nActual.size() > 1 ? nActual.get(1) : Integer.MAX_VALUE)) continue;
                mejorPorOrigen.put(origenNorm, nuevo);
            }
        }
        if (mejorPorOrigen.isEmpty()) {
            return;
        }
        this.activado = true;
        ArrayList problemas = new ArrayList(mejorPorOrigen.values());
        problemas.sort(ContenidoDeTrazos.comparadorNumerico(p -> p.nivel));
        StringBuilder sb = new StringBuilder();
        sb.append("<br>").append(MonitorDePID.idioma.problematico_jar()).append("<br>").append("<ul>");
        for (Problema p2 : problemas) {
            sb.append("<li>");
            if (p2.fatal) {
                sb.append(MonitorDePID.idioma.posibilidad_fatal());
            }
            sb.append(p2.nombre).append(" ").append(p2.nivel);
            if (p2.enlace != null && !p2.enlace.isEmpty()) {
                sb.append(" ").append(p2.enlace);
            }
            sb.append("</li>");
        }
        sb.append("</ul>");
        this.contento.put(consola.archivo.getFileName().toString(), new StringBuilder(sb.toString().trim()));
    }

    @Override
    public Verificaciones nueva() {
        return new ContenidoDeTrazos();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 10.0f;
    }

    @Override
    public String mensaje() {
        StringBuilder constructor = new StringBuilder();
        constructor.append(MonitorDePID.idioma.infoDeTrazos()).append("<br>");
        for (Map.Entry<String, StringBuilder> entrada : this.contento.entrySet()) {
            String titulo = "<span style='color: #" + Config.obtenerInstancia().obtenerColorDeTitulosDeConsolas() + "; font-weight: bold;'>";
            constructor.append(titulo).append(entrada.getKey()).append("</span>");
            constructor.append(entrada.getValue().toString());
        }
        return constructor.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_contenido_de_stacktrace();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "contenido_de_trazos";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    private static class Problema {
        String nombre;
        String nivel;
        boolean fatal;
        String enlace;

        Problema(String nombre, String nivel, boolean fatal, String enlace) {
            this.nombre = nombre;
            this.nivel = nivel;
            this.fatal = fatal;
            this.enlace = enlace;
        }
    }
}

