/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DifDeMods
implements Verificaciones {
    private boolean activado = false;
    private String mensajeHTML = "";

    @Override
    public void verificar(Consola consola) {
        try {
            int numFalla;
            int numExito;
            Set<String> modsActual = this.obtenerMods(MonitorDePID.ultimo_mods);
            Path exitoFile = this.obtenerUltimoArchivo("exito");
            Path fallaFile = this.obtenerUltimoArchivo("falla");
            Path instantaneaFile = this.obtenerUltimoArchivo("instantanea");
            Path archivoInstantaneaUltimo = null;
            if (instantaneaFile != null) {
                archivoInstantaneaUltimo = instantaneaFile;
            }
            List<Object> diffInstantanea = new ArrayList();
            if (archivoInstantaneaUltimo != null) {
                Set<String> modsInstantanea = this.obtenerMods(archivoInstantaneaUltimo);
                diffInstantanea = this.compararMods(modsInstantanea, modsActual);
            }
            Path archivoUltimo = null;
            archivoUltimo = exitoFile != null && fallaFile != null ? ((numExito = this.obtenerNumeroArchivo(exitoFile)) > (numFalla = this.obtenerNumeroArchivo(fallaFile)) ? exitoFile : fallaFile) : (exitoFile != null ? exitoFile : fallaFile);
            if (archivoUltimo != null && archivoUltimo.toString().endsWith(".exito") || archivoUltimo.toString().endsWith(".instantanea")) {
                fallaFile = null;
            }
            List<Object> diffExito = new ArrayList();
            if (exitoFile != null) {
                Set<String> modsExito = this.obtenerMods(exitoFile);
                diffExito = this.compararMods(modsExito, modsActual);
            }
            ArrayList<String> diffFalla = new ArrayList();
            if (fallaFile != null) {
                Set<String> modsFalla = this.obtenerMods(fallaFile);
                diffFalla = this.compararMods(modsFalla, modsActual);
            }
            if (!(diffInstantanea.isEmpty() && diffExito.isEmpty() && diffFalla.isEmpty())) {
                this.activado = true;
                this.mensajeHTML = this.generarHTML(diffInstantanea, diffExito, diffFalla, archivoInstantaneaUltimo != null, exitoFile != null, fallaFile != null);
            }
        }
        catch (IOException e) {
            CrashDetectorLogger.log("Error comparando mods: " + e.getMessage());
        }
    }

    private Set<String> obtenerMods(Path archivo) throws IOException {
        return Files.readAllLines(archivo).stream().filter(line -> !line.trim().isEmpty()).collect(Collectors.toSet());
    }

    private List<String> compararMods(Set<String> viejos, Set<String> nuevos) {
        ArrayList<String> diff = new ArrayList<String>();
        nuevos.stream().filter(mod -> !viejos.contains(mod)).forEach(mod -> diff.add("+ " + mod));
        viejos.stream().filter(mod -> !nuevos.contains(mod)).forEach(mod -> diff.add("- " + mod));
        return diff;
    }

    private Path obtenerUltimoArchivo(String extension) {
        Path dir = Statics.carpeta.resolve("historia_mods");
        if (!Files.exists(dir, new LinkOption[0])) {
            return null;
        }
        File[] files = dir.toFile().listFiles((d, name) -> name.matches("\\d{6}\\.\\Q" + extension + "\\E"));
        if (files == null || files.length == 0) {
            return null;
        }
        List sortedFiles = Arrays.stream(files).sorted((f1, f2) -> {
            int num1 = this.obtenerNumeroArchivo(f1.toPath());
            int num2 = this.obtenerNumeroArchivo(f2.toPath());
            return Integer.compare(num2, num1);
        }).collect(Collectors.toList());
        if (!sortedFiles.isEmpty()) {
            return ((File)sortedFiles.get(0)).toPath();
        }
        return null;
    }

    private int obtenerNumeroArchivo(Path archivo) {
        String nombre = archivo.getFileName().toString();
        return Integer.parseInt(nombre.substring(0, 6));
    }

    private String generarHTML(List<String> diffInstantanea, List<String> diffExito, List<String> diffFalla, boolean tieneInstantanea, boolean tieneExito, boolean tieneFalla) {
        String color;
        StringBuilder html = new StringBuilder();
        if (tieneInstantanea) {
            html.append("<div style='margin:10px 0;padding:10px;border:1px solid #ccc;background-color:#f0f8ff;'>").append("<h3 style='color:#2196F3;'>").append(MonitorDePID.idioma.desdeUltimaInstantanea()).append(" (").append(this.extensionToNombre("instantanea")).append("):</h3>");
            if (diffInstantanea.isEmpty()) {
                html.append("<p style='color:green'>").append(MonitorDePID.idioma.noHayCambios()).append("</p>");
            } else {
                html.append("<ul>");
                for (String linea : diffInstantanea) {
                    color = linea.startsWith("+") ? "green" : "red";
                    html.append("<li style='color:" + color + "'>").append(linea).append("</li>");
                }
                html.append("</ul>");
            }
            html.append("</div>");
        }
        if (tieneExito) {
            html.append("<div style='margin:10px 0;padding:10px;border:1px solid #ccc'>").append("<h3>").append(MonitorDePID.idioma.desdeUltimoExito()).append(" (").append(this.extensionToNombre("exito")).append("):</h3>");
            if (diffExito.isEmpty()) {
                html.append("<p style='color:green'>").append(MonitorDePID.idioma.noHayCambios()).append("</p>");
            } else {
                html.append("<ul>");
                for (String linea : diffExito) {
                    color = linea.startsWith("+") ? "green" : "red";
                    html.append("<li style='color:" + color + "'>").append(linea).append("</li>");
                }
                html.append("</ul>");
            }
            html.append("</div>");
        }
        if (tieneFalla) {
            html.append("<div style='margin:10px 0;padding:10px;border:1px solid #ccc'>").append("<h3>").append(MonitorDePID.idioma.desdeUltimoIntento()).append(" (").append(this.extensionToNombre("falla")).append("):</h3>");
            if (diffFalla.isEmpty()) {
                html.append("<p style='color:green'>").append(MonitorDePID.idioma.noHayCambios()).append("</p>");
            } else {
                html.append("<ul>");
                for (String linea : diffFalla) {
                    color = linea.startsWith("+") ? "green" : "red";
                    html.append("<li style='color:" + color + "'>").append(linea).append("</li>");
                }
                html.append("</ul>");
            }
            html.append("</div>");
        }
        return html.toString();
    }

    private String extensionToNombre(String extension) {
        if ("exito".equals(extension)) {
            return MonitorDePID.idioma.exito();
        }
        if ("falla".equals(extension)) {
            return MonitorDePID.idioma.fallo();
        }
        if ("instantanea".equals(extension)) {
            return MonitorDePID.idioma.instantanea();
        }
        return extension;
    }

    @Override
    public String mensaje() {
        return this.mensajeHTML;
    }

    @Override
    public Verificaciones nueva() {
        return new DifDeMods();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return -1000.0f;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.diferentesDeLasMods();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "dif_de_mods";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

