/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.CDStringBuilder;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Drivers
implements Verificaciones {
    private boolean activado = false;
    private final CDStringBuilder mensajes = new CDStringBuilder();
    private static final String[] DRIVER_PATTERNS = new String[]{"Pixel format not accelerated", "The driver does not appear to support OpenGL", "GLFW error 65542", "GLFW error 65543", "GLFW error 1282", "No context is current or a function that is not available in the current context", "The driver does not appear to support framebuffer objects", "org.lwjgl.LWJGLException"};
    private static final String[] PATERNS_LINEA_ULTIMA = new String[]{"If this message is the only thing at the bottom of your log before a crash, you probably have a driver issue.", "You can safely ignore this message if the game starts up successfully.", "Trying GL version"};
    private static final String[] UNSUPPORTED_GPU_PATTERNS = new String[]{"old-videocard", "unsupported by videocard", "Your video card does not meet the requirements", "need to purchase a newer video card", "videocard is too old", "does not support OpenGL 3", "OpenGL unsupported by videocard", "The game failed to start because the currently installed"};
    private static final String[] PATRONES_NOUVEAU_LITERAL = new String[]{"libnouveau.so", "libdrm_nouveau.so", "nouveau"};
    private static final boolean ES_WINDOWS = System.getProperty("os.name", "").toLowerCase().contains("windows");
    private static Boolean TIENE_NVIDIA_CACHE = null;

    @Override
    public void verificar(Consola consola) {
        String log = consola.contenido_verificar;
        if (this.esProblemaSodiumDrivers(log)) {
            this.procesarProblemaSodiumDrivers();
            this.activado = true;
            return;
        }
        if (this.contienePatronNouveau(log)) {
            this.procesarProblemaNouveau();
            if (this.contienePatronOpenAL(log)) {
                this.procesarProblemaOpenAL();
            }
            return;
        }
        if (log.contains("EXCEPTION_ACCESS_VIOLATION") && log.contains("[atio6axx.dll")) {
            this.procesarProblemaAMD();
            return;
        }
        if (log.contains("EXCEPTION_ACCESS_VIOLATION") && log.contains("[atioglxx.dll")) {
            this.procesarProblemaAMD();
            return;
        }
        if (this.contieneLineaNativaAmd(log)) {
            this.procesarProblemaAMD();
            return;
        }
        if (this.contienePatron(log, new String[]{"[PhysX_64.dll", "[glfw.dll"}) && log.contains("EXCEPTION_ACCESS_VIOLATION")) {
            this.procesarProblemaGraficos();
            return;
        }
        this.verificarProblemasIntel(log);
        if (this.activado) {
            return;
        }
        if (this.contienePatron(log, UNSUPPORTED_GPU_PATTERNS)) {
            this.procesarGpuNoCompatible();
            return;
        }
        if (this.contienePatron(log, DRIVER_PATTERNS)) {
            this.procesarProblemaGraficos();
            return;
        }
        String ultimaLinea = this.obtenerUltimaLinea(log);
        if (ultimaLinea != null) {
            CrashDetectorLogger.log(ultimaLinea);
            if (this.contienePatron(ultimaLinea, PATERNS_LINEA_ULTIMA)) {
                this.procesarProblemaGraficos();
            } else if (this.contienePatron(ultimaLinea, UNSUPPORTED_GPU_PATTERNS)) {
                this.procesarGpuNoCompatible();
            }
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
    }

    private boolean esProblemaSodiumDrivers(String log) {
        String low = log.toLowerCase();
        boolean frase = low.contains("the game failed to start because the currently installed");
        boolean marca = low.contains("sodium") || low.contains("caffeinemc.net") || low.contains("link.caffeinemc.net");
        return frase && marca;
    }

    private boolean contieneLineaNativaAmd(String log) {
        String low = log.toLowerCase();
        return low.contains("c  [atio6axx.dll+") || low.contains("c  [atioglxx.dll+") || low.contains("# c  [atio6axx.dll+") || low.contains("# c  [atioglxx.dll+");
    }

    private boolean contienePatronNouveau(String log) {
        String low = log.toLowerCase();
        boolean encontradoLiteral = false;
        for (String patronLiteral : PATRONES_NOUVEAU_LITERAL) {
            if (!low.contains(patronLiteral)) continue;
            encontradoLiteral = true;
            break;
        }
        if (!encontradoLiteral) {
            return this.contienePatronOpenAL(log);
        }
        if (log.contains("nouveau") && (log.matches(".*libnouveau\\.so(\\.\\d+)*\\s*") || log.matches(".*libdrm_nouveau\\.so(\\.\\d+)*\\s*"))) {
            return true;
        }
        return this.contienePatronOpenAL(log);
    }

    private boolean contienePatronOpenAL(String log) {
        if (log.contains("[libopenal.so+")) {
            CrashDetectorLogger.log("Patr\u00f3n Nouveau encontrado: libopenal");
            return true;
        }
        return false;
    }

    private void procesarProblemaGraficos() {
        boolean esWindowsNuevo;
        boolean esWindows = this.esWindows();
        boolean tieneNvidia = esWindows && this.tieneNvidiaGPU();
        boolean bl = esWindowsNuevo = esWindows && this.esWindows11OServer2025();
        if (tieneNvidia) {
            this.mensajes.append(esWindowsNuevo ? MonitorDePID.idioma.problema_con_graficas_nvidia_windows_nuevo() : MonitorDePID.idioma.problema_con_graficas_nvidia_windows_viejo());
        } else {
            this.mensajes.append(MonitorDePID.idioma.problema_con_graficas_general());
        }
        this.activado = true;
    }

    private void procesarProblemaSodiumDrivers() {
        this.mensajes.append(MonitorDePID.idioma.problema_con_graficas_sodium());
    }

    private void procesarGpuNoCompatible() {
        this.mensajes.append(MonitorDePID.idioma.gpu_no_compatible());
        this.activado = true;
    }

    private void procesarProblemaAMD() {
        this.mensajes.append(MonitorDePID.idioma.problema_con_graficas_ati());
        this.activado = true;
    }

    private void procesarProblemaNouveau() {
        boolean tieneNvidia = false;
        try {
            int salir;
            Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", "lspci | grep -i vga"});
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String linea;
                while ((linea = reader.readLine()) != null) {
                    String lineaBaja = linea.toLowerCase();
                    if (!lineaBaja.contains("nvidia") && !lineaBaja.contains("rtx") && !lineaBaja.contains("gtx") && !lineaBaja.contains("gt") && !lineaBaja.contains("titan") && !lineaBaja.contains("quadro") && !lineaBaja.contains("tesla") && !lineaBaja.contains("ampere")) continue;
                    tieneNvidia = true;
                    break;
                }
            }
            if ((salir = process.waitFor()) != 0) {
                tieneNvidia = true;
            }
        }
        catch (Exception e) {
            tieneNvidia = true;
        }
        if (tieneNvidia) {
            this.mensajes.append(MonitorDePID.idioma.problema_con_graficas_nouveau());
            this.activado = true;
        }
    }

    private void procesarProblemaOpenAL() {
        this.mensajes.append(nl);
        this.mensajes.append(MonitorDePID.idioma.problema_con_openAL());
        this.activado = true;
    }

    private boolean contienePatron(String texto, String[] patrones) {
        for (String p : patrones) {
            if (!texto.contains(p)) continue;
            CrashDetectorLogger.log("Hay patron de Drivers " + p);
            return true;
        }
        return false;
    }

    private String obtenerUltimaLinea(String log) {
        if (log == null || log.isEmpty()) {
            return null;
        }
        String[] lineas = log.split(Verificaciones.nl);
        return lineas.length > 0 ? lineas[lineas.length - 1] : null;
    }

    private boolean esWindows() {
        return ES_WINDOWS;
    }

    private boolean tieneNvidiaGPU() {
        if (!ES_WINDOWS) {
            return false;
        }
        if (TIENE_NVIDIA_CACHE != null) {
            return TIENE_NVIDIA_CACHE;
        }
        boolean tiene = false;
        try {
            Process p = Runtime.getRuntime().exec("wmic path win32_VideoController get name");
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String l;
                while ((l = br.readLine()) != null) {
                    if (!l.toLowerCase().contains("nvidia")) continue;
                    tiene = true;
                    break;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TIENE_NVIDIA_CACHE = tiene;
        return tiene;
    }

    private boolean esWindows11OServer2025() {
        if (!ES_WINDOWS) {
            return false;
        }
        String[] v = System.getProperty("os.version", "").split("\\.");
        try {
            int build = v.length > 2 ? Integer.parseInt(v[2]) : 0;
            return "10".equals(v[0]) && "0".equals(v[1]) && build >= 22000;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private void verificarProblemasIntel(String log) {
        String[] dllsIntel;
        for (String dll : dllsIntel = new String[]{"[ig7icd32.dll]", "[ig7icd64.dll]", "[ig75icd32.dll]", "[ig75icd64.dll]", "[ig8icd64.dll]", "[ig9icd32.dll]", "[ig9icd64.dll]"}) {
            if (!log.contains(dll) || !log.contains("EXCEPTION_ACCESS_VIOLATION")) continue;
            this.procesarProblemaIntel();
            return;
        }
    }

    private void procesarProblemaIntel() {
        this.mensajes.append(MonitorDePID.idioma.problema_con_graficas_intel());
        this.activado = true;
    }

    @Override
    public Verificaciones nueva() {
        return new Drivers();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public String mensaje() {
        return this.mensajes.toString().replaceAll("\n", "<br>");
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_drivers();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "drivers";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

