/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorArchivoBloqueadoPorOtroProceso
implements Verificaciones {
    private static final String TEXTO_ERROR = "java.io.IOException: The process cannot access the file because another process has locked a portion of the file";
    private boolean activado = false;
    private String mensaje = "";
    private boolean posibleArchivoBloqueado = false;

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        this.posibleArchivoBloqueado = contenido != null && contenido.contains(TEXTO_ERROR);
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado || !this.posibleArchivoBloqueado) {
            return;
        }
        if (linea != null && linea.contains(TEXTO_ERROR)) {
            String enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorArchivoBloqueadoPorOtroProceso() + enlaceHtml;
            this.activado = true;
        }
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        return trazo.trace.contains(TEXTO_ERROR);
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorArchivoBloqueadoPorOtroProceso();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public float prioridad() {
        return 840.0f;
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionErrorArchivoBloqueadoPorOtroProceso()).construir();
    }

    @Override
    public String id() {
        return "archivo_bloqueado_por_otro_proceso";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreErrorArchivoBloqueadoPorOtroProceso();
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

