/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorCampoInexistente
implements Verificaciones {
    private static final Pattern PATRON_ERROR_SIMPLE = Pattern.compile("java\\.lang\\.NoSuchFieldError:\\s+(\\w+)");
    private static final Pattern PATRON_ERROR_MIEMBRO = Pattern.compile("java\\.lang\\.NoSuchFieldError:\\s*Class\\s+[^\\s]+\\s+does\\s+not\\s+have\\s+member\\s+field\\s+'([^']+)'");
    private boolean activado = false;
    private boolean posibleNoSuchField = false;
    private boolean esperandoLineaStack = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private String nombreCampoDetectado = "";
    private String lineaError = "";
    private String lineaStack = "";
    private boolean create = false;
    private boolean epicfight = false;
    private boolean azurelib = false;
    private boolean minecraft = false;
    private boolean dangerzone = false;
    private boolean featurecreep = false;
    private boolean modlauncher = false;
    private boolean minecraftforge = false;
    private boolean neoforged = false;
    private boolean fabricloader = false;
    private boolean pillowmc = false;

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        this.posibleNoSuchField = contenido != null && contenido.contains("java.lang.NoSuchFieldError:");
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado && !this.esperandoLineaStack) {
            return;
        }
        if (!this.posibleNoSuchField || linea == null) {
            return;
        }
        String l = linea;
        if (!this.activado && l.contains("java.lang.NoSuchFieldError:")) {
            String nombreCampo = null;
            Matcher mExt = PATRON_ERROR_MIEMBRO.matcher(l);
            if (mExt.find()) {
                String crudo = mExt.group(1).trim();
                int idxEspacio = crudo.lastIndexOf(32);
                nombreCampo = idxEspacio >= 0 && idxEspacio < crudo.length() - 1 ? crudo.substring(idxEspacio + 1) : crudo;
            } else {
                Matcher mSimple = PATRON_ERROR_SIMPLE.matcher(l);
                if (mSimple.find()) {
                    nombreCampo = mSimple.group(1);
                }
            }
            if (nombreCampo != null && !nombreCampo.isEmpty()) {
                this.nombreCampoDetectado = nombreCampo;
                this.lineaError = l.trim();
                this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
                String[] lineas = consola.contenido_verificar.split(Verificaciones.nl);
                String primeraLineaStack = "";
                for (int i = numero_de_linea + 1; i < lineas.length; ++i) {
                    String s = lineas[i].trim();
                    if (!s.startsWith("at ")) continue;
                    primeraLineaStack = s;
                    break;
                }
                this.create = false;
                this.epicfight = false;
                this.azurelib = false;
                this.minecraft = false;
                this.dangerzone = false;
                this.featurecreep = false;
                this.modlauncher = false;
                this.minecraftforge = false;
                this.neoforged = false;
                this.fabricloader = false;
                this.pillowmc = false;
                String target = primeraLineaStack;
                if (target.contains("com/simibubi/create") || target.contains("com.simibubi.create")) {
                    this.create = true;
                } else if (target.contains("yesman/epicfight") || target.contains("yesman.epicfight")) {
                    this.epicfight = true;
                } else if (target.contains("mod/azure/azurelib") || target.contains("mod.azure.azurelib")) {
                    this.azurelib = true;
                } else if (target.contains("asbestosstar/") || target.contains("asbestosstar.")) {
                    this.featurecreep = true;
                } else if (target.contains("dangerzone/") || target.contains("dangerzone.")) {
                    this.dangerzone = true;
                } else if (target.contains("net/fabricmc/") || target.contains("net.fabricmc.")) {
                    this.fabricloader = true;
                } else if (target.contains("net/neoforged/") || target.contains("net.neoforged.")) {
                    this.neoforged = true;
                } else if (target.contains("net/pillowmc/") || target.contains("net.pillowmc.")) {
                    this.pillowmc = true;
                } else if (target.contains("cpw/mods/modlauncher") || target.contains("cpw.mods.modlauncher")) {
                    this.modlauncher = true;
                } else if (target.contains("net/minecraftforge") || target.contains("net.minecraftforge")) {
                    this.minecraftforge = true;
                } else if ((target.contains("net/minecraft/") || target.contains("net.minecraft.")) && !target.contains("net/minecraftforge/") && !target.contains("net.minecraftforge.")) {
                    this.minecraft = true;
                }
                this.activado = true;
                this.esperandoLineaStack = true;
                this.lineaStack = primeraLineaStack;
                this.esperandoLineaStack = false;
                return;
            }
        }
    }

    private String escapeHtml(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorCampoInexistente();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 850.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        if (this.mensaje != null && !this.mensaje.isEmpty()) {
            return this.mensaje;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MonitorDePID.idioma.errorCampoInexistente(this.nombreCampoDetectado, this.lineaError));
        if (!this.lineaStack.isEmpty()) {
            sb.append("<br>");
            sb.append("<span style='color:#888888; font-family:monospace;'>");
            sb.append(this.escapeHtml(this.lineaStack));
            sb.append("</span>");
        }
        sb.append("<br>");
        sb.append(this.enlaceHtml);
        if (this.create) {
            sb.append(MonitorDePID.idioma.faltar_de_clases_create());
        }
        if (this.epicfight) {
            sb.append(MonitorDePID.idioma.faltar_de_clases_epicfight());
        }
        if (this.azurelib) {
            sb.append(MonitorDePID.idioma.faltar_de_clases_azurelib());
        }
        if (this.minecraft) {
            sb.append(MonitorDePID.idioma.faltar_de_clases_minecraft());
        }
        if (this.dangerzone) {
            sb.append(MonitorDePID.idioma.faltar_de_clases_dangerzone());
        }
        if (this.featurecreep) {
            sb.append(MonitorDePID.idioma.faltar_de_clases_featurecreep());
        }
        if (this.modlauncher) {
            sb.append(MonitorDePID.idioma.faltar_de_clases_modlauncher());
        }
        if (this.minecraftforge) {
            sb.append(MonitorDePID.idioma.faltar_de_clases_minecraftforge());
        }
        if (this.neoforged) {
            sb.append(MonitorDePID.idioma.faltar_de_clases_neoforged());
        }
        if (this.fabricloader) {
            sb.append(MonitorDePID.idioma.faltar_de_clases_fabricloader());
        }
        if (this.pillowmc) {
            sb.append(MonitorDePID.idioma.faltar_de_clases_pillowmc());
        }
        this.mensaje = sb.toString();
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_error_campo_inexistente();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_campo_inexistente()).agregarEtiqueta(MonitorDePID.idioma.paso2_campo_inexistente()).construir();
    }

    @Override
    public String id() {
        return "error_campo_inexistente";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        return trazo.trace.contains("NoSuchFieldError");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

