/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorCaracteresInvalidosEnNombre
implements Verificaciones {
    private static final Pattern PATRON_ERROR = Pattern.compile("IllegalArgumentException: ([^:]+): Invalid module name: '([^']+)'");
    private boolean activado = false;
    private String mensaje = "";
    private String nombreModulo = "";
    private String parteInvalida = "";
    private String enlaceHtml = "";
    private boolean posibleErrorNombreInvalido = false;

    @Override
    public void verificar(Consola consola) {
        String contenidoConsola = consola.contenido_verificar;
        if (contenidoConsola == null) {
            this.posibleErrorNombreInvalido = false;
            return;
        }
        this.posibleErrorNombreInvalido = contenidoConsola.contains("Invalid module name: '") && contenidoConsola.contains("' is not a Java identifier");
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        Matcher matcher;
        if (this.activado || !this.posibleErrorNombreInvalido || linea == null) {
            return;
        }
        if (linea.contains("Invalid module name: '") && linea.contains("' is not a Java identifier") && (matcher = PATRON_ERROR.matcher(linea)).find()) {
            this.nombreModulo = matcher.group(1);
            this.parteInvalida = matcher.group(2);
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorCaracteresInvalidosEnNombre(this.nombreModulo, this.parteInvalida) + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorCaracteresInvalidosEnNombre();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 950.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_caracteres_invalidos();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_caracteres_invalidos(this.nombreModulo, this.parteInvalida)).agregarEtiqueta(MonitorDePID.idioma.paso2_caracteres_invalidos(this.nombreModulo)).agregarEtiqueta(MonitorDePID.idioma.paso3_caracteres_invalidos()).construir();
    }

    @Override
    public String id() {
        return "caracters_invalidos_en_nombre";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("Invalid module name:") && t.contains("is not a Java identifier");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

