/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorClaseFinalExtendida
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private static final Pattern PATRON_CLASE_FINAL = Pattern.compile("java\\.lang\\.IncompatibleClassChangeError: class ([^ ]+) cannot inherit from final class ([^\\s]+)");
    private boolean posibleErrorClaseFinal = false;

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        if (contenido == null) {
            this.posibleErrorClaseFinal = false;
            return;
        }
        this.posibleErrorClaseFinal = contenido.contains("IncompatibleClassChangeError: class") && contenido.contains("cannot inherit from final class");
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado || !this.posibleErrorClaseFinal || linea == null) {
            return;
        }
        Matcher m = PATRON_CLASE_FINAL.matcher(linea);
        if (m.find()) {
            String claseHija = m.group(1);
            String clasePadreFinal = m.group(2);
            String enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorClaseFinalExtendida(claseHija, clasePadreFinal) + enlaceHtml;
            this.activado = true;
        }
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (!t.contains("IncompatibleClassChangeError: class") || !t.contains("cannot inherit from final class")) {
            return false;
        }
        return PATRON_CLASE_FINAL.matcher(t).find();
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorClaseFinalExtendida();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public float prioridad() {
        return 820.0f;
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionErrorClaseFinalExtendida()).construir();
    }

    @Override
    public String id() {
        return "clase_final_extendida";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreErrorClaseFinalExtendida();
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

