/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorContextoOpenGL
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private String origen = "";

    @Override
    public void verificar(Consola consola) {
        String[] lineas = consola.contenido_verificar.split(Verificaciones.nl);
        for (int i = 0; i < lineas.length; ++i) {
            boolean detalleSiguiente;
            String l = lineas[i];
            boolean cabecera = l.contains("FATAL ERROR in native method");
            boolean detalleAqui = l.contains("No context is current or a function that is not available in the current context was called");
            boolean bl = detalleSiguiente = !detalleAqui && i + 1 < lineas.length && lineas[i + 1].contains("No context is current or a function that is not available in the current context was called");
            if (!cabecera || !detalleAqui && !detalleSiguiente) continue;
            this.mensaje = MonitorDePID.idioma.errorContextoOpenGL();
            this.origen = this.detectarOrigenConVDST(consola.verificacion_de_stacktrace, consola.contenido_verificar, i);
            if (!this.origen.isEmpty()) {
                this.mensaje = this.mensaje + " <b>(" + this.origen + ")</b>";
            }
            this.enlaceHtml = consola.agregarErrorALectador(i, this);
            this.activado = true;
            break;
        }
    }

    private String detectarOrigenConVDST(VerificacionDeStackTrace vdst, String log, int lineaInicio) {
        String[] arr;
        VerificacionDeStackTrace.TraceInfo candidato = null;
        int ventanaSuperior = lineaInicio + 60;
        for (VerificacionDeStackTrace.TraceInfo ti : VerificacionDeStackTrace.obtenerTracesFatalConLinea(log)) {
            if (ti.consolaLineaComenzar < lineaInicio || ti.consolaLineaComenzar > ventanaSuperior) continue;
            candidato = ti;
            break;
        }
        if (candidato == null) {
            for (VerificacionDeStackTrace.TraceInfo ti : VerificacionDeStackTrace.obtenerTracesConLinea(log)) {
                if (ti.consolaLineaComenzar < lineaInicio || ti.consolaLineaComenzar > ventanaSuperior) continue;
                candidato = ti;
                break;
            }
        }
        if (candidato == null) {
            arr = log.split(Verificaciones.nl);
            for (int ln = lineaInicio; ln < Math.min(arr.length, lineaInicio + 30); ++ln) {
                String posible = this.origenEnLinea(arr[ln]);
                if (posible.isEmpty()) continue;
                return posible;
            }
            return "";
        }
        for (String linea : arr = candidato.trace.split(Verificaciones.nl)) {
            String posible = this.origenEnLinea(linea);
            if (posible.isEmpty()) continue;
            return posible;
        }
        return "";
    }

    private String origenEnLinea(String linea) {
        for (String jar : VerificacionDeStackTrace.extraerJarsDeLinea(linea)) {
            if (!jar.contains(".jar") || VerificacionDeStackTrace.isJarNoPermite(jar)) continue;
            return jar;
        }
        String modid = VerificacionDeStackTrace.extraerModidDeLinea(linea);
        if (modid != null && !VerificacionDeStackTrace.esModNoPermite(modid)) {
            return modid;
        }
        String pack = VerificacionDeStackTrace.extraerPaqueteDeLinea(linea);
        if (pack != null && !this.empiezaConPrefijoNoPermitido(pack)) {
            return pack;
        }
        return "";
    }

    private boolean empiezaConPrefijoNoPermitido(String pack) {
        for (String p : VerificacionDeStackTrace.package_no_permite) {
            if (!pack.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorContextoOpenGL();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1050.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreErrorContextoOpenGL();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1ErrorContextoOpenGL()).construir();
    }

    @Override
    public String id() {
        return "contexto_opengl";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

