/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorDeEnlaceInsatisfecho
implements Verificaciones {
    private boolean activado = false;
    private String nombreBiblioteca = "";
    private final StringBuilder mensaje = new StringBuilder();

    @Override
    public void verificar(Consola consola) {
        String contenidoConsola = consola.contenido_verificar;
        Pattern pattern = Pattern.compile("java\\.lang\\.UnsatisfiedLinkError: Failed to locate library: (?<name>.*)");
        Matcher matcher = pattern.matcher(contenidoConsola);
        if (matcher.find()) {
            this.nombreBiblioteca = matcher.group("name");
            this.activado = true;
            this.mensaje.append(MonitorDePID.idioma.error_enlace_insatisfecho(this.nombreBiblioteca));
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorDeEnlaceInsatisfecho();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 700.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_enlace_insatisfecho();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucion_para_error_enlace_insatisfecho()).construir();
    }

    @Override
    public String id() {
        return "enlace_insatisfecho";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

