/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ErrorEntrypointFabric
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String modNombre = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado || linea == null) {
            return;
        }
        if (linea.contains("net.fabricmc.loader.api.EntrypointException") && linea.contains("Exception while loading entries for entrypoint") && linea.contains("provided by '")) {
            int fin;
            int inicio = linea.indexOf("provided by '");
            this.modNombre = inicio != -1 ? ((fin = linea.indexOf(39, inicio += "provided by '".length())) != -1 ? linea.substring(inicio, fin).trim() : "mod desconocido") : "mod desconocido";
            this.activado = true;
            String enlace = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.error_entrypoint_fabric_html(this.modNombre) + (enlace.isEmpty() ? "" : " " + enlace);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorEntrypointFabric();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1300.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_error_entrypoint_fabric();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_eliminar_mod(this.modNombre));
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_actualizar_mod(this.modNombre));
        return builder.construir();
    }

    @Override
    public String id() {
        return "error_entrypoint_fabric";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

