/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorJarCorruptoConNombre
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private static final Pattern PATRON_JAR_EN_ERROR = Pattern.compile("Error analyzing \\[([^\\]]+\\.jar)\\]: java\\.util\\.zip\\.ZipException: zip END header not found");

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        Matcher m = PATRON_JAR_EN_ERROR.matcher(linea);
        if (m.find()) {
            String rutaCompleta = m.group(1);
            String nombreJar = rutaCompleta.substring(rutaCompleta.lastIndexOf(47) + 1);
            nombreJar = nombreJar.substring(nombreJar.lastIndexOf(92) + 1);
            String enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje = MonitorDePID.idioma.errorJarCorruptoConNombre(nombreJar) + enlaceHtml;
            this.activado = true;
        }
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return PATRON_JAR_EN_ERROR.matcher(trazo.trace).find();
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorJarCorruptoConNombre();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public float prioridad() {
        return 865.0f;
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionJarCorrupto()).construir();
    }

    @Override
    public String id() {
        return "jar_corrupto_con_nombre";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreErrorJarCorruptoConNombre();
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

