/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorMetodoAbstractoNoImplementado
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private boolean posibleErrorMetodoAbstracto = false;
    private String[] lineasConsola = null;
    private static final Pattern PATRON_ABSTRACT_METHOD = Pattern.compile("java\\.lang\\.AbstractMethodError: Receiver class ([^ ]+) does not define or inherit an implementation of the resolved method '([^']+)' of interface ([^\\.]+\\.[^\\s]+)");

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        this.lineasConsola = contenido != null ? contenido.split(Verificaciones.nl) : null;
        this.posibleErrorMetodoAbstracto = contenido != null && contenido.contains("java.lang.AbstractMethodError") && contenido.contains("does not define or inherit an implementation") && contenido.contains("of interface");
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado || !this.posibleErrorMetodoAbstracto || linea == null) {
            return;
        }
        String recorte = linea.trim();
        if (!(recorte.contains("java.lang.AbstractMethodError") && recorte.contains("does not define or inherit an implementation") && recorte.contains("of interface"))) {
            return;
        }
        Matcher m = PATRON_ABSTRACT_METHOD.matcher(recorte);
        if (!m.find()) {
            return;
        }
        String claseConcreta = m.group(1);
        String firmaMetodo = m.group(2);
        String interfaz = m.group(3);
        String origen = "";
        if (this.lineasConsola != null && numero_de_linea >= 0 && numero_de_linea < this.lineasConsola.length) {
            for (int j = numero_de_linea + 1; j < Math.min(numero_de_linea + 11, this.lineasConsola.length); ++j) {
                String l = this.lineasConsola[j].trim();
                if (l.startsWith("at ")) {
                    String posibleOrigen = VerificacionDeStackTrace.extraerModidDeLinea(l);
                    if (posibleOrigen == null || VerificacionDeStackTrace.esModNoPermite(posibleOrigen)) {
                        List<String> jars = VerificacionDeStackTrace.extraerJarsDeLinea(l);
                        posibleOrigen = !jars.isEmpty() ? jars.get(0) : VerificacionDeStackTrace.extraerPaqueteDeLinea(l);
                    }
                    if (posibleOrigen == null || posibleOrigen.isEmpty() || VerificacionDeStackTrace.esModNoPermite(posibleOrigen)) continue;
                    origen = posibleOrigen;
                    break;
                }
                if (!l.isEmpty() && !l.startsWith("Caused by") && !l.startsWith("...")) break;
            }
        }
        this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
        this.mensaje = MonitorDePID.idioma.errorMetodoAbstractoNoImplementadoDetallado(claseConcreta, firmaMetodo, interfaz, origen) + "<br>" + this.enlaceHtml;
        this.activado = true;
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("java.lang.AbstractMethodError") && t.contains("does not define or inherit an implementation") && t.contains("of interface");
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorMetodoAbstractoNoImplementado();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public float prioridad() {
        return 1200.0f;
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionMetodoAbstractoNoImplementado()).construir();
    }

    @Override
    public String id() {
        return "metodo_abstracto_no_implementado";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreErrorMetodoAbstractoNoImplementado();
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

