/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorMetodoInexistente
implements Verificaciones {
    private static final Pattern PATRON = Pattern.compile("java\\.lang\\.NoSuchMethodError:\\s*(.+)$");
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private String firmaMetodo = "";
    private String lineaSiguiente = "";
    private boolean create = false;
    private boolean epicfight = false;
    private boolean azurelib = false;
    private boolean minecraft = false;
    private boolean dangerzone = false;
    private boolean featurecreep = false;
    private boolean modlauncher = false;
    private boolean minecraftforge = false;
    private boolean neoforged = false;
    private boolean fabricloader = false;
    private boolean pillowmc = false;

    @Override
    public void verificar(Consola consola, String linea, int numLinea) {
        Matcher m;
        if (this.activado) {
            return;
        }
        if (linea.contains("java.lang.NoSuchMethodError:") && (m = PATRON.matcher(linea)).find()) {
            String targetLine;
            this.firmaMetodo = m.group(1).trim();
            String[] lineas = consola.contenido_verificar.split(Verificaciones.nl);
            this.lineaSiguiente = "";
            for (int i = numLinea + 1; i < lineas.length; ++i) {
                String sig = lineas[i].trim();
                if (!sig.startsWith("at ")) continue;
                this.lineaSiguiente = sig;
                break;
            }
            this.create = false;
            this.epicfight = false;
            this.azurelib = false;
            this.minecraft = false;
            this.dangerzone = false;
            this.featurecreep = false;
            this.modlauncher = false;
            this.minecraftforge = false;
            this.neoforged = false;
            this.fabricloader = false;
            this.pillowmc = false;
            String string = targetLine = !this.lineaSiguiente.isEmpty() ? this.lineaSiguiente : linea;
            if (linea.toLowerCase().contains("net.minecraftforge") || linea.toLowerCase().contains("minecraftforge")) {
                this.minecraftforge = true;
            }
            if (!this.lineaSiguiente.isEmpty()) {
                if (targetLine.contains("com/simibubi/create") || targetLine.contains("com.simibubi.create")) {
                    this.create = true;
                } else if (targetLine.contains("yesman/epicfight") || targetLine.contains("yesman.epicfight")) {
                    this.epicfight = true;
                } else if (targetLine.contains("mod/azure/azurelib") || targetLine.contains("mod.azure.azurelib")) {
                    this.azurelib = true;
                } else if (targetLine.contains("asbestosstar/") || targetLine.contains("asbestosstar.")) {
                    this.featurecreep = true;
                } else if (targetLine.contains("dangerzone/") || targetLine.contains("dangerzone.")) {
                    this.dangerzone = true;
                } else if (targetLine.contains("net/fabricmc/") || targetLine.contains("net.fabricmc.")) {
                    this.fabricloader = true;
                } else if (targetLine.contains("net/neoforged/") || targetLine.contains("net.neoforged.")) {
                    this.neoforged = true;
                } else if (targetLine.contains("net/pillowmc/") || targetLine.contains("net.pillowmc.")) {
                    this.pillowmc = true;
                } else if (targetLine.contains("cpw/mods/modlauncher") || targetLine.contains("cpw.mods.modlauncher")) {
                    this.modlauncher = true;
                } else if (targetLine.contains("net/minecraftforge") || targetLine.contains("net.minecraftforge")) {
                    this.minecraftforge = true;
                } else if ((targetLine.contains("net/minecraft/") || targetLine.contains("net.minecraft.")) && !targetLine.contains("net/minecraftforge/") && !targetLine.contains("net.minecraftforge.")) {
                    this.minecraft = true;
                }
            }
            this.enlaceHtml = consola.agregarErrorALectador(numLinea, this);
            this.activado = true;
            StringBuilder sb = new StringBuilder();
            sb.append(MonitorDePID.idioma.errorMetodoInexistente(this.firmaMetodo, this.firmaMetodo));
            if (!this.lineaSiguiente.isEmpty()) {
                sb.append("<br>");
                sb.append("<span style='color:#888888; font-family:monospace;'>");
                sb.append(this.escapeHtml(this.lineaSiguiente));
                sb.append("</span>");
            }
            sb.append("<br>");
            sb.append(this.enlaceHtml);
            if (this.create) {
                sb.append("<br>").append(MonitorDePID.idioma.faltar_de_clases_create());
            }
            if (this.epicfight) {
                sb.append("<br>").append(MonitorDePID.idioma.faltar_de_clases_epicfight());
            }
            if (this.azurelib) {
                sb.append("<br>").append(MonitorDePID.idioma.faltar_de_clases_azurelib());
            }
            if (this.featurecreep) {
                sb.append("<br>").append(MonitorDePID.idioma.faltar_de_clases_featurecreep());
            }
            if (this.dangerzone) {
                sb.append("<br>").append(MonitorDePID.idioma.faltar_de_clases_dangerzone());
            }
            if (this.modlauncher) {
                sb.append("<br>").append(MonitorDePID.idioma.faltar_de_clases_modlauncher());
            }
            if (this.minecraftforge) {
                sb.append("<br>").append(MonitorDePID.idioma.faltar_de_clases_minecraftforge());
            }
            if (this.neoforged) {
                sb.append("<br>").append(MonitorDePID.idioma.faltar_de_clases_neoforged());
            }
            if (this.fabricloader) {
                sb.append("<br>").append(MonitorDePID.idioma.faltar_de_clases_fabricloader());
            }
            if (this.pillowmc) {
                sb.append("<br>").append(MonitorDePID.idioma.faltar_de_clases_pillowmc());
            }
            if (!(!this.minecraft || this.create || this.epicfight || this.azurelib || this.featurecreep || this.dangerzone || this.minecraftforge || this.neoforged || this.fabricloader || this.pillowmc)) {
                sb.append("<br>").append(MonitorDePID.idioma.faltar_de_clases_minecraft());
            }
            this.mensaje = sb.toString();
        }
    }

    private String escapeHtml(String s) {
        return s.replace("&", "&amp;").replace("<", "<").replace(">", ">").replace("\"", "&quot;");
    }

    @Override
    public Verificaciones nueva() {
        return new ErrorMetodoInexistente();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1100.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_error_metodo_inexistente();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_metodo_inexistente()).agregarEtiqueta(MonitorDePID.idioma.paso2_metodo_inexistente()).construir();
    }

    @Override
    public String id() {
        return "error_metodo_inexistente";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return trazo.trace.contains("NoSuchMethodError");
    }

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

