/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.CDStringBuilder;
import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FallosEjecucionTareas
implements Verificaciones {
    private final Map<String, String> clasesConProblema = new HashMap<String, String>();
    private final Set<String> mensajesHtml = new HashSet<String>();
    private boolean activado = false;

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        String clase;
        if (linea.contains("Failed to execute task") && linea.contains(".class") && !(clase = this.extraerNombreClase(linea)).isEmpty()) {
            this.clasesConProblema.put(clase, consola.agregarErrorALectador(numero_de_linea, this));
            this.activado = true;
        }
    }

    private String extraerNombreClase(String linea) {
        try {
            String clasePosible;
            String resto;
            String[] partes;
            int inicio = linea.indexOf("Failed to execute task");
            if (inicio != -1 && (partes = (resto = linea.substring(inicio + "Failed to execute task".length()).trim()).split("\\s+")).length > 0 && (clasePosible = partes[0]).contains(".class")) {
                int indiceFin = clasePosible.indexOf(".class") + ".class".length();
                String clase = clasePosible.substring(0, indiceFin);
                clase = clase.replace("\"", "").replace("'", "").trim();
                return clase;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public String mensaje() {
        if (this.mensajesHtml.isEmpty() && !this.clasesConProblema.isEmpty()) {
            this.procesarResultados();
        }
        if (this.mensajesHtml.isEmpty()) {
            return "";
        }
        CDStringBuilder html = new CDStringBuilder();
        html.append("<ul>");
        for (String mensaje : this.mensajesHtml) {
            html.append("<li>").append(mensaje).append("</li>");
        }
        html.append("</ul>");
        return html.append(MonitorDePID.idioma.recomendacion_fallos_ejecucion()).toString();
    }

    private void procesarResultados() {
        Buscardor.cargar();
        String colorError = Config.obtenerInstancia().obtenerColorError();
        for (Map.Entry<String, String> entrada : this.clasesConProblema.entrySet()) {
            String clase = entrada.getKey();
            String enlace = entrada.getValue();
            List<ArchivoDeMod> modsRelacionados = Buscardor.buscarModsConTermino(clase.replace(".", "/"));
            StringBuilder mensaje = new StringBuilder();
            mensaje.append(MonitorDePID.idioma.fallo_ejecucion_tarea_descripcion(clase));
            if (!modsRelacionados.isEmpty()) {
                mensaje.append(" (");
                for (int i = 0; i < modsRelacionados.size(); ++i) {
                    mensaje.append(modsRelacionados.get(i).ubicacion_para_publicar());
                    if (i >= modsRelacionados.size() - 1) continue;
                    mensaje.append(", ");
                }
                mensaje.append(")");
            }
            String mensajeHtml = "<span style='color:#" + colorError + "'>" + mensaje.toString() + "</span> " + enlace;
            this.mensajesHtml.add(mensajeHtml);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new FallosEjecucionTareas();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 950.0f;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_fallos_ejecucion_tareas();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder constructor = new QuickFix.Builder(this.nombre());
        constructor.agregarEtiqueta(MonitorDePID.idioma.recomendacion_fallos_ejecucion());
        if (this.activado && !this.clasesConProblema.isEmpty()) {
            for (String clase : this.clasesConProblema.keySet()) {
                StringBuilder info = new StringBuilder();
                info.append(MonitorDePID.idioma.info_clase_problematica());
                info.append(" ");
                info.append(clase);
                List<ArchivoDeMod> modsRelacionados = Buscardor.buscarModsConTermino(clase.replace(".", "/"));
                if (!modsRelacionados.isEmpty()) {
                    info.append(" (");
                    for (int i = 0; i < modsRelacionados.size(); ++i) {
                        info.append(modsRelacionados.get(i).ubicacion_para_publicar());
                        if (i >= modsRelacionados.size() - 1) continue;
                        info.append(", ");
                    }
                    info.append(")");
                }
                constructor.agregarEtiqueta(info.toString());
            }
        } else {
            constructor.agregarEtiqueta(MonitorDePID.idioma.no_se_encontraron_clases_problema());
        }
        return constructor.construir();
    }

    @Override
    public String id() {
        return "fallos_ejecucion_tareas";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (trazo == null || trazo.trace == null || !this.activado) {
            return false;
        }
        String contenido = trazo.trace.toLowerCase();
        return contenido.contains("failed to execute task") && contenido.contains("class") && contenido.contains("executionexception");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

