/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.analizador.general.ModulesDuplicadosJavaModulePlatform;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FaltaModuleJPMS
implements Verificaciones {
    private boolean activado = false;
    private final Set<String> errores = new HashSet<String>();
    private final List<String> enlaces = new ArrayList<String>();
    private boolean posibleFaltaModulo = false;

    @Override
    public void verificar(Consola consola) {
        String contenidoConsola = consola.contenido_verificar;
        if (contenidoConsola == null || contenidoConsola.isEmpty()) {
            this.posibleFaltaModulo = false;
            return;
        }
        this.posibleFaltaModulo = contenidoConsola.contains("java.lang.module.FindException: Module ") && contenidoConsola.contains(" not found, required by ");
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (!this.posibleFaltaModulo || linea == null) {
            return;
        }
        if (linea.contains("java.lang.module.FindException: Module ") && linea.contains(" not found, required by ")) {
            try {
                String modNecesitado = linea.split("Module ")[1].split(" not found")[0].trim();
                String modRequeridor = linea.split("required by ")[1].trim();
                String mensaje = MonitorDePID.idioma.jpms_modules_faltas(modNecesitado, modRequeridor + ModulesDuplicadosJavaModulePlatform.procesarModulo(modRequeridor.trim()));
                if (this.errores.add(mensaje)) {
                    String enlace = consola.agregarErrorALectador(numero_de_linea, this);
                    this.enlaces.add(enlace);
                    this.activado = true;
                }
            }
            catch (Exception e) {
                consola.agregarErrorALectador(numero_de_linea, this);
            }
        }
    }

    @Override
    public Verificaciones nueva() {
        return new FaltaModuleJPMS();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        if (this.errores.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder("<ul>");
        Iterator<String> erroresIter = this.errores.iterator();
        Iterator<String> enlacesIter = this.enlaces.iterator();
        while (erroresIter.hasNext() && enlacesIter.hasNext()) {
            String error = erroresIter.next();
            String enlace = enlacesIter.next();
            html.append("<li>").append(error).append(" ").append(enlace).append("</li>");
        }
        html.append("</ul>");
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_falta_module_jmps();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionFaltasClases()).construir();
    }

    @Override
    public String id() {
        return "falta_module_jpms";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("java.lang.module.FindException: Module ") && t.contains(" not found, required by ");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

