/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import com.asbestosstar.crashdetector.mapas.TriMap;
import com.asbestosstar.crashdetector.waifu.RespuestaWaifu;
import com.asbestosstar.crashdetector.waifu.VersionWaifu;
import com.asbestosstar.crashdetector.waifu.WaifuAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FaltasClases
implements Verificaciones {
    private boolean activado = false;
    public boolean create = false;
    public boolean epicfight = false;
    public boolean azurelib = false;
    public boolean minecraft = false;
    public boolean dangerzone = false;
    public boolean featurecreep = false;
    public boolean modlauncher = false;
    public boolean minecraftforge = false;
    public boolean neoforged = false;
    public boolean fabricloader = false;
    public boolean pillowmc = false;
    private final Map<String, String> clases = new HashMap<String, String>();
    public static List<String> ignorar = new ArrayList<String>();
    public final Set<String> todos = new LinkedHashSet<String>();
    private final Map<String, String> enlacesPorClase = new HashMap<String, String>();
    private VerificacionDeStackTrace vdst;
    private Map<String, String> clasesFiltradas = null;
    private boolean postProcesado = false;

    @Override
    public void verificar(Consola consola) {
        this.vdst = consola.verificacion_de_stacktrace;
        String cont = consola.contenido_verificar;
        for (TriMap.TripleKey<String, Integer, Integer> llave : this.vdst.clases_fatales_no_existentes.keySet()) {
            String claseFormateada;
            String linea_menos1;
            String claseCruda = (String)llave.key1;
            int nivel_prioridad = (Integer)llave.key2;
            int numero_linea_consola = (Integer)llave.key3;
            String sospechoso = this.vdst.clases_fatales_no_existentes.get(claseCruda, nivel_prioridad, numero_linea_consola);
            if (numero_linea_consola > 0 && ((linea_menos1 = cont.split(nl)[numero_linea_consola - 1]).toLowerCase().contains("catching") || linea_menos1.toLowerCase().contains("rhino.CachedClassInfo")) || !this.esNombreClaseValido(claseFormateada = this.formatearClase(claseCruda)) || FaltasClases.ignorarClaseOLinea(claseFormateada) || this.esClaseNoRelevante(claseFormateada)) continue;
            String origenLimpio = this.limpiarOrigen(sospechoso);
            if (!this.todos.add(claseFormateada)) {
                String actual = this.clases.getOrDefault(claseFormateada, "");
                if (actual != null && !actual.isEmpty() || origenLimpio == null || origenLimpio.isEmpty()) continue;
                this.clases.put(claseFormateada, origenLimpio);
                continue;
            }
            this.clases.put(claseFormateada, origenLimpio);
            String enlace = consola.agregarErrorALectador(numero_linea_consola, this);
            this.enlacesPorClase.put(claseFormateada, enlace);
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        String origenPrevio;
        String linea_menos1;
        String candidato;
        int index;
        if (linea == null) {
            return;
        }
        if (linea.contains("/WARN]") || linea.contains("Warn") || VerificacionDeStackTrace.esLineaDeAdvertenciaEstandar(linea)) {
            return;
        }
        if (FaltasClases.ignorarClaseOLinea(linea)) {
            return;
        }
        int indiceDosPuntos = linea.indexOf(58);
        if (indiceDosPuntos != -1 && linea.charAt(0) == '[') {
            linea = linea.substring(indiceDosPuntos + 1).trim();
        }
        String claseCruda = null;
        if (linea.contains("java.lang.ClassNotFoundException:") || linea.contains("java.lang.NoClassDefFoundError:")) {
            String[] llevas;
            for (String lleva : llevas = new String[]{"java.lang.ClassNotFoundException:", "java.lang.NoClassDefFoundError:"}) {
                String candidato2;
                int index2 = linea.indexOf(lleva);
                if (index2 == -1 || (candidato2 = linea.substring(index2 + lleva.length()).trim()).isEmpty()) continue;
                claseCruda = candidato2.split("[\\s\\)]")[0].trim();
                break;
            }
        } else if (linea.contains("Error loading class:") && (index = linea.indexOf("Error loading class:")) != -1 && !(candidato = linea.substring(index + "Error loading class:".length()).trim()).isEmpty()) {
            claseCruda = candidato.split("[\\s\\)]")[0].trim();
        }
        if (claseCruda == null) {
            return;
        }
        if (numero_de_linea > 0 && ((linea_menos1 = consola.contenido_verificar.split(nl)[numero_de_linea - 1]).toLowerCase().contains("catching") || linea_menos1.toLowerCase().contains("rhino.CachedClassInfo"))) {
            return;
        }
        String claseFormateada = this.formatearClase(claseCruda);
        if (!this.esNombreClaseValido(claseFormateada)) {
            return;
        }
        if (this.esClaseNoRelevante(claseFormateada)) {
            return;
        }
        String origen = this.encontrarOrigenEnLinea(linea, numero_de_linea, consola);
        String origenLimpio = this.limpiarOrigen(origen);
        if ((origenLimpio == null || origenLimpio.isEmpty()) && (origenPrevio = this.buscarOrigenEnLineaAnterior(numero_de_linea, consola)) != null && !origenPrevio.isEmpty()) {
            origenLimpio = origenPrevio;
        }
        if (!this.todos.add(claseFormateada)) {
            String actual = this.clases.getOrDefault(claseFormateada, "");
            if ((actual == null || actual.isEmpty()) && origenLimpio != null && !origenLimpio.isEmpty()) {
                this.clases.put(claseFormateada, origenLimpio);
            }
            return;
        }
        this.clases.put(claseFormateada, origenLimpio);
        CrashDetectorLogger.log("Fatals clases clase no advertencia " + claseFormateada);
        String enlace = consola.agregarErrorALectador(numero_de_linea, this);
        this.enlacesPorClase.put(claseFormateada, enlace);
    }

    private boolean esClaseNoRelevante(String claseFormateada) {
        String c = claseFormateada.trim();
        return c.startsWith("gg/essential/") || c.startsWith("kotlin/") || c.startsWith("kotlinx/");
    }

    private boolean esLineaStackish(String l) {
        if (l == null) {
            return false;
        }
        String t = l.trim();
        if (t.startsWith("//")) {
            t = t.substring(2).trim();
        }
        return t.startsWith("at ") || t.startsWith("Caused by:") || t.startsWith("Suppressed:") || t.startsWith("...") || t.startsWith("SECURE-BOOTSTRAP");
    }

    private boolean esModidSospechoso(String modid) {
        if (modid == null) {
            return true;
        }
        return modid.length() <= 6 && modid.matches(".*\\d{3,}$");
    }

    private void postProcesarSiNecesario() {
        if (this.postProcesado) {
            return;
        }
        this.postProcesado = true;
        if (this.vdst != null && !this.clases.isEmpty()) {
            this.completarOrigenesSiFaltan(this.vdst);
        }
        this.clasesFiltradas = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> e : this.clases.entrySet()) {
            String clase = e.getKey();
            if (this.esClaseNoRelevante(clase)) continue;
            this.clasesFiltradas.put(clase, e.getValue());
        }
    }

    public static boolean ignorarClaseOLinea(String str) {
        for (String ign : ignorar) {
            if (!str.contains(ign)) continue;
            return true;
        }
        return false;
    }

    private String limpiarOrigen(String origen) {
        if (origen == null || origen.isEmpty()) {
            return "";
        }
        String o = origen.trim();
        if (o.endsWith(".jar") && !VerificacionDeStackTrace.isJarNoPermite(o)) {
            return o;
        }
        if (!(o.contains("/") || o.contains(".") || o.endsWith(".jar") || VerificacionDeStackTrace.esModNoPermite(o))) {
            return o;
        }
        List<String> jars_encontrados = VerificacionDeStackTrace.extraerJarsDeLinea(o);
        for (String jar : jars_encontrados) {
            if (!jar.contains(".jar") || VerificacionDeStackTrace.isJarNoPermite(jar)) continue;
            return jar;
        }
        String modid = VerificacionDeStackTrace.extraerModidDeLinea(o);
        if (modid != null && !VerificacionDeStackTrace.esModNoPermite(modid)) {
            return modid;
        }
        String paquete = VerificacionDeStackTrace.extraerPaqueteDeLinea(o);
        if (paquete != null && !this.esPaqueteNoPermitido(paquete)) {
            return paquete;
        }
        return "";
    }

    private boolean esPaqueteNoPermitido(String pack) {
        for (String prefijo : VerificacionDeStackTrace.package_no_permite) {
            if (!pack.startsWith(prefijo)) continue;
            return true;
        }
        return false;
    }

    private String encontrarOrigenEnLinea(String linea, int numeroLinea, Consola consola) {
        String anterior;
        String siguiente;
        int i;
        String resultado = this.buscarOrigenEnLinea(linea);
        if (!resultado.isEmpty()) {
            return resultado;
        }
        String[] lineas = consola.contenido_verificar.split(Verificaciones.nl);
        for (i = numeroLinea + 1; i < lineas.length && i <= numeroLinea + 50 && this.esLineaStackish(siguiente = lineas[i]); ++i) {
            resultado = this.buscarOrigenEnLinea(siguiente.trim());
            if (resultado.isEmpty()) continue;
            return resultado;
        }
        for (i = numeroLinea - 1; i >= 0 && i >= numeroLinea - 20 && this.esLineaStackish(anterior = lineas[i]); --i) {
            resultado = this.buscarOrigenEnLinea(anterior.trim());
            if (resultado.isEmpty()) continue;
            return resultado;
        }
        return "";
    }

    private String buscarOrigenEnLinea(String linea) {
        String modid;
        List<String> jarsEncontrados = VerificacionDeStackTrace.extraerJarsDeLinea(linea);
        for (String jar : jarsEncontrados) {
            if (!jar.contains(".jar") || VerificacionDeStackTrace.isJarNoPermite(jar)) continue;
            return jar;
        }
        if (!(linea.contains("handler$") || (modid = VerificacionDeStackTrace.extraerModidDeLinea(linea)) == null || VerificacionDeStackTrace.esModNoPermite(modid) || this.esModidSospechoso(modid))) {
            return modid;
        }
        String pack = VerificacionDeStackTrace.extraerPaqueteDeLinea(linea);
        if (pack != null && !this.esPaqueteNoPermitido(pack)) {
            return pack;
        }
        return "";
    }

    private String formatearClase(String clase) {
        int indiceEspacio;
        if (clase == null) {
            return "";
        }
        int indiceParentesis = clase.indexOf(40);
        if (indiceParentesis != -1) {
            clase = clase.substring(0, indiceParentesis).trim();
        }
        if ((indiceEspacio = clase.indexOf(32)) != -1) {
            clase = clase.substring(0, indiceEspacio).trim();
        }
        return clase.replace(".", "/");
    }

    private boolean esNombreClaseValido(String clase) {
        if (clase == null || clase.isEmpty()) {
            return false;
        }
        String dotForm = clase.replace('/', '.');
        return dotForm.matches("[a-zA-Z_][a-zA-Z0-9_\\$]*(\\.[a-zA-Z_][a-zA-Z0-9_\\$]*)+");
    }

    @Override
    public Verificaciones nueva() {
        return new FaltasClases();
    }

    @Override
    public boolean activado() {
        this.postProcesarSiNecesario();
        this.activado = this.clasesFiltradas != null && !this.clasesFiltradas.isEmpty();
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1025.0f;
    }

    @Override
    public String mensaje() {
        this.postProcesarSiNecesario();
        if (this.clasesFiltradas == null || this.clasesFiltradas.isEmpty()) {
            return "";
        }
        LinkedHashMap<String, String> clasesParaMostrar = new LinkedHashMap<String, String>(this.clasesFiltradas);
        for (Map.Entry<String, String> entry : this.clasesFiltradas.entrySet()) {
            String clase = entry.getKey();
            String origen = entry.getValue();
            if (!"org/sqlite/JDBC".equals(clase) || origen == null || !origen.toLowerCase().contains("voxy")) continue;
            clasesParaMostrar.remove(clase);
        }
        if (clasesParaMostrar.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder("<ul>");
        for (Map.Entry entry : clasesParaMostrar.entrySet()) {
            String claseFormateada = (String)entry.getKey();
            String valor = !((String)entry.getValue()).isEmpty() ? " (" + (String)entry.getValue() + ")" : "";
            String enlace = this.enlacesPorClase.getOrDefault(claseFormateada, "");
            if (claseFormateada.trim().startsWith("com/simibubi/create")) {
                this.create = true;
            }
            if (claseFormateada.trim().startsWith("yesman/epicfight")) {
                this.epicfight = true;
            }
            if (claseFormateada.trim().startsWith("mod/azure/azurelib")) {
                this.azurelib = true;
            }
            if (claseFormateada.trim().startsWith("net/minecraftforge")) {
                this.minecraftforge = true;
            }
            if (claseFormateada.trim().startsWith("featurecreep/") || claseFormateada.trim().startsWith("asbestosstar/")) {
                this.featurecreep = true;
            }
            if (claseFormateada.trim().startsWith("net/fabricmc/")) {
                this.fabricloader = true;
            }
            if (claseFormateada.trim().startsWith("net/neoforged/")) {
                this.neoforged = true;
            }
            if (claseFormateada.trim().startsWith("net/pillowmc/")) {
                this.pillowmc = true;
            }
            if ((claseFormateada.trim().startsWith("net/minecraft/") || claseFormateada.trim().startsWith("game/") || claseFormateada.trim().startsWith("juego/") || claseFormateada.trim().startsWith("obf/class_unknown")) && !claseFormateada.trim().startsWith("net/minecraftforge/")) {
                this.minecraft = true;
            }
            if (claseFormateada.trim().startsWith("dangerzone/")) {
                this.dangerzone = true;
            }
            html.append("<li>").append(claseFormateada).append(valor);
            if (!enlace.isEmpty()) {
                html.append(" ").append(enlace);
            }
            html.append("</li>");
        }
        html.append("</ul>");
        if (this.create) {
            html.append(MonitorDePID.idioma.faltar_de_clases_create());
        }
        if (this.epicfight) {
            html.append(MonitorDePID.idioma.faltar_de_clases_epicfight());
        }
        if (this.azurelib) {
            html.append(MonitorDePID.idioma.faltar_de_clases_azurelib());
        }
        if (this.minecraft) {
            html.append(MonitorDePID.idioma.faltar_de_clases_minecraft());
        }
        if (this.dangerzone) {
            html.append(MonitorDePID.idioma.faltar_de_clases_dangerzone());
        }
        if (this.featurecreep) {
            html.append(MonitorDePID.idioma.faltar_de_clases_featurecreep());
        }
        if (this.modlauncher) {
            html.append(MonitorDePID.idioma.faltar_de_clases_modlauncher());
        }
        if (this.minecraftforge) {
            html.append(MonitorDePID.idioma.faltar_de_clases_minecraftforge());
        }
        if (this.neoforged) {
            html.append(MonitorDePID.idioma.faltar_de_clases_neoforged());
        }
        if (this.fabricloader) {
            html.append(MonitorDePID.idioma.faltar_de_clases_fabricloader());
        }
        if (this.pillowmc) {
            html.append(MonitorDePID.idioma.faltar_de_clases_pillowmc());
        }
        return MonitorDePID.idioma.falta_de_clases_fatales() + html;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_faltar_de_clases();
    }

    private void completarOrigenesSiFaltan(VerificacionDeStackTrace vdst) {
        if (vdst == null || this.clases.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> e : this.clases.entrySet()) {
            String origen;
            String clase = e.getKey();
            if (this.esClaseNoRelevante(clase) || e.getValue() != null && !e.getValue().isEmpty() || (origen = this.inferirOrigenParaClase(clase, vdst)) == null || origen.isEmpty()) continue;
            e.setValue(origen);
        }
    }

    private String inferirOrigenParaClase(String claseSlash, VerificacionDeStackTrace vdst) {
        List<VerificacionDeStackTrace.TraceInfo> trazos;
        if (claseSlash == null || claseSlash.isEmpty() || vdst == null) {
            return "";
        }
        try {
            trazos = vdst.trazos_completos;
        }
        catch (Throwable t) {
            return "";
        }
        if (trazos == null || trazos.isEmpty()) {
            return "";
        }
        String paqueteClase = claseSlash.contains("/") ? claseSlash.substring(0, claseSlash.lastIndexOf(47)) : claseSlash;
        String mejorPaquete = "";
        String mejorModid = "";
        String mejorJar = "";
        for (VerificacionDeStackTrace.TraceInfo trace : trazos) {
            if (trace == null || trace.lineas == null) continue;
            for (VerificacionDeStackTrace.LineaTrazo lt : trace.lineas) {
                String limpio;
                if (lt == null) continue;
                String origen = lt.origen;
                String claseLinea = lt.clase;
                if (origen == null || origen.isEmpty()) continue;
                if (claseLinea != null && claseLinea.equals(claseSlash) && !(limpio = this.limpiarOrigen(origen)).isEmpty()) {
                    return limpio;
                }
                if (claseLinea != null && claseLinea.startsWith(paqueteClase)) {
                    String paqueteLinea;
                    String string = paqueteLinea = claseLinea.contains("/") ? claseLinea.substring(0, claseLinea.lastIndexOf(47)) : "";
                    if (!paqueteLinea.isEmpty() && paqueteClase.startsWith(paqueteLinea) && paqueteLinea.length() > mejorPaquete.length() && !this.esPaqueteNoPermitido(paqueteLinea)) {
                        mejorPaquete = paqueteLinea;
                    }
                }
                if (mejorModid.isEmpty() && !origen.contains("/") && !origen.endsWith(".jar") && !VerificacionDeStackTrace.esModNoPermite(origen) && !this.esModidSospechoso(origen) && paqueteClase.contains(origen)) {
                    mejorModid = origen;
                }
                if (!mejorJar.isEmpty() || !origen.endsWith(".jar") || VerificacionDeStackTrace.isJarNoPermite(origen)) continue;
                mejorJar = origen;
            }
        }
        if (!mejorPaquete.isEmpty()) {
            return mejorPaquete.replace('/', '.');
        }
        if (!mejorModid.isEmpty()) {
            return mejorModid;
        }
        if (!mejorJar.isEmpty()) {
            return mejorJar;
        }
        return "";
    }

    private String extraerJarDesdeClaveJars(String clave) {
        if (clave == null) {
            return null;
        }
        int p = clave.indexOf(".jar");
        if (p >= 0) {
            return clave.substring(0, p + 4);
        }
        return null;
    }

    private String extraerOrigenDeLineaModInstance(String linea) {
        if (linea == null) {
            return "";
        }
        String t = linea.trim();
        int idx = t.indexOf("ModID:");
        if (idx == -1) {
            return "";
        }
        String tail = t.substring(idx + "ModID:".length()).trim();
        String modid = tail.split("[,\\s]")[0].trim();
        if (modid.isEmpty()) {
            return "";
        }
        if (VerificacionDeStackTrace.esModNoPermite(modid)) {
            return "";
        }
        if (this.esModidSospechoso(modid)) {
            return "";
        }
        return modid;
    }

    private String buscarOrigenEnLineaAnterior(int numeroLinea, Consola consola) {
        if (consola == null) {
            return "";
        }
        String[] lineas = consola.contenido_verificar.split(Verificaciones.nl);
        if (numeroLinea <= 0 || numeroLinea >= lineas.length) {
            return "";
        }
        String anterior = lineas[numeroLinea - 1];
        return this.extraerOrigenDeLineaModInstance(anterior);
    }

    @Override
    public QuickFix solucion() {
        this.postProcesarSiNecesario();
        JComboBox<String> cargadorCombo = new JComboBox<String>();
        JComboBox<String> versionCombo = new JComboBox<String>();
        JComboBox<String> claseCombo = new JComboBox<String>();
        HashMap<String, List> versionesPorCargador = new HashMap<String, List>();
        for (VersionWaifu version : WaifuAPI.versiones) {
            versionesPorCargador.computeIfAbsent(version.cargador, k -> new ArrayList()).add(version.version_del_juego);
        }
        cargadorCombo.setModel(new DefaultComboBoxModel<String>(versionesPorCargador.keySet().toArray(new String[0])));
        cargadorCombo.addActionListener(e -> {
            String cargador = (String)cargadorCombo.getSelectedItem();
            if (cargador != null) {
                versionCombo.setModel(new DefaultComboBoxModel<String>(((List)versionesPorCargador.get(cargador)).toArray(new String[0])));
            }
        });
        Set<String> clavesCombo = this.clasesFiltradas != null ? this.clasesFiltradas.keySet() : this.clases.keySet();
        claseCombo.setModel(new DefaultComboBoxModel<String>(clavesCombo.toArray(new String[0])));
        if (cargadorCombo.getItemCount() > 0) {
            cargadorCombo.setSelectedIndex(0);
            versionCombo.setModel(new DefaultComboBoxModel<String>(((List)versionesPorCargador.get(cargadorCombo.getSelectedItem())).toArray(new String[0])));
        }
        if (claseCombo.getItemCount() > 0) {
            claseCombo.setSelectedIndex(0);
        }
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionFaltasClases()).agregarComponente(new QuickFix.SelectorGUI(cargadorCombo)).agregarComponente(new QuickFix.SelectorGUI(versionCombo)).agregarComponente(new QuickFix.SelectorGUI(claseCombo)).agregarBoton(MonitorDePID.idioma.buscar(), retener -> {
            ArrayList<RespuestaWaifu.Mod> modsEncontrados = new ArrayList<RespuestaWaifu.Mod>();
            String cargador = (String)cargadorCombo.getSelectedItem();
            String version = (String)versionCombo.getSelectedItem();
            String clase = (String)claseCombo.getSelectedItem();
            if (cargador != null && version != null && clase != null) {
                VersionWaifu versionSeleccionada = WaifuAPI.obtainerVersion(cargador, version);
                modsEncontrados.addAll(WaifuAPI.obtanerModDesdeClase(clase, versionSeleccionada));
                JTextArea textoResultados = new JTextArea(15, 40);
                textoResultados.setEditable(false);
                if (modsEncontrados.isEmpty()) {
                    textoResultados.setText(MonitorDePID.idioma.noResultados() + " " + clase);
                } else {
                    StringBuilder sb = new StringBuilder("Mods encontrados para ").append(clase).append(":\n");
                    for (RespuestaWaifu.Mod mod : modsEncontrados) {
                        sb.append("\nMod: ").append(mod.name);
                        if (mod.curseforgeProjectId != null) {
                            sb.append("\nCurseForge URL: https://api.waifu.neoforged.net/mod_url/").append(mod.curseforgeProjectId);
                        }
                        if (mod.modrinthProjectId != null) {
                            sb.append("\nModrinth URL: https://api.waifu.neoforged.net/mod_url/").append(mod.modrinthProjectId);
                        }
                        sb.append("\n-------------------");
                    }
                    textoResultados.setText(sb.toString());
                }
                JOptionPane.showMessageDialog(null, new JScrollPane(textoResultados), "Resultados de b\u00fasqueda", 1);
            }
        }, true).construir();
    }

    @Override
    public String id() {
        return "faltas_clases";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    static {
        ignorar.add("avaritia");
    }
}

