/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.awt.Desktop;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersiones
implements Verificaciones {
    private boolean activado = false;
    private final Set<String> mensajes = new HashSet<String>();
    private String claseConProblema = null;
    private final Pattern patronVersionClase = Pattern.compile("UnsupportedClassVersionError:\\s*([a-zA-Z0-9_/]+)\\s+has been compiled by a more recent version of the Java Runtime \\(class file version (\\d+)\\.0\\), this version of the Java Runtime only recognizes class file versions up to (\\d+)\\.0");

    @Override
    public void verificar(Consola consola) {
        String contenidoConsola = consola.contenido_verificar;
        Matcher matcher = this.patronVersionClase.matcher(contenidoConsola);
        while (matcher.find()) {
            this.claseConProblema = matcher.group(1).replace("/", ".");
            String versionCompilada = matcher.group(2);
            String versionActual = matcher.group(3);
            String versionJavaNecesaria = this.determinarVersionJava(versionCompilada);
            this.mensajes.add(MonitorDePID.idioma.javaObsoleta() + " JVM: " + versionJavaNecesaria);
            this.activado = true;
        }
        if (contenidoConsola.contains("Unsupported class file major version") && (contenidoConsola.contains("--fml.forgeVersion, 4") || contenidoConsola.contains("--fml.forgeVersion, 3")) && contenidoConsola.contains("java version 2") && !contenidoConsola.contains("java version 20") && !contenidoConsola.contains("java version 21")) {
            this.mensajes.add(MonitorDePID.idioma.java22());
            this.activado = true;
        }
        if (contenidoConsola.contains("has been compiled by a more recent version of the Java Runtime") && this.claseConProblema == null) {
            this.mensajes.add(MonitorDePID.idioma.javaObsoleta());
            this.activado = true;
        }
        if (contenidoConsola.contains("class jdk.internal.loader.ClassLoaders$AppClassLoader cannot be cast to class java.net.URLClassLoader")) {
            this.mensajes.add(MonitorDePID.idioma.errorCompatibilidadJava8());
            this.activado = true;
        }
        if (contenidoConsola.contains("java.base/jdk.internal.loader.ClassLoaders$AppClassLoader cannot be cast to java.base/java.net.URLClassLoader")) {
            this.mensajes.add(MonitorDePID.idioma.errorJava9NoSoportado());
            this.activado = true;
        }
        if (contenidoConsola.contains("net/minecraft/client/main/Main : Unsupported major.minor version 52.0")) {
            this.mensajes.add(MonitorDePID.idioma.errorJava8Requerido());
            this.activado = true;
        }
        if (contenidoConsola.contains("Open J9 is not supported") || contenidoConsola.contains("OpenJ9 is incompatible") || contenidoConsola.contains(".J9VMInternals")) {
            this.mensajes.add(MonitorDePID.idioma.openJ9NoSoportado());
            this.activado = true;
        }
        if (contenidoConsola.contains("no such method: sun.misc.Unsafe.defineAnonymousClass(Class,byte[],Object[])Class/invokeVirtual") || contenidoConsola.contains("java.lang.IllegalArgumentException: The requested compatibility level JAVA_11 could not be set. Level is not supported by the active JRE or ASM version")) {
            this.mensajes.add(MonitorDePID.idioma.necesitasJDK11());
            this.activado = true;
        }
    }

    private String determinarVersionJava(String versionClase) {
        int version = Integer.parseInt(versionClase);
        switch (version) {
            case 61: {
                return "17";
            }
            case 62: {
                return "18";
            }
            case 63: {
                return "19";
            }
            case 64: {
                return "20";
            }
            case 65: {
                return "21";
            }
            case 66: {
                return "22";
            }
        }
        if (version < 50) {
            return "1.6 o anterior";
        }
        if (version == 50) {
            return "1.6";
        }
        if (version == 51) {
            return "1.7";
        }
        if (version == 52) {
            return "1.8";
        }
        if (version == 53) {
            return "9";
        }
        if (version == 54) {
            return "10";
        }
        if (version == 55) {
            return "11";
        }
        if (version == 56) {
            return "12";
        }
        if (version == 57) {
            return "13";
        }
        if (version == 58) {
            return "14";
        }
        if (version == 59) {
            return "15";
        }
        if (version == 60) {
            return "16";
        }
        return "desconocida (" + version + ")";
    }

    @Override
    public Verificaciones nueva() {
        return new JavaVersiones();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 925.0f;
    }

    @Override
    public String mensaje() {
        if (this.mensajes.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder("<ul>");
        for (String msg : this.mensajes) {
            html.append("<li>").append(msg).append("</li>");
        }
        if (this.claseConProblema != null && !this.claseConProblema.isEmpty()) {
            html.append("<li><b>").append("Clase").append(":</b> ").append(this.claseConProblema).append("</li>");
        }
        html.append("</ul>");
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_java_versiones();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionParaJavaInstallar()).agregarBoton("Java Windows-x86_x64+Linux-x86_x64+SRC", bool -> this.abrirEnNavegador("https://developers.redhat.com/products/openjdk/download")).agregarBoton("Java Mac Intel", bool -> this.abrirEnNavegador("https://www.openlogic.com/openjdk-downloads")).agregarBoton("Java Mac PPC", bool -> this.abrirEnNavegador("https://github.com/nilsvanvelzen/mac_ppc_openjdk8u60")).agregarBoton("Java Sun Microsystems", bool -> this.abrirEnNavegador("https://www.oracle.com/java/technologies/downloads/")).agregarBoton("Java 15+ Solaris/Iluminos", bool -> this.abrirEnNavegador("https://pkgs.tribblix.org/openjdk/")).construir();
    }

    @Override
    private void abrirEnNavegador(String url) {
        try {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(new URI(url));
            }
        }
        catch (Exception e) {
            CrashDetectorLogger.logException(e);
        }
    }

    @Override
    public String id() {
        return "java_versiones";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

