/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import com.asbestosstar.crashdetector.json.Json;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class LanzerDesAnimado
implements Verificaciones {
    public static final Path ARCHIVO_DESANIMADOS = Statics.carpeta.resolve("lanzeres_desanimados.json");
    public static final Path ARCHIVO_ANIMADOS = Statics.carpeta.resolve("lanzeres_animados.json");
    private boolean activado = false;
    private String mensaje = "";
    boolean completa = false;

    @Override
    public void verificar(Consola consola) {
        Json.Nodo raiz;
        String contenido;
        if (this.completa) {
            return;
        }
        this.completa = true;
        String LANZADOR_ACTUAL = Statics.lanzer_del_app;
        if (LANZADOR_ACTUAL == null || LANZADOR_ACTUAL.trim().isEmpty()) {
            return;
        }
        if (!ARCHIVO_DESANIMADOS.toFile().exists()) {
            return;
        }
        try {
            contenido = new String(Files.readAllBytes(ARCHIVO_DESANIMADOS), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return;
        }
        if (contenido == null || contenido.trim().isEmpty()) {
            return;
        }
        try {
            raiz = Json.leer(contenido);
        }
        catch (Exception e) {
            return;
        }
        if (!raiz.esObjeto()) {
            return;
        }
        Json.Nodo entrada = raiz.obtener(LANZADOR_ACTUAL);
        if (entrada == null || entrada.esArreglo()) {
            return;
        }
        String motivo = "";
        if (entrada.esObjeto()) {
            String[] orden;
            String langActual = MonitorDePID.idioma.codigo();
            String langRespaldo = Idioma.idioma_respaldo.obtener();
            for (String lang : orden = new String[]{langActual, langRespaldo, "es"}) {
                String txt;
                Json.Nodo nodoMotivo;
                if (lang == null || lang.isEmpty() || (nodoMotivo = entrada.obtener(lang)) == null || nodoMotivo.esObjeto() || nodoMotivo.esArreglo() || (txt = nodoMotivo.comoCadena()) == null || txt.trim().isEmpty()) continue;
                motivo = txt;
                break;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MonitorDePID.idioma.lanzer_desanimado_titulo(LANZADOR_ACTUAL));
        if (!motivo.isEmpty()) {
            sb.append("<br>").append(motivo);
        }
        sb.append("<br>").append(MonitorDePID.idioma.lanzer_desanimado_problemas_comunes());
        if (ARCHIVO_ANIMADOS.toFile().exists()) {
            try {
                Json.Nodo raizAnim;
                String contenidoAnim = new String(Files.readAllBytes(ARCHIVO_ANIMADOS), StandardCharsets.UTF_8);
                if (contenidoAnim != null && !contenidoAnim.trim().isEmpty() && (raizAnim = Json.leer(contenidoAnim)).esArreglo() && raizAnim.tamano() > 0) {
                    sb.append("<br>").append(MonitorDePID.idioma.lanzer_desanimado_usar_animados());
                    sb.append(" ");
                    boolean primero = true;
                    for (int i = 0; i < raizAnim.tamano(); ++i) {
                        String id;
                        Json.Nodo item = raizAnim.en(i);
                        if (item == null || item.esObjeto() || item.esArreglo() || (id = item.comoCadena()) == null || id.trim().isEmpty()) continue;
                        if (!primero) {
                            sb.append(", ");
                        }
                        sb.append("<code>").append(id).append("</code>");
                        primero = false;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mensaje = sb.toString();
        this.activado = true;
    }

    @Override
    public Verificaciones nueva() {
        return new LanzerDesAnimado();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1400.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_lanzer_desanimado();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        builder.agregarEtiqueta(MonitorDePID.idioma.lanzer_desanimado_cambiar_lanzer());
        return builder.construir();
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public String id() {
        return "lanzer_desanimado";
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

