/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import com.asbestosstar.crashdetector.json.Json;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;

public class LanzerNoAnimado
implements Verificaciones {
    public static final Path ARCHIVO_ANIMADOS = Statics.carpeta.resolve("lanzeres_animados.json");
    private boolean activado = false;
    private String mensaje = "";
    boolean completa = false;

    @Override
    public void verificar(Consola consola) {
        Json.Nodo raiz;
        String contenido;
        if (this.completa) {
            return;
        }
        this.completa = true;
        String LANZADOR_ACTUAL = Statics.lanzer_del_app;
        if (LANZADOR_ACTUAL == null || LANZADOR_ACTUAL.trim().isEmpty()) {
            return;
        }
        CrashDetectorLogger.log("Lanzer Actual " + LANZADOR_ACTUAL);
        if (!ARCHIVO_ANIMADOS.toFile().exists()) {
            return;
        }
        try {
            contenido = new String(Files.readAllBytes(ARCHIVO_ANIMADOS), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return;
        }
        if (contenido == null || contenido.trim().isEmpty()) {
            return;
        }
        try {
            raiz = Json.leer(contenido);
        }
        catch (Exception e) {
            return;
        }
        if (!raiz.esArreglo()) {
            return;
        }
        HashSet<String> launchersAnimados = new HashSet<String>();
        int tam = raiz.tamano();
        for (int i = 0; i < tam; ++i) {
            String id;
            Json.Nodo item = raiz.en(i);
            if (item == null || item.esObjeto() || item.esArreglo() || (id = item.comoCadena()) == null || id.trim().isEmpty()) continue;
            launchersAnimados.add(id.trim());
        }
        if (launchersAnimados.isEmpty()) {
            return;
        }
        if (!launchersAnimados.contains(LANZADOR_ACTUAL.trim())) {
            StringBuilder sb = new StringBuilder();
            sb.append(MonitorDePID.idioma.lanzer_no_animado_titulo(LANZADOR_ACTUAL));
            sb.append("<br>").append(MonitorDePID.idioma.lanzer_no_animado_problemas_comunes());
            sb.append("<br>").append(MonitorDePID.idioma.lanzer_no_animado_usar_animados());
            sb.append(" ");
            boolean primero = true;
            for (String id : launchersAnimados) {
                if (!primero) {
                    sb.append(", ");
                }
                sb.append("<code>").append(id).append("</code>");
                primero = false;
            }
            this.mensaje = sb.toString();
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new LanzerNoAnimado();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1300.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_lanzer_no_animado();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        builder.agregarEtiqueta(MonitorDePID.idioma.lanzer_no_animado_cambiar_a_animado());
        return builder.construir();
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public String id() {
        return "lanzer_no_animado";
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

