/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.cargador.Cargador;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;

public class ModIncompatibleConCargadorActivo
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final List<String> modsIncompatibles = new ArrayList<String>();

    @Override
    public void verificar(Consola consola) {
        if (Cargador.cargadores_activados == null || Cargador.cargadores_activados.isEmpty()) {
            return;
        }
        Buscardor.cargar();
        this.modsIncompatibles.clear();
        for (ArchivoDeMod mod : Buscardor.mods) {
            boolean compatible = false;
            for (Cargador cargador : Cargador.cargadores_activados) {
                if (!cargador.modEsDeCargador(mod)) continue;
                compatible = true;
                break;
            }
            if (compatible) continue;
            String nombreMod = mod.ubicacion_para_publicar();
            this.modsIncompatibles.add(nombreMod);
        }
        if (!this.modsIncompatibles.isEmpty()) {
            this.mensaje = MonitorDePID.idioma.modIncompatibleConCargadorActivo(this.modsIncompatibles);
            this.activado = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Verificaciones nueva() {
        return new ModIncompatibleConCargadorActivo();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public float prioridad() {
        return 780.0f;
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionModIncompatibleConCargadorActivo()).construir();
    }

    @Override
    public String id() {
        return "mod_incompatible_con_cargador_activo";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreModIncompatibleConCargadorActivo();
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

