/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.CDStringBuilder;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.EliminadorDeMod;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;

public class ModulesDuplicadosJavaModulePlatform
implements Verificaciones {
    private boolean activado = false;
    private final CDStringBuilder mensajes = new CDStringBuilder();
    private String paqueteProblematico;
    private final Map<String, String> enlacesPorPaquete = new HashMap<String, String>();
    private boolean recolectando = false;
    private StringBuilder mensajeBuilder = null;
    private int indiceUltimaNoStack = -1;
    private Consola consolaRef = null;
    boolean mixinextras = false;

    @Override
    public void verificar(Consola consola) {
        String cont = consola.contenido_verificar;
        if (this.recolectando && this.consolaRef != null) {
            CrashDetectorLogger.log("Finalizando bloque pendiente al final del procesamiento");
            this.finalizarBloque(this.consolaRef, this.indiceUltimaNoStack >= 0 ? this.indiceUltimaNoStack : 0);
        }
        this.consolaRef = null;
    }

    @Override
    public void verificar(Consola consola, String lineaOriginal, int i) {
        boolean esCabecera;
        String linea = lineaOriginal.trim();
        String lineaMinuscula = linea.toLowerCase();
        boolean bl = esCabecera = lineaMinuscula.contains("java.lang.module.resolutionexception:") || lineaMinuscula.contains("contains package") || lineaMinuscula.contains("export package") || lineaMinuscula.contains("exports package") || lineaMinuscula.startsWith("exception in thread") && lineaMinuscula.contains("resolutionexception");
        if (esCabecera) {
            if (this.recolectando) {
                this.finalizarBloque(consola, i - 1);
            }
            this.recolectando = true;
            this.mensajeBuilder = new StringBuilder(linea);
            if (!linea.contains("\tat ")) {
                this.finalizarBloque(consola, i);
                this.recolectando = false;
            }
            return;
        }
        if (this.recolectando) {
            if (!linea.startsWith("\tat ")) {
                this.mensajeBuilder.append(" ").append(linea);
                this.indiceUltimaNoStack = i;
            } else {
                this.finalizarBloque(consola, this.indiceUltimaNoStack);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizarBloque(Consola consola, int indiceParaEnlace) {
        try {
            String[] partes;
            String mensajeCompleto = this.mensajeBuilder.toString().trim();
            String mensaje = mensajeCompleto.replace("Exception in thread \"main\" ", "").replace("java.lang.module.ResolutionException: ", "").trim();
            String modulosCombinados = "";
            String paquete = "";
            boolean encontrado = false;
            if (mensaje.toLowerCase().contains("modules") && mensaje.toLowerCase().contains("export package") && mensaje.toLowerCase().contains("to module")) {
                String parteModulos = mensaje.substring(0, mensaje.toLowerCase().indexOf("export package")).trim();
                if (parteModulos.toLowerCase().startsWith("modules")) {
                    parteModulos = parteModulos.substring("modules".length()).trim();
                }
                modulosCombinados = parteModulos.replace("and", "+").trim();
                int inicioPaquete = mensaje.toLowerCase().indexOf("export package") + "export package".length();
                int finPaquete = mensaje.toLowerCase().indexOf("to module");
                paquete = mensaje.substring(inicioPaquete, finPaquete).trim().replace("\"", "");
                encontrado = true;
                this.activado = true;
            }
            if (!encontrado && mensaje.toLowerCase().contains("contains package") && (partes = mensaje.split("contains package", 2)).length > 1) {
                modulosCombinados = partes[0].replace("Module", "").trim();
                String[] resto = partes[1].split("module ");
                if (resto.length > 1) {
                    paquete = resto[1].split(" ")[0].trim().replace("\"", "");
                    encontrado = true;
                    this.activado = true;
                }
            }
            if (encontrado && !paquete.isEmpty()) {
                this.paqueteProblematico = paquete;
                CrashDetectorLogger.log("paqueteProblematico " + this.paqueteProblematico);
                Buscardor.cargar();
                List<ArchivoDeMod> mods = Buscardor.buscarModsConTermino(paquete);
                String resultado = mods.isEmpty() ? "" : this.formatearResultadoBusqueda(mods);
                String enlace = consola.agregarErrorALectador(indiceParaEnlace, this);
                this.enlacesPorPaquete.put(paquete, enlace);
                StringBuilder mensajeFinal = new StringBuilder();
                mensajeFinal.append(MonitorDePID.idioma.module_resolution_exception());
                mensajeFinal.append("<br><br><b>").append(MonitorDePID.idioma.modulos()).append(":</b><br><ul>");
                for (String modulo : modulosCombinados.split("\\+")) {
                    String trim = modulo.trim();
                    mensajeFinal.append("<li>").append("<b>").append(trim).append("</b>").append(ModulesDuplicadosJavaModulePlatform.procesarModulo(trim)).append("</li>");
                }
                mensajeFinal.append("</ul>");
                if (modulosCombinados.contains("MixinExtras") || modulosCombinados.contains("mixinextras.neoforge")) {
                    this.mixinextras = true;
                    mensajeFinal.append("<br>").append(MonitorDePID.idioma.mixinExtrasDuplicados()).append("<br>");
                }
                mensajeFinal.append("<b>").append(MonitorDePID.idioma.paquete()).append(":</b><br>").append("<code>").append(paquete.replace(".", "/")).append("</code>");
                if (!mods.isEmpty()) {
                    mensajeFinal.append(" ").append(resultado);
                }
                mensajeFinal.append("<br>").append(enlace);
                this.mensajes.append(mensajeFinal.toString());
            }
        }
        catch (Exception e) {
            CrashDetectorLogger.logException(e);
        }
        finally {
            this.recolectando = false;
            this.mensajeBuilder = null;
            this.indiceUltimaNoStack = -1;
        }
    }

    public static String procesarModulo(String modulo) {
        List<String> mods = Buscardor.obtenerModsConNombre(modulo);
        if (!mods.isEmpty()) {
            return "(" + String.join((CharSequence)",", mods) + ")";
        }
        return "";
    }

    private String formatearResultadoBusqueda(List<ArchivoDeMod> mods) {
        if (mods.isEmpty()) {
            return "()";
        }
        String contenido = mods.stream().map(mod -> "<b>" + Buscardor.rutaParaPublicar(mod.ubicacion_para_publicar()) + "</b>").collect(Collectors.joining(", "));
        return "(" + contenido + ")";
    }

    @Override
    public Verificaciones nueva() {
        return new ModulesDuplicadosJavaModulePlatform();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        return this.mensajes.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_modules_duplicados_jmps();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(MonitorDePID.idioma.nombre_de_modules_duplicados_jmps());
        if (!this.activado || this.paqueteProblematico == null || this.paqueteProblematico.isEmpty()) {
            builder.agregarEtiqueta(MonitorDePID.idioma.no_se_puede_eliminar_paquete());
            return builder.construir();
        }
        List<ArchivoDeMod> mods = Buscardor.buscarModsConTermino(this.paqueteProblematico);
        if (mods.isEmpty()) {
            builder.agregarEtiqueta(MonitorDePID.idioma.no_se_encontraron_mods_con_paquete() + ": " + this.paqueteProblematico);
            return builder.construir();
        }
        for (ArchivoDeMod mod : mods) {
            String rutaMod = mod.ubicacion_para_publicar();
            String rutaPaquete = this.paqueteProblematico.replace('.', '/');
            String buttonText = MonitorDePID.idioma.eliminar_paquete() + ": " + rutaMod + " (" + this.paqueteProblematico + ")";
            builder.agregarBoton(buttonText, retener -> {
                block3: {
                    try {
                        EliminadorDeMod.eliminarElementoEnMod(rutaMod, rutaPaquete);
                        if (!EliminadorDeMod.esModoHeadless()) {
                            JOptionPane.showMessageDialog(null, MonitorDePID.idioma.paquete_eliminado_exitosamente() + ": " + this.paqueteProblematico + " en " + rutaMod, MonitorDePID.idioma.exito(), 1);
                        }
                    }
                    catch (Exception e) {
                        CrashDetectorLogger.logException(e);
                        if (EliminadorDeMod.esModoHeadless()) break block3;
                        JOptionPane.showMessageDialog(null, MonitorDePID.idioma.error_al_eliminar_paquete() + ": " + this.paqueteProblematico, MonitorDePID.idioma.error(), 0);
                    }
                }
            });
        }
        return builder.construir();
    }

    @Override
    public String id() {
        return "modules_duplicados_java_module_platform";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

