/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.CDStringBuilder;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class NoTieneMemoria
implements Verificaciones {
    private boolean activado = false;
    private final CDStringBuilder mensajes = new CDStringBuilder();
    private boolean esProblemaDeMemoriaInsuficiente = false;
    private boolean esProblemaDeMemoriaExcesiva = false;
    private boolean esProblemaPermGen = false;

    @Override
    public void verificar(Consola consola) {
        String contenidoConsola = consola.contenido_verificar;
        if (this.esProblemaMemoriaInsuficiente(contenidoConsola)) {
            this.esProblemaDeMemoriaInsuficiente = true;
            this.mensajes.append(MonitorDePID.idioma.noTieneMemoria()).append("<br>").append(MonitorDePID.idioma.recomendacionMemoria());
        }
        if (this.esProblemaMemoriaExcesiva(contenidoConsola)) {
            this.esProblemaDeMemoriaExcesiva = true;
            this.mensajes.append(MonitorDePID.idioma.memoriaExcesiva()).append("<br>").append(MonitorDePID.idioma.recomendacionMemoriaExcesiva());
        }
        if (contenidoConsola.contains("exit code: -805306369") || contenidoConsola.contains("exit code -805306369") || contenidoConsola.contains("PermGen error") || contenidoConsola.contains("java.lang.OutOfMemoryError: PermGen space")) {
            this.esProblemaPermGen = true;
            this.mensajes.append("<br>").append(MonitorDePID.idioma.permGenError());
            this.mensajes.append("<br>").append(MonitorDePID.idioma.noTieneMemoria());
        }
        if (this.esProblemaDeMemoriaInsuficiente || this.esProblemaDeMemoriaExcesiva || this.esProblemaPermGen) {
            this.verificarJVMMemoria();
            this.activado = true;
        }
    }

    private boolean esProblemaMemoriaInsuficiente(String contenidoConsola) {
        if (!contenidoConsola.contains("java.lang.OutOfMemoryError")) {
            return false;
        }
        if (contenidoConsola.contains("Could not reserve enough space for") || contenidoConsola.contains("The specified size exceeds the maximum representable size") || contenidoConsola.contains("Invalid maximum heap size") || contenidoConsola.contains("There is insufficient memory for the Java Runtime Environment to continue")) {
            return false;
        }
        return contenidoConsola.contains("Java heap space") || contenidoConsola.contains("GC overhead limit exceeded") || contenidoConsola.contains("Requested array size exceeds VM limit") || contenidoConsola.contains("Direct buffer memory") || contenidoConsola.contains("unable to create new native thread") || contenidoConsola.contains("Out of Memory Error") || contenidoConsola.contains("Too small maximum heap") || contenidoConsola.contains("Insufficient memory") || contenidoConsola.contains("Problem with RAM");
    }

    private boolean esProblemaMemoriaExcesiva(String contenidoConsola) {
        return contenidoConsola.contains("Could not reserve enough space for") || contenidoConsola.contains("The specified size exceeds the maximum representable size") || contenidoConsola.contains("Invalid maximum heap size") || contenidoConsola.contains("There is insufficient memory for the Java Runtime Environment to continue");
    }

    private void verificarJVMMemoria() {
        String modeloJVM = System.getProperty("sun.arch.data.model");
        String arquitecturaOS = System.getProperty("os.arch");
        boolean esJVM32Bits = false;
        if (modeloJVM != null && modeloJVM.equals("32")) {
            esJVM32Bits = true;
        } else if (arquitecturaOS != null) {
            boolean bl = esJVM32Bits = arquitecturaOS.matches("(i?[3-6]86|x86|ppc32|ppc|powerpc|armv\\d+)") || arquitecturaOS.endsWith("86") && System.getProperty("os.name").toLowerCase().contains("windows");
        }
        if (esJVM32Bits) {
            this.mensajes.append("<br>").append(MonitorDePID.idioma.error32BitMemoria());
        }
    }

    @Override
    public Verificaciones nueva() {
        return new NoTieneMemoria();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1400.0f;
    }

    @Override
    public String mensaje() {
        return this.mensajes.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_no_tiene_memoria();
    }

    @Override
    public QuickFix solucion() {
        CDStringBuilder solucion = new CDStringBuilder();
        if (this.esProblemaDeMemoriaInsuficiente) {
            solucion.append(MonitorDePID.idioma.aumentarMemoriaHeap()).append("<br>");
        }
        if (this.esProblemaDeMemoriaExcesiva) {
            solucion.append(MonitorDePID.idioma.disminuirMemoriaHeap()).append("<br>");
        }
        if (this.esProblemaPermGen) {
            solucion.append(MonitorDePID.idioma.aumentarMemoriaPermgen()).append("<br>");
        }
        solucion.append(MonitorDePID.idioma.utilizarJVM64Bits()).append("<br>").append(MonitorDePID.idioma.optimizarCodigo()).append("<br>").append(MonitorDePID.idioma.utilizarRecolectorBasuraEficiente());
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(solucion.toString()).construir();
    }

    @Override
    public String id() {
        return "no_tiene_memoria";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

