/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NullPointer
implements Verificaciones {
    private static final Pattern CABECERA_NPE = Pattern.compile("java\\.lang\\.NullPointerException(?::\\s*)?(.*)", 2);
    private static final Pattern FORMATO_CANNOT = Pattern.compile("Cannot\\s+(invoke|read|assign)[^\"]*\"([^\"]+)\"[^\"]*\"([^\"]+)\"");
    private static final Pattern ERROR_JSON = Pattern.compile("JsonObject\\.[a-zA-Z]+\\(\\).*\"([^\"]+)\" is null");
    private static final String NL = Verificaciones.nl;
    private final Map<String, Set<String>> errores = new HashMap<String, Set<String>>();
    private boolean activado = false;
    private final Map<String, String> enlacesPorLinea = new HashMap<String, String>();

    @Override
    public void verificar(Consola consola) {
        this.errores.clear();
        this.enlacesPorLinea.clear();
        this.activado = false;
        VerificacionDeStackTrace vdst = consola.verificacion_de_stacktrace;
        if (vdst == null || vdst.trazos_completos == null) {
            return;
        }
        for (VerificacionDeStackTrace.TraceInfo trace : vdst.trazos_completos) {
            if (trace == null || trace.trace == null || !trace.trace.contains("NullPointerException")) continue;
            String metodo = "m\u00e9todo desconocido";
            String objeto = "objeto";
            Matcher mCannot = FORMATO_CANNOT.matcher(trace.trace);
            Matcher mJson = ERROR_JSON.matcher(trace.trace);
            Matcher mCabecera = CABECERA_NPE.matcher(trace.trace);
            if (mCannot.find()) {
                metodo = mCannot.group(2);
                objeto = mCannot.group(3);
            } else if (mJson.find()) {
                metodo = "JsonObject.*()";
                objeto = mJson.group(1);
            } else {
                if (!mCabecera.find()) continue;
                String detalle = mCabecera.group(1).trim();
                if (!detalle.isEmpty()) {
                    metodo = detalle;
                }
            }
            String origen = this.inferirOrigenDesdeTrace(trace);
            String mensajeBase = MonitorDePID.idioma.null_pointer_error(metodo, objeto);
            this.enlacesPorLinea.putIfAbsent(mensajeBase, consola.agregarErrorALectador(trace.consolaLineaComenzar, this));
            this.errores.computeIfAbsent(mensajeBase, k -> new HashSet());
            if (!origen.isEmpty()) {
                this.errores.get(mensajeBase).add(origen);
            }
            this.activado = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int i) {
        if (linea.contains("NullPointerException") && !linea.contains("at ") && VerificacionDeStackTrace.tracePermite(linea)) {
            this.procesarLineaSinTraza(linea, consola.verificacion_de_stacktrace, i, consola);
        }
    }

    private void procesarLineaSinTraza(String linea, VerificacionDeStackTrace vdst, int numeroLinea, Consola consola) {
        String metodo = "desconocido";
        String objeto = "desconocido";
        Matcher mCannot = FORMATO_CANNOT.matcher(linea);
        Matcher mJson = ERROR_JSON.matcher(linea);
        if (mCannot.find()) {
            metodo = mCannot.group(2);
            objeto = mCannot.group(3);
        } else if (mJson.find()) {
            metodo = "JsonObject.*()";
            objeto = mJson.group(1);
        } else {
            return;
        }
        String origen = this.detectarOrigenEnLinea(linea, vdst, numeroLinea);
        String mensajeBase = MonitorDePID.idioma.null_pointer_error(metodo, objeto);
        this.enlacesPorLinea.put(mensajeBase, consola.agregarErrorALectador(numeroLinea, this));
        this.errores.computeIfAbsent(mensajeBase, k -> new HashSet());
        if (!origen.isEmpty()) {
            this.errores.get(mensajeBase).add(origen);
        }
        this.activado = true;
    }

    private String detectarOrigenEnTraza(String trazo, VerificacionDeStackTrace vdst, int lineaConsola) {
        String origen;
        String linea;
        int i;
        String[] lines = trazo.split(NL);
        for (i = 0; i < Math.min(lines.length, 5); ++i) {
            linea = lines[i];
            origen = this.detectarOrigenEnLinea(linea, vdst, lineaConsola + i);
            if (origen.isEmpty()) continue;
            return origen;
        }
        for (i = 5; i < lines.length; ++i) {
            linea = lines[i];
            origen = this.detectarOrigenEnLinea(linea, vdst, lineaConsola + i);
            if (origen.isEmpty()) continue;
            return origen;
        }
        return "";
    }

    private String detectarOrigenEnLinea(String linea, VerificacionDeStackTrace vdst, int numeroLineaConsola) {
        String representacion;
        List<String> jarsEncontrados = VerificacionDeStackTrace.extraerJarsDeLinea(linea);
        for (String jar : jarsEncontrados) {
            if (!jar.contains(".jar") || VerificacionDeStackTrace.isJarNoPermite(jar)) continue;
            return jar;
        }
        String modid = VerificacionDeStackTrace.extraerModidDeLinea(linea);
        if (modid != null && !VerificacionDeStackTrace.esModNoPermite(modid)) {
            return modid;
        }
        String pack = VerificacionDeStackTrace.extraerPaqueteDeLinea(linea);
        if (pack != null && !vdst.packNoEsPermite(pack, representacion = "0," + numeroLineaConsola, false)) {
            return pack;
        }
        return "";
    }

    private String inferirOrigenDesdeTrace(VerificacionDeStackTrace.TraceInfo trace) {
        if (trace == null || trace.lineas == null) {
            return "";
        }
        String mejorJar = "";
        String mejorModid = "";
        String mejorPaquete = "";
        for (VerificacionDeStackTrace.LineaTrazo lt : trace.lineas) {
            if (lt == null || lt.origen == null || lt.origen.isEmpty()) continue;
            String origen = lt.origen;
            if (origen.endsWith(".jar") && !VerificacionDeStackTrace.isJarNoPermite(origen)) {
                return origen;
            }
            if (!origen.contains("/") && !origen.endsWith(".jar") && !VerificacionDeStackTrace.esModNoPermite(origen) && mejorModid.isEmpty()) {
                mejorModid = origen;
            }
            if (!origen.contains("/")) continue;
            boolean permitido = true;
            for (String prefijo : VerificacionDeStackTrace.package_no_permite) {
                if (!origen.startsWith(prefijo)) continue;
                permitido = false;
                break;
            }
            if (!permitido || origen.length() <= mejorPaquete.length()) continue;
            mejorPaquete = origen;
        }
        if (!mejorModid.isEmpty()) {
            return mejorModid;
        }
        if (!mejorPaquete.isEmpty()) {
            return mejorPaquete;
        }
        return "";
    }

    @Override
    public Verificaciones nueva() {
        return new NullPointer();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 50.0f;
    }

    @Override
    public String mensaje() {
        if (this.errores.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<ul>");
        for (Map.Entry<String, Set<String>> entry : this.errores.entrySet()) {
            String enlace;
            String claveBase;
            String mensajeMostrado = claveBase = entry.getKey();
            Set<String> origenes = entry.getValue();
            if (!origenes.isEmpty()) {
                StringBuilder origenesStr = new StringBuilder();
                for (String origen : origenes) {
                    if (origenesStr.length() > 0) {
                        origenesStr.append(", ");
                    }
                    origenesStr.append(origen);
                }
                mensajeMostrado = mensajeMostrado + " (" + origenesStr.toString() + ")";
            }
            if (!(enlace = this.enlacesPorLinea.getOrDefault(claveBase, "")).isEmpty()) {
                mensajeMostrado = mensajeMostrado + " " + enlace;
            }
            sb.append("<li>").append(mensajeMostrado).append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_null_pointer();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "nullpointer";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

