/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import com.asbestosstar.crashdetector.parches.ConfigDeParches;
import com.asbestosstar.crashdetector.parches.minecraft.PreferIPv4StackParch;
import javax.swing.JOptionPane;

public class PreferIPV4Trace
implements Verificaciones {
    private boolean activado = false;
    private String enlaceHtml = "";
    private boolean seenConnectException = false;
    private boolean seenClosedChannelException = false;
    private boolean seenHttpClientImplSend = false;
    private boolean seenHttpClientFacadeSend = false;
    private boolean argIpv4Encontrado = false;
    private int firstExceptionLine = -1;
    public boolean gml = false;

    @Override
    public void verificar(Consola consola) {
        String propiedadIpv4;
        this.activado = false;
        if (consola.contenido_verificar.contains("gml")) {
            this.gml = true;
        }
        if ("true".equalsIgnoreCase(propiedadIpv4 = System.getProperty("java.net.preferIPv4Stack"))) {
            this.argIpv4Encontrado = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int i) {
        boolean errorIpv6;
        if (!this.argIpv4Encontrado && linea.trim().startsWith("JVM Flags:")) {
            this.argIpv4Encontrado = linea.contains("-Djava.net.preferIPv4Stack=true");
        }
        if (linea.contains("java.net.ConnectException")) {
            this.seenConnectException = true;
        }
        if (linea.contains("ClosedChannelException")) {
            this.seenClosedChannelException = true;
        }
        if (linea.contains("jdk.internal.net.http.HttpClientImpl.send(HttpClientImpl.java")) {
            this.seenHttpClientImplSend = true;
        }
        if (linea.contains("jdk.internal.net.http.HttpClientFacade.send(HttpClientFacade.java")) {
            this.seenHttpClientFacadeSend = true;
        }
        if (this.firstExceptionLine < 0 && linea.contains("java.net.ConnectException") && linea.contains("ClosedChannelException")) {
            this.firstExceptionLine = i;
        }
        boolean bl = errorIpv6 = this.seenConnectException && this.seenClosedChannelException && this.seenHttpClientImplSend && this.seenHttpClientFacadeSend;
        if (linea.contains("org.groovymc.gml.mappings.MappingsProvider.loadLayeredMappings")) {
            errorIpv6 = true;
            this.argIpv4Encontrado = false;
        }
        if (!this.activado && errorIpv6 && !this.argIpv4Encontrado) {
            this.activado = true;
            if (this.firstExceptionLine >= 0) {
                this.enlaceHtml = consola.agregarErrorALectador(this.firstExceptionLine, this);
            }
        }
        if (this.activado && this.enlaceHtml.isEmpty() && linea.contains("java.net.ConnectException") && linea.contains("ClosedChannelException")) {
            this.enlaceHtml = consola.agregarErrorALectador(i, this);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new PreferIPV4Trace();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        StringBuilder cons = new StringBuilder(MonitorDePID.idioma.tieneErrorIPV6());
        if (this.gml) {
            cons.append("<br>").append(MonitorDePID.idioma.gmlIPV6());
        }
        cons.append(" ").append(this.enlaceHtml);
        return cons.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.parcheIPv4();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(MonitorDePID.idioma.parcheIPv4()).agregarBoton(MonitorDePID.idioma.activar_parche(), retener -> {
            ConfigDeParches.obtenerInstancia().establecerActivo(PreferIPv4StackParch.id, true);
            JOptionPane.showMessageDialog(null, MonitorDePID.idioma.exito(), MonitorDePID.idioma.parcheIPv4(), 1);
        }, true).construir();
    }

    @Override
    public String id() {
        return "prefer_ipv4_trace";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

