/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ProblemaSafeFetch32JDK17
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final List<String> coincidencias = new ArrayList<String>();
    private static final Pattern PATRON_SAFE_FETCH = Pattern.compile("StubRoutines::SafeFetch32", 2);

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        if (PATRON_SAFE_FETCH.matcher(contenido).find()) {
            this.coincidencias.add("StubRoutines::SafeFetch32");
            this.activado = true;
            this.mensaje = MonitorDePID.idioma.problema_safe_fetch32_jdk17();
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaSafeFetch32JDK17();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 850.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_problema_safe_fetch32_jdk17();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_actualizar_jdk_macos());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_usar_lanzador_con_jdk_actualizado());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_desactivar_spark_mod());
        return builder.construir();
    }

    @Override
    public String id() {
        return "problema_safe_fetch32_jdk17";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

