/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.EliminadorDeMod;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import com.asbestosstar.crashdetector.mapas.BiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class SpongeMixinConfigsProblematicos
implements Verificaciones {
    private boolean activado = false;
    private final Map<String, Integer> sm_config_con_linea = new HashMap<String, Integer>();
    private final Map<String, Boolean> sm_config_es_fatal = new HashMap<String, Boolean>();
    private final Map<String, String> enlacesPorConfig = new HashMap<String, String>();

    @Override
    public void verificar(Consola consola) {
        this.sm_config_con_linea.clear();
        this.sm_config_es_fatal.clear();
        this.enlacesPorConfig.clear();
        BiMap<String, Integer, Boolean> configs = consola.verificacion_de_stacktrace.sm_config;
        for (BiMap.DoubleKey<String, Integer> clave : configs.keySet()) {
            String nombreArchivo = (String)clave.key0;
            int linea = (Integer)clave.key1;
            boolean esFatal = configs.get(nombreArchivo, linea);
            this.sm_config_con_linea.put(nombreArchivo, linea);
            this.sm_config_es_fatal.put(nombreArchivo, esFatal);
            this.enlacesPorConfig.put(nombreArchivo, consola.agregarErrorALectador(linea, this));
        }
        this.activado = !this.sm_config_con_linea.isEmpty();
    }

    @Override
    public void verificar(Consola consola, String linea, int i) {
        String nombre;
        int ini;
        int fin;
        if (linea.contains("The specified resource '") && linea.contains("' was invalid or could not be read") && (fin = linea.indexOf("'", ini = linea.indexOf("The specified resource '") + "The specified resource '".length())) > ini && (nombre = linea.substring(ini, fin).trim()).contains("mixins") && nombre.endsWith(".json") && !this.sm_config_con_linea.containsKey(nombre)) {
            this.sm_config_con_linea.put(nombre, i);
            this.sm_config_es_fatal.put(nombre, true);
            this.enlacesPorConfig.put(nombre, consola.agregarErrorALectador(i, this));
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new SpongeMixinConfigsProblematicos();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        if (this.sm_config_con_linea.isEmpty()) {
            return "";
        }
        Buscardor.cargar();
        StringBuilder html = new StringBuilder();
        html.append("<span style='color: #").append(Config.obtenerInstancia().obtenerColorDeTitulosDeConsolas()).append("; font-weight: bold;'>").append(MonitorDePID.idioma.config_spongemixin_problematico()).append("</span>").append("<br>").append("<ul>");
        ArrayList<String> listItems = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : this.sm_config_con_linea.entrySet()) {
            String sm = entry.getKey();
            int lineNumber = entry.getValue();
            boolean isFatal = this.sm_config_es_fatal.getOrDefault(sm, false);
            String jars_de_sm_string = "";
            List<String> jars_de_sm = Buscardor.obtenerUbicaciones(Buscardor.buscarModsConTermino(sm));
            if (!jars_de_sm.isEmpty()) {
                ArrayList<String> boldJars = new ArrayList<String>();
                for (String jar : jars_de_sm) {
                    boldJars.add("<strong>" + jar + "</strong>");
                }
                jars_de_sm_string = " (" + String.join((CharSequence)", ", boldJars) + ")";
            }
            String enlace = this.enlacesPorConfig.getOrDefault(sm, "");
            String prefix = isFatal ? MonitorDePID.idioma.posibilidad_fatal() : "";
            listItems.add("<li>" + prefix + sm + jars_de_sm_string + " " + enlace + "</li>");
        }
        html.append(String.join((CharSequence)"", listItems)).append("</ul>");
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_spongemixin_configs_problematicos();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(MonitorDePID.idioma.nombre_de_spongemixin_configs_problematicos());
        for (String sm : this.sm_config_con_linea.keySet()) {
            List<String> jars = Buscardor.obtenerUbicaciones(Buscardor.buscarModsConTermino(sm));
            for (String jar : jars) {
                String buttonText = MonitorDePID.idioma.eliminar() + ": " + jar;
                builder.agregarBoton(buttonText, retener -> {
                    block3: {
                        try {
                            EliminadorDeMod.eliminarMod(jar);
                            if (!EliminadorDeMod.esModoHeadless()) {
                                JOptionPane.showMessageDialog(null, MonitorDePID.idioma.jar_eliminado_exitosamente() + ": " + jar, MonitorDePID.idioma.exito(), 1);
                            }
                        }
                        catch (Exception e) {
                            CrashDetectorLogger.logException(e);
                            if (EliminadorDeMod.esModoHeadless()) break block3;
                            JOptionPane.showMessageDialog(null, MonitorDePID.idioma.error_al_eliminar_jar() + ": " + jar, MonitorDePID.idioma.error(), 0);
                        }
                    }
                });
            }
        }
        return builder.construir();
    }

    @Override
    public String id() {
        return "spongemixin_configs_problematicos";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }
}

