/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import com.asbestosstar.crashdetector.json.Json;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TienesModDesAnimado
implements Verificaciones {
    public static final Path ARCHIVO_DESANIMADOS = Statics.carpeta.resolve("mods_desanimados.json");
    private boolean activado = false;
    private String mensaje = "";
    private boolean activarCD = false;
    boolean completa = false;

    @Override
    public void verificar(Consola consola) {
        Json.Nodo raiz;
        String contenido;
        if (this.completa) {
            return;
        }
        this.completa = true;
        if (!ARCHIVO_DESANIMADOS.toFile().exists()) {
            return;
        }
        try {
            contenido = new String(Files.readAllBytes(ARCHIVO_DESANIMADOS), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return;
        }
        if (contenido == null || contenido.trim().isEmpty()) {
            return;
        }
        try {
            raiz = Json.leer(contenido);
        }
        catch (Exception e) {
            return;
        }
        if (!raiz.esArreglo()) {
            return;
        }
        HashSet<String> rutasInstaladas = new HashSet<String>();
        HashSet<String> modidsInstalados = new HashSet<String>();
        try {
            if (MonitorDePID.ultimo_mods != null && Files.exists(MonitorDePID.ultimo_mods, new LinkOption[0])) {
                Set<String> desdeArchivo = TienesModDesAnimado.obtenerMods(MonitorDePID.ultimo_mods);
                rutasInstaladas.addAll(desdeArchivo);
            }
        }
        catch (Exception desdeArchivo) {
            // empty catch block
        }
        try {
            List<ArchivoDeMod> desdeRecursivo = Buscardor.obtenerTodosLosModsYSubmodsRecursivos();
            if (desdeRecursivo != null) {
                for (ArchivoDeMod mod : desdeRecursivo) {
                    String ubic;
                    if (!mod.nombre().isEmpty()) {
                        modidsInstalados.addAll(mod.nombre());
                    }
                    if ((ubic = mod.ubicacion_para_publicar()) == null || ubic.isEmpty()) continue;
                    String rel = ubic.replace(MonitorDePID.ultimo_mods.toString(), ".");
                    rutasInstaladas.add(rel);
                }
            }
        }
        catch (Exception desdeRecursivo) {
            // empty catch block
        }
        HashSet<String> ubicacionesCoincidentes = new HashSet<String>();
        int tam = raiz.tamano();
        for (int i = 0; i < tam; ++i) {
            Json.Nodo nodoRuta;
            Json.Nodo item = raiz.en(i);
            if (item == null || !item.esObjeto()) continue;
            String modid = null;
            String ruta = null;
            boolean abrirCD = false;
            Json.Nodo nodoModid = item.obtener("modid");
            if (nodoModid != null && !nodoModid.esObjeto() && !nodoModid.esArreglo()) {
                modid = nodoModid.comoCadena();
            }
            if ((nodoRuta = item.obtener("ruta")) != null && !nodoRuta.esObjeto() && !nodoRuta.esArreglo()) {
                ruta = nodoRuta.comoCadena();
            }
            if (modid == null && ruta == null) continue;
            Json.Nodo nodoAbrir = item.obtener("abrir_cd_si_coincide");
            if (nodoAbrir != null) {
                try {
                    abrirCD = nodoAbrir.comoBooleano();
                }
                catch (Exception ignored) {
                    abrirCD = false;
                }
            }
            boolean encontrado = false;
            if (modid != null && !modid.trim().isEmpty()) {
                try {
                    List<String> rutasPorModid = Buscardor.obtenerModsConNombre(modid);
                    if (rutasPorModid != null) {
                        for (String rutaAbs : rutasPorModid) {
                            String rel = rutaAbs.replace(MonitorDePID.ultimo_mods.toString(), ".");
                            if (!rutasInstaladas.contains(rel)) continue;
                            ubicacionesCoincidentes.add(rel);
                            encontrado = true;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!encontrado && ruta != null && !ruta.trim().isEmpty()) {
                for (String ubic : rutasInstaladas) {
                    if (!ubic.contains(ruta)) continue;
                    ubicacionesCoincidentes.add(ubic);
                    encontrado = true;
                    break;
                }
            }
            if (!encontrado || !abrirCD) continue;
            this.activarCD = true;
        }
        if (!ubicacionesCoincidentes.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(MonitorDePID.idioma.tienes_mod_desanimado_titulo());
            sb.append("<ul>");
            for (String ubic : ubicacionesCoincidentes) {
                sb.append("<li><code>").append(ubic).append("</code></li>");
            }
            sb.append("</ul>");
            block17: for (int i = 0; i < tam; ++i) {
                String[] orden;
                Json.Nodo nodoRazon;
                Json.Nodo item = raiz.en(i);
                if (item == null || !item.esObjeto() || (nodoRazon = item.obtener("razon")) == null || !nodoRazon.esObjeto()) continue;
                String langActual = MonitorDePID.idioma.codigo();
                String langRespaldo = Idioma.idioma_respaldo.obtener();
                for (String lang : orden = new String[]{langActual, langRespaldo, "es"}) {
                    String txt;
                    Json.Nodo nodoTxt;
                    if (lang == null || lang.isEmpty() || (nodoTxt = nodoRazon.obtener(lang)) == null || nodoTxt.esObjeto() || nodoTxt.esArreglo() || (txt = nodoTxt.comoCadena()) == null || txt.trim().isEmpty()) continue;
                    sb.append("<p>").append(txt).append("</p>");
                    continue block17;
                }
            }
            this.mensaje = sb.toString();
            this.activado = true;
        }
    }

    private static Set<String> obtenerMods(Path archivo) throws IOException {
        return Files.readAllLines(archivo).stream().filter(line -> !line.trim().isEmpty()).map(line -> line.replace(MonitorDePID.ultimo_mods.toString(), ".")).collect(Collectors.toSet());
    }

    @Override
    public Verificaciones nueva() {
        return new TienesModDesAnimado();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1250.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_tienes_mod_desanimado();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        builder.agregarEtiqueta(MonitorDePID.idioma.tienes_mod_desanimado_eliminar());
        return builder.construir();
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public String id() {
        return "tienes_mod_desanimado";
    }

    @Override
    public boolean anularNormal() {
        return this.activarCD;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/general/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

