/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.anon;

import java.io.File;

public class AnonimizadorDeRuta {
    public static String anonimizarNombreDeUsuario(String rutaOriginal) {
        String directorioHome = System.getProperty("user.home");
        if (directorioHome == null || directorioHome.isEmpty()) {
            return rutaOriginal;
        }
        File archivo = new File(rutaOriginal);
        if (!archivo.isAbsolute()) {
            return rutaOriginal;
        }
        try {
            String directorioActual = System.getProperty("user.dir");
            File directorioActualFile = new File(directorioActual);
            String directorioActualCanonico = directorioActualFile.getCanonicalPath();
            File directorioHomeFile = new File(directorioHome);
            String directorioHomeCanonico = directorioHomeFile.getCanonicalPath();
            String archivoCanonico = archivo.getCanonicalPath();
            if (archivoCanonico.startsWith(directorioActualCanonico)) {
                return "." + archivoCanonico.substring(directorioActualCanonico.length());
            }
            if (archivoCanonico.startsWith(directorioHomeCanonico)) {
                return "~" + archivoCanonico.substring(directorioHomeCanonico.length());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rutaOriginal;
    }
}

