/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.api_sito_registro;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.api_sito_registro.DemasiadoGrande;
import com.asbestosstar.crashdetector.api_sito_registro.ErrorConPublicar;
import com.asbestosstar.crashdetector.api_sito_registro.LimteDeTasa;
import com.asbestosstar.crashdetector.api_sito_registro.NoAPIdeRegistro;
import com.asbestosstar.crashdetector.mapas.BiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface APIdeSitioDeRegistro {
    public static final List<APIdeSitioDeRegistro> APIS = new ArrayList<APIdeSitioDeRegistro>();

    public static APIdeSitioDeRegistro obtenerAPIdeConfig() throws NoAPIdeRegistro {
        String nom = Config.obtenerInstancia().obtenerApiSeleccionada();
        for (APIdeSitioDeRegistro reg : APIS) {
            if (!reg.nombre().equals(nom)) continue;
            return reg;
        }
        throw new NoAPIdeRegistro();
    }

    public String nombre();

    public String publicarRegistro(Consola var1) throws DemasiadoGrande, ErrorConPublicar;

    public String publicarTexto(String var1, String var2) throws DemasiadoGrande, LimteDeTasa, ErrorConPublicar;

    public List<String> sitiosPorDefecto();

    public static String sitioDeConfig() {
        return Config.obtenerInstancia().obtenerSitioDeRegistrosSeleccionado();
    }

    default public List<String> publicarRegistroEnPartes(Consola registro) throws DemasiadoGrande, ErrorConPublicar, NoAPIdeRegistro, LimteDeTasa {
        String nombre = registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt";
        String contenido = registro.obtainerContenidoParaPublicar();
        String enlace = this.publicarTexto(nombre, contenido);
        ArrayList<String> lista = new ArrayList<String>();
        lista.add(enlace);
        return lista;
    }

    public boolean soporteEnlacesALinea();

    default public String obtenerEnlaceDeLinea(int linea_numera) {
        int n = Math.max(1, linea_numera);
        String gid = this.grupoActual().get();
        if (gid == null) {
            return "#L" + n;
        }
        for (Map.Entry<BiMap.DoubleKey<String, Integer>, ParteInfo> e : this.indicePartes().entrySet()) {
            BiMap.DoubleKey<String, Integer> dk = e.getKey();
            if (!Objects.equals(dk.key0, gid)) continue;
            ParteInfo p = e.getValue();
            if (n < p.desde || n > p.hasta) continue;
            int lineaLocal = n - p.desde + 1;
            return p.url + "#L" + lineaLocal;
        }
        return "#L" + n;
    }

    public ThreadLocal<String> grupoActual();

    public BiMap<String, Integer, ParteInfo> indicePartes();

    default public void registrarGrupoActual(String grupoId) {
        this.grupoActual().set(grupoId);
    }

    default public void registrarParte(String grupoId, int parteIndexBase1, String url, int desde, int hasta) {
        this.indicePartes().put(grupoId, parteIndexBase1, new ParteInfo(url, desde, hasta));
    }

    public static class ParteInfo {
        final String url;
        final int desde;
        final int hasta;

        ParteInfo(String url, int desde, int hasta) {
            this.url = url;
            this.desde = desde;
            this.hasta = hasta;
        }
    }
}

