/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.api_sito_registro;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.api_sito_registro.APIdeSitioDeRegistro;
import com.asbestosstar.crashdetector.api_sito_registro.DemasiadoGrande;
import com.asbestosstar.crashdetector.api_sito_registro.ErrorConPublicar;
import com.asbestosstar.crashdetector.api_sito_registro.LimteDeTasa;
import com.asbestosstar.crashdetector.api_sito_registro.NoAPIdeRegistro;
import com.asbestosstar.crashdetector.mapas.BiMap;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class CrashDetectorPasteAPI
implements APIdeSitioDeRegistro {
    private static final String UA = "CrashDetector/1.x (+crashdetector-php)";
    private static final int TIMEOUT = 30000;
    private final BiMap<String, Integer, APIdeSitioDeRegistro.ParteInfo> indicePartes = new BiMap();
    private final ThreadLocal<String> grupoActual = new ThreadLocal();

    @Override
    public String nombre() {
        return "CrashDetectorPaste";
    }

    @Override
    public List<String> sitiosPorDefecto() {
        ArrayList<String> sitios = new ArrayList<String>();
        sitios.add("https://asbestosstar.egoism.jp/crash_detector/paste/endpoint.php?action=save_log");
        return sitios;
    }

    private String normalizarEndpoint(String s) {
        if (s == null || s.isEmpty()) {
            return "https://asbestosstar.egoism.jp/crash_detector/paste/endpoint.php?action=save_log";
        }
        String basePhp = "endpoint.php";
        if (s.endsWith("?")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.contains(basePhp) && !s.contains("action=save_log")) {
            s = s.contains("?") ? s + "&action=save_log" : s + "?action=save_log";
        }
        return s;
    }

    private static byte[] comprimirGZIP(byte[] datos) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gz = new GZIPOutputStream(baos);){
            gz.write(datos);
        }
        return baos.toByteArray();
    }

    private static String leer(InputStream is) {
        String string;
        if (is == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        try {
            String l;
            StringBuilder sb = new StringBuilder();
            while ((l = br.readLine()) != null) {
                sb.append(l);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        br.close();
        return string;
    }

    private static String extraerLinkDeJson(String json) {
        int pos;
        if (json == null) {
            return null;
        }
        String clave = "\"link\"";
        int i = json.indexOf(clave);
        if (i < 0) {
            return null;
        }
        int dosPuntos = json.indexOf(58, i);
        if (dosPuntos < 0) {
            return null;
        }
        for (pos = dosPuntos + 1; pos < json.length() && Character.isWhitespace(json.charAt(pos)); ++pos) {
        }
        if (pos >= json.length() || json.charAt(pos) != '\"') {
            return null;
        }
        int fin = json.indexOf(34, pos + 1);
        if (fin < 0) {
            return null;
        }
        return json.substring(pos + 1, fin);
    }

    @Override
    public String publicarTexto(String nombreSugerido, String contenido) throws ErrorConPublicar {
        try {
            byte[] datos = (contenido == null ? "" : contenido).getBytes(StandardCharsets.UTF_8);
            String endpoint = this.normalizarEndpoint(APIdeSitioDeRegistro.sitioDeConfig());
            URL url = new URL(endpoint);
            byte[] gzData = CrashDetectorPasteAPI.comprimirGZIP(datos);
            HttpURLConnection con = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            con.setRequestMethod("POST");
            con.setConnectTimeout(30000);
            con.setReadTimeout(30000);
            con.setRequestProperty("User-Agent", UA);
            con.setRequestProperty("Content-Type", "application/octet-stream");
            con.setRequestProperty("Content-Encoding", "gzip");
            con.setDoOutput(true);
            con.setFixedLengthStreamingMode(gzData.length);
            try (OutputStream os = con.getOutputStream();){
                os.write(gzData);
            }
            int code = con.getResponseCode();
            if (code != 200) {
                String err = CrashDetectorPasteAPI.leer(con.getErrorStream());
                throw new ErrorConPublicar("CrashDetectorPaste HTTP " + code + (err == null ? "" : ": " + err));
            }
            String body = CrashDetectorPasteAPI.leer(con.getInputStream());
            String link = CrashDetectorPasteAPI.extraerLinkDeJson(body);
            if (link == null || link.isEmpty()) {
                throw new ErrorConPublicar("Respuesta sin link");
            }
            return link.replace("\\/", "/");
        }
        catch (Exception ex) {
            throw new ErrorConPublicar(ex.getMessage());
        }
    }

    @Override
    public String publicarRegistro(Consola registro) {
        try {
            return this.publicarTexto(registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt", registro.obtainerContenidoParaPublicar());
        }
        catch (ErrorConPublicar e) {
            CrashDetectorLogger.logException(e);
            return null;
        }
    }

    @Override
    public boolean soporteEnlacesALinea() {
        return true;
    }

    @Override
    public ThreadLocal<String> grupoActual() {
        return this.grupoActual;
    }

    @Override
    public BiMap<String, Integer, APIdeSitioDeRegistro.ParteInfo> indicePartes() {
        return this.indicePartes;
    }

    @Override
    public List<String> publicarRegistroEnPartes(Consola registro) throws DemasiadoGrande, ErrorConPublicar, NoAPIdeRegistro, LimteDeTasa {
        String contenido = registro.obtainerContenidoParaPublicar();
        if (contenido == null) {
            contenido = "";
        }
        int LIMITE_GZIP = 0x1400000;
        int PRESUPUESTO_RAW = 0x1600000;
        byte[] sinComprimir = contenido.getBytes(StandardCharsets.UTF_8);
        if (sinComprimir.length <= 0x1400000) {
            String base = registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt";
            String url = this.publicarTexto(base, contenido);
            ArrayList<String> unica = new ArrayList<String>();
            unica.add(url);
            String gid = this.grupoActual().get();
            if (gid != null) {
                int totalLineas = contenido.isEmpty() ? 0 : contenido.split("\n", -1).length;
                this.registrarParte(gid, 1, url, 1, Math.max(1, totalLineas));
            }
            return unica;
        }
        ArrayList<String> urls = new ArrayList<String>();
        String[] lineas = contenido.split("\n", -1);
        StringBuilder parte = new StringBuilder();
        int bytesParte = 0;
        int lineaDesde = 1;
        int acumuladas = 0;
        int indiceParte = 1;
        String gid = this.grupoActual().get();
        for (int i = 0; i < lineas.length; ++i) {
            String l = lineas[i];
            String candidata = parte.length() == 0 ? l : "\n" + l;
            int bytesCand = candidata.getBytes(StandardCharsets.UTF_8).length;
            if (bytesParte + bytesCand <= 0x1600000) {
                parte.append(candidata);
                bytesParte += bytesCand;
                ++acumuladas;
                continue;
            }
            try {
                String izquierda;
                byte[] gzIzq;
                byte[] gz = CrashDetectorPasteAPI.comprimirGZIP(parte.toString().getBytes(StandardCharsets.UTF_8));
                if (gz.length <= 0x1400000) {
                    String u = this.publicarParte(registro, indiceParte, parte.toString());
                    urls.add(u);
                    if (gid != null) {
                        this.registrarParte(gid, indiceParte++, u, lineaDesde, lineaDesde + acumuladas - 1);
                        lineaDesde += acumuladas;
                    }
                    parte.setLength(0);
                    bytesParte = 0;
                    acumuladas = 0;
                    --i;
                    continue;
                }
                int mid = parte.length() / 2;
                int split = parte.lastIndexOf("\n", mid);
                if (split <= 0) {
                    split = mid;
                }
                if ((gzIzq = CrashDetectorPasteAPI.comprimirGZIP((izquierda = parte.substring(0, split)).getBytes(StandardCharsets.UTF_8))).length > 0x1400000) {
                    int q = parte.length() / 4;
                    int s2 = parte.lastIndexOf("\n", q);
                    if (s2 > 0) {
                        split = s2;
                    }
                    izquierda = parte.substring(0, split);
                    gzIzq = CrashDetectorPasteAPI.comprimirGZIP(izquierda.getBytes(StandardCharsets.UTF_8));
                }
                String u = this.publicarParte(registro, indiceParte, izquierda);
                urls.add(u);
                if (gid != null) {
                    int lineasIzq = izquierda.isEmpty() ? 0 : izquierda.split("\n", -1).length;
                    this.registrarParte(gid, indiceParte++, u, lineaDesde, lineaDesde + lineasIzq - 1);
                    lineaDesde += lineasIzq;
                }
                String derecha = parte.substring(split);
                parte.setLength(0);
                parte.append(derecha);
                bytesParte = derecha.getBytes(StandardCharsets.UTF_8).length;
                acumuladas = derecha.isEmpty() ? 0 : derecha.split("\n", -1).length;
                --i;
                continue;
            }
            catch (Exception ex) {
                throw new ErrorConPublicar(ex.getMessage());
            }
        }
        if (parte.length() > 0) {
            String u = this.publicarParte(registro, indiceParte, parte.toString());
            urls.add(u);
            if (gid != null) {
                this.registrarParte(gid, indiceParte, u, lineaDesde, lineaDesde + acumuladas - 1);
            }
        }
        return urls;
    }

    private String publicarParte(Consola registro, int indiceParte, String texto) throws ErrorConPublicar {
        String base = registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt";
        String nombre = indiceParte > 1 ? base + " (parte " + indiceParte + ")" : base;
        return this.publicarTexto(nombre, texto);
    }
}

