/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.api_sito_registro;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.api_sito_registro.APIdeSitioDeRegistro;
import com.asbestosstar.crashdetector.api_sito_registro.DemasiadoGrande;
import com.asbestosstar.crashdetector.api_sito_registro.ErrorConPublicar;
import com.asbestosstar.crashdetector.mapas.BiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class MCLogsAPI
implements APIdeSitioDeRegistro {
    private static final int ESPACIO_MAXIMO_BYTES = 0xA00000;
    private static final int LINEAS_MAXIMAS = 25000;
    private static final int TIMEOUT_MS = 30000;
    private static final String UA = "CrashDetector/1.x (+mclogs)";
    private final BiMap<String, Integer, APIdeSitioDeRegistro.ParteInfo> indicePartes = new BiMap();
    private final ThreadLocal<String> grupoActual = new ThreadLocal();

    @Override
    public String nombre() {
        return "mclogs";
    }

    @Override
    public String publicarRegistro(Consola registro) throws DemasiadoGrande, ErrorConPublicar {
        String contenido;
        String string = contenido = registro.obtainerContenidoParaPublicar() == null ? "" : registro.obtainerContenidoParaPublicar().trim();
        if (contenido.isEmpty()) {
            throw new ErrorConPublicar("El contenido del registro est\u00e1 vac\u00edo");
        }
        byte[] bytesContenido = contenido.getBytes(StandardCharsets.UTF_8);
        if (bytesContenido.length > 0xA00000) {
            throw new DemasiadoGrande();
        }
        int cantidadLineas = contenido.split("\n", -1).length;
        if (cantidadLineas > 25000) {
            throw new DemasiadoGrande();
        }
        try {
            String datosPost = "content=" + URLEncoder.encode(contenido, StandardCharsets.UTF_8.toString());
            byte[] body = datosPost.getBytes(StandardCharsets.UTF_8);
            URL url = new URL(APIdeSitioDeRegistro.sitioDeConfig());
            HttpURLConnection conexion = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            conexion.setRequestMethod("POST");
            conexion.setConnectTimeout(30000);
            conexion.setReadTimeout(30000);
            conexion.setRequestProperty("User-Agent", UA);
            conexion.setRequestProperty("Accept-Charset", "utf-8");
            conexion.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            conexion.setDoOutput(true);
            conexion.setFixedLengthStreamingMode(body.length);
            try (OutputStream salida = conexion.getOutputStream();){
                salida.write(body);
            }
            int codigoRespuesta = conexion.getResponseCode();
            if (codigoRespuesta != 200) {
                throw new ErrorConPublicar("C\u00f3digo de error HTTP: " + codigoRespuesta);
            }
            StringBuilder respuesta = new StringBuilder();
            try (BufferedReader lector = new BufferedReader(new InputStreamReader(conexion.getInputStream(), StandardCharsets.UTF_8));){
                String linea;
                while ((linea = lector.readLine()) != null) {
                    respuesta.append(linea);
                }
            }
            String respuestaStr = respuesta.toString();
            if (respuestaStr.contains("\"success\":true")) {
                return this.extraerUrlDeRespuesta(respuestaStr);
            }
            String error = this.extraerErrorDeRespuesta(respuestaStr);
            throw new ErrorConPublicar("Error del servidor: " + error);
        }
        catch (IOException e) {
            throw new ErrorConPublicar("Error de red: " + e.getMessage());
        }
    }

    @Override
    public List<String> sitiosPorDefecto() {
        ArrayList<String> sitios = new ArrayList<String>();
        sitios.add("https://api.mclo.gs/1/log");
        return sitios;
    }

    private String extraerUrlDeRespuesta(String respuestaJson) {
        int inicio = respuestaJson.indexOf("\"url\":\"");
        if (inicio < 0) {
            return null;
        }
        int fin = respuestaJson.indexOf("\"", inicio += 7);
        if (fin < 0) {
            return null;
        }
        String url = respuestaJson.substring(inicio, fin);
        return url.replace("\\", "");
    }

    private String extraerErrorDeRespuesta(String respuestaJson) {
        int inicio = respuestaJson.indexOf("\"error\":\"");
        if (inicio < 0) {
            return "desconocido";
        }
        int fin = respuestaJson.indexOf("\"", inicio += 9);
        if (fin < 0) {
            fin = respuestaJson.length();
        }
        return respuestaJson.substring(inicio, fin).replace("\\\"", "\"");
    }

    @Override
    public String publicarTexto(String nombreSugerido, String contenido) throws DemasiadoGrande, ErrorConPublicar {
        String texto;
        String string = texto = contenido == null ? "" : contenido.trim();
        if (texto.isEmpty()) {
            throw new ErrorConPublicar("El contenido del registro est\u00e1 vac\u00edo");
        }
        byte[] bytesContenido = texto.getBytes(StandardCharsets.UTF_8);
        if (bytesContenido.length > 0xA00000) {
            throw new DemasiadoGrande();
        }
        int cantidadLineas = texto.split("\n", -1).length;
        if (cantidadLineas > 25000) {
            throw new DemasiadoGrande();
        }
        try {
            String datosPost = "content=" + URLEncoder.encode(texto, StandardCharsets.UTF_8.toString());
            byte[] body = datosPost.getBytes(StandardCharsets.UTF_8);
            URL url = new URL(APIdeSitioDeRegistro.sitioDeConfig());
            HttpURLConnection conexion = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            conexion.setRequestMethod("POST");
            conexion.setConnectTimeout(30000);
            conexion.setReadTimeout(30000);
            conexion.setRequestProperty("User-Agent", UA);
            conexion.setRequestProperty("Accept-Charset", "utf-8");
            conexion.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            conexion.setDoOutput(true);
            conexion.setFixedLengthStreamingMode(body.length);
            try (OutputStream salida = conexion.getOutputStream();){
                salida.write(body);
            }
            int codigoRespuesta = conexion.getResponseCode();
            if (codigoRespuesta != 200) {
                throw new ErrorConPublicar("C\u00f3digo de error HTTP: " + codigoRespuesta);
            }
            StringBuilder respuesta = new StringBuilder();
            try (BufferedReader lector = new BufferedReader(new InputStreamReader(conexion.getInputStream(), StandardCharsets.UTF_8));){
                String linea;
                while ((linea = lector.readLine()) != null) {
                    respuesta.append(linea);
                }
            }
            String respuestaStr = respuesta.toString();
            if (respuestaStr.contains("\"success\":true")) {
                return this.extraerUrlDeRespuesta(respuestaStr);
            }
            String error = this.extraerErrorDeRespuesta(respuestaStr);
            throw new ErrorConPublicar("Error del servidor: " + error);
        }
        catch (IOException e) {
            throw new ErrorConPublicar("Error de red: " + e.getMessage());
        }
    }

    @Override
    public List<String> publicarRegistroEnPartes(Consola registro) throws ErrorConPublicar, DemasiadoGrande {
        String contenido = registro.obtainerContenidoParaPublicar() == null ? "" : registro.obtainerContenidoParaPublicar();
        try {
            String unico = this.publicarTexto(registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt", contenido);
            ArrayList<String> una = new ArrayList<String>();
            una.add(unico);
            String gid = this.grupoActual().get();
            if (gid != null) {
                int totalLineas = contenido.split("\n", -1).length;
                this.registrarParte(gid, 1, unico, 1, totalLineas);
            }
            return una;
        }
        catch (DemasiadoGrande unico) {
            int MAX_BYTES = 0xA00000;
            int MAX_LINEAS = 25000;
            String[] lineas = contenido.split("\n", -1);
            ArrayList<String> partes = new ArrayList<String>();
            StringBuilder bloque = new StringBuilder();
            int lineasBloque = 0;
            int bytesBloque = 0;
            for (String linea : lineas) {
                boolean cortaPorBytes;
                String conSalto = linea + "\n";
                int bytesLinea = conSalto.getBytes(StandardCharsets.UTF_8).length;
                boolean cortaPorLineas = lineasBloque + 1 > 25000;
                boolean bl = cortaPorBytes = bytesBloque + bytesLinea > 0xA00000;
                if (cortaPorLineas || cortaPorBytes) {
                    partes.add(bloque.toString());
                    bloque.setLength(0);
                    lineasBloque = 0;
                    bytesBloque = 0;
                }
                bloque.append(conSalto);
                ++lineasBloque;
                bytesBloque += bytesLinea;
            }
            if (bloque.length() > 0) {
                partes.add(bloque.toString());
            }
            ArrayList<String> enlaces = new ArrayList<String>();
            String nombreBase = registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt";
            String gid = this.grupoActual().get();
            int lineaDesde = 1;
            for (int i = 0; i < partes.size(); ++i) {
                String etiqueta = partes.size() == 1 ? nombreBase : nombreBase + " (parte " + (i + 1) + ")";
                String bloqueTxt = (String)partes.get(i);
                String url = this.publicarTexto(etiqueta, bloqueTxt);
                enlaces.add(url);
                if (gid == null) continue;
                int lineasEnParte = bloqueTxt.split("\n", -1).length;
                int lineaHasta = lineaDesde + lineasEnParte - 1;
                this.registrarParte(gid, i + 1, url, lineaDesde, lineaHasta);
                lineaDesde = lineaHasta + 1;
            }
            return enlaces;
        }
    }

    @Override
    public boolean soporteEnlacesALinea() {
        return true;
    }

    @Override
    public ThreadLocal<String> grupoActual() {
        return this.grupoActual;
    }

    @Override
    public BiMap<String, Integer, APIdeSitioDeRegistro.ParteInfo> indicePartes() {
        return this.indicePartes;
    }
}

