/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.api_sito_registro;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.api_sito_registro.APIdeSitioDeRegistro;
import com.asbestosstar.crashdetector.api_sito_registro.DemasiadoGrande;
import com.asbestosstar.crashdetector.api_sito_registro.ErrorConPublicar;
import com.asbestosstar.crashdetector.api_sito_registro.LimteDeTasa;
import com.asbestosstar.crashdetector.api_sito_registro.NoAPIdeRegistro;
import com.asbestosstar.crashdetector.mapas.BiMap;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class PastesDevAPI
implements APIdeSitioDeRegistro {
    private static final String UA = "CrashDetector/1.x (+pastes.dev)";
    private static final int TIMEOUT = 30000;
    private final BiMap<String, Integer, APIdeSitioDeRegistro.ParteInfo> indicePartes = new BiMap();
    private final ThreadLocal<String> grupoActual = new ThreadLocal();

    @Override
    public String nombre() {
        return "PastesDev";
    }

    @Override
    public List<String> sitiosPorDefecto() {
        ArrayList<String> sitios = new ArrayList<String>();
        sitios.add("https://api.pastes.dev/post");
        return sitios;
    }

    private String normalizarEndpoint(String s) {
        if (s == null || s.isEmpty()) {
            return "https://api.pastes.dev/post";
        }
        if (s.endsWith("?")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.equalsIgnoreCase("https://api.pastes.dev") || s.equalsIgnoreCase("https://api.pastes.dev/")) {
            s = "https://api.pastes.dev/post";
        }
        return s;
    }

    private static byte[] comprimirGZIP(byte[] datos) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gz = new GZIPOutputStream(baos);){
            gz.write(datos);
        }
        return baos.toByteArray();
    }

    private static String leer(InputStream is) {
        String string;
        if (is == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        try {
            String l;
            StringBuilder sb = new StringBuilder();
            while ((l = br.readLine()) != null) {
                sb.append(l);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        br.close();
        return string;
    }

    private static String extraerKeyDeLocation(String location) {
        int slash;
        String apiBase;
        if (location == null || location.isEmpty()) {
            return null;
        }
        String loc = location.trim();
        if (loc.startsWith(apiBase = "https://api.pastes.dev/")) {
            loc = loc.substring(apiBase.length());
        }
        if (loc.startsWith("/")) {
            loc = loc.substring(1);
        }
        return (slash = loc.indexOf(47)) >= 0 ? loc.substring(0, slash) : loc;
    }

    private static String extraerKeyDeJson(String json) {
        int pos;
        if (json == null) {
            return null;
        }
        String key = "\"key\"";
        int i = json.indexOf(key);
        if (i < 0) {
            return null;
        }
        int colon = json.indexOf(58, i);
        if (colon < 0) {
            return null;
        }
        for (pos = colon + 1; pos < json.length() && Character.isWhitespace(json.charAt(pos)); ++pos) {
        }
        if (pos >= json.length() || json.charAt(pos) != '\"') {
            return null;
        }
        int fin = json.indexOf(34, pos + 1);
        if (fin < 0) {
            return null;
        }
        return json.substring(pos + 1, fin);
    }

    @Override
    public String publicarTexto(String nombreSugerido, String contenido) throws ErrorConPublicar {
        try {
            byte[] datos = (contenido == null ? "" : contenido).getBytes(StandardCharsets.UTF_8);
            String endpoint = this.normalizarEndpoint(APIdeSitioDeRegistro.sitioDeConfig());
            URL url = new URL(endpoint);
            byte[] gzData = PastesDevAPI.comprimirGZIP(datos);
            HttpURLConnection con = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            con.setRequestMethod("POST");
            con.setConnectTimeout(30000);
            con.setReadTimeout(30000);
            con.setRequestProperty("User-Agent", UA);
            con.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
            con.setRequestProperty("Content-Encoding", "gzip");
            con.setDoOutput(true);
            con.setFixedLengthStreamingMode(gzData.length);
            try (OutputStream os = con.getOutputStream();){
                os.write(gzData);
            }
            int code = con.getResponseCode();
            if (code != 201 && code != 200) {
                String err = PastesDevAPI.leer(con.getErrorStream());
                throw new ErrorConPublicar("PastesDev HTTP " + code + (err == null ? "" : ": " + err));
            }
            String location = con.getHeaderField("Location");
            String key = PastesDevAPI.extraerKeyDeLocation(location);
            if (key == null || key.isEmpty()) {
                String body = PastesDevAPI.leer(con.getInputStream());
                key = PastesDevAPI.extraerKeyDeJson(body);
            }
            if (key == null || key.isEmpty()) {
                throw new ErrorConPublicar("PastesDev sin clave en la respuesta");
            }
            return "https://pastes.dev/" + key;
        }
        catch (Exception ex) {
            throw new ErrorConPublicar(ex.getMessage());
        }
    }

    @Override
    public String publicarRegistro(Consola registro) {
        try {
            return this.publicarTexto(registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt", registro.obtainerContenidoParaPublicar());
        }
        catch (ErrorConPublicar e) {
            CrashDetectorLogger.logException(e);
            return null;
        }
    }

    @Override
    public boolean soporteEnlacesALinea() {
        return true;
    }

    @Override
    public ThreadLocal<String> grupoActual() {
        return this.grupoActual;
    }

    @Override
    public BiMap<String, Integer, APIdeSitioDeRegistro.ParteInfo> indicePartes() {
        return this.indicePartes;
    }

    @Override
    public List<String> publicarRegistroEnPartes(Consola registro) throws DemasiadoGrande, ErrorConPublicar, NoAPIdeRegistro, LimteDeTasa {
        String contenido = registro.obtainerContenidoParaPublicar();
        if (contenido == null) {
            contenido = "";
        }
        int LIMITE_GZIP = 0xF00000;
        int PRESUPUESTO_RAW = 0x1100000;
        byte[] sinComprimir = contenido.getBytes(StandardCharsets.UTF_8);
        if (sinComprimir.length <= 0xF00000) {
            String base = registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt";
            String url = this.publicarTexto(base, contenido);
            ArrayList<String> unica = new ArrayList<String>();
            unica.add(url);
            String gid = this.grupoActual().get();
            if (gid != null) {
                int totalLineas = contenido.isEmpty() ? 0 : contenido.split("\n", -1).length;
                this.registrarParte(gid, 1, url, 1, Math.max(1, totalLineas));
            }
            return unica;
        }
        ArrayList<String> urls = new ArrayList<String>();
        String[] lineas = contenido.split("\n", -1);
        StringBuilder parte = new StringBuilder();
        int bytesParte = 0;
        int lineaDesde = 1;
        int acumuladas = 0;
        int indiceParte = 1;
        String gid = this.grupoActual().get();
        for (int i = 0; i < lineas.length; ++i) {
            String l = lineas[i];
            String candidata = parte.length() == 0 ? l : "\n" + l;
            int bytesCand = candidata.getBytes(StandardCharsets.UTF_8).length;
            if (bytesParte + bytesCand <= 0x1100000) {
                parte.append(candidata);
                bytesParte += bytesCand;
                ++acumuladas;
                continue;
            }
            try {
                String izquierda;
                byte[] gzIzq;
                byte[] gz = PastesDevAPI.comprimirGZIP(parte.toString().getBytes(StandardCharsets.UTF_8));
                if (gz.length <= 0xF00000) {
                    String u = this.publicarParte(registro, indiceParte, parte.toString());
                    urls.add(u);
                    if (gid != null) {
                        this.registrarParte(gid, indiceParte++, u, lineaDesde, lineaDesde + acumuladas - 1);
                        lineaDesde += acumuladas;
                    }
                    parte.setLength(0);
                    bytesParte = 0;
                    acumuladas = 0;
                    --i;
                    continue;
                }
                int mid = parte.length() / 2;
                int split = parte.lastIndexOf("\n", mid);
                if (split <= 0) {
                    split = mid;
                }
                if ((gzIzq = PastesDevAPI.comprimirGZIP((izquierda = parte.substring(0, split)).getBytes(StandardCharsets.UTF_8))).length > 0xF00000) {
                    int q = parte.length() / 4;
                    int s2 = parte.lastIndexOf("\n", q);
                    if (s2 > 0) {
                        split = s2;
                    }
                    izquierda = parte.substring(0, split);
                    gzIzq = PastesDevAPI.comprimirGZIP(izquierda.getBytes(StandardCharsets.UTF_8));
                }
                String u = this.publicarParte(registro, indiceParte, izquierda);
                urls.add(u);
                if (gid != null) {
                    int lineasIzq = izquierda.isEmpty() ? 0 : izquierda.split("\n", -1).length;
                    this.registrarParte(gid, indiceParte++, u, lineaDesde, lineaDesde + lineasIzq - 1);
                    lineaDesde += lineasIzq;
                }
                String derecha = parte.substring(split);
                parte.setLength(0);
                parte.append(derecha);
                bytesParte = derecha.getBytes(StandardCharsets.UTF_8).length;
                acumuladas = derecha.isEmpty() ? 0 : derecha.split("\n", -1).length;
                --i;
                continue;
            }
            catch (Exception ex) {
                throw new ErrorConPublicar(ex.getMessage());
            }
        }
        if (parte.length() > 0) {
            String u = this.publicarParte(registro, indiceParte, parte.toString());
            urls.add(u);
            if (gid != null) {
                this.registrarParte(gid, indiceParte, u, lineaDesde, lineaDesde + acumuladas - 1);
            }
        }
        return urls;
    }

    private String publicarParte(Consola registro, int indiceParte, String texto) throws ErrorConPublicar {
        String base = registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt";
        String nombre = indiceParte > 1 ? base + " (parte " + indiceParte + ")" : base;
        return this.publicarTexto(nombre, texto);
    }
}

