/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.api_sito_registro;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.api_sito_registro.APIdeSitioDeRegistro;
import com.asbestosstar.crashdetector.api_sito_registro.ErrorConPublicar;
import com.asbestosstar.crashdetector.api_sito_registro.LimteDeTasa;
import com.asbestosstar.crashdetector.mapas.BiMap;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;

public class SecureLoggerAPI
implements APIdeSitioDeRegistro {
    private static final int TIMEOUT_MS = 30000;
    private static final String CHARSET_BODY = "windows-1251";
    private static final int LIMITE_GZIP = 0xA00000;
    private static final int PRESUPUESTO_RAW = 0xB00000;
    private final BiMap<String, Integer, APIdeSitioDeRegistro.ParteInfo> indicePartes = new BiMap();
    private final ThreadLocal<String> grupoActual = new ThreadLocal();

    @Override
    public String nombre() {
        return "SecureLogger";
    }

    @Override
    public List<String> sitiosPorDefecto() {
        ArrayList<String> sitios = new ArrayList<String>();
        sitios.add("https://securelogger.net/save/log?");
        sitios.add("https://securelogger.top/save/log?");
        sitios.add("https://ruzone.securelogger.net/save/log?");
        return sitios;
    }

    @Override
    public String publicarRegistro(Consola registro) throws ErrorConPublicar {
        try {
            String req = this.logRequest("USER_CODE", registro.obtainerContenidoParaPublicar());
            String link = SecureLoggerAPI.extraerEnlace(req);
            if (link == null || link.isEmpty()) {
                throw new ErrorConPublicar("Respuesta sin enlace de SecureLogger");
            }
            return link;
        }
        catch (LimteDeTasa lt) {
            throw new ErrorConPublicar(MonitorDePID.idioma.limite_de_solicitudes());
        }
        catch (Exception e) {
            throw new ErrorConPublicar(e.getMessage());
        }
    }

    public static String extraerEnlace(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        String key = "\"link\"";
        int keyIndex = jsonString.indexOf(key);
        if (keyIndex < 0) {
            return null;
        }
        int valueStart = jsonString.indexOf(58, keyIndex);
        if (valueStart < 0) {
            return null;
        }
        ++valueStart;
        while (valueStart < jsonString.length() && Character.isWhitespace(jsonString.charAt(valueStart))) {
            ++valueStart;
        }
        if (valueStart >= jsonString.length() || jsonString.charAt(valueStart) != '\"') {
            return null;
        }
        int valueEnd = jsonString.indexOf(34, valueStart + 1);
        if (valueEnd < 0) {
            return null;
        }
        return jsonString.substring(valueStart + 1, valueEnd);
    }

    public String logRequest(String tipoCliente, String contenidoLog) throws LimteDeTasa {
        try {
            String parametros = "version=" + URLEncoder.encode("2.923", "UTF-8") + "&clientType=" + URLEncoder.encode(tipoCliente, "UTF-8");
            String urlCompleta = APIdeSitioDeRegistro.sitioDeConfig() + parametros;
            byte[] cuerpo = (contenidoLog == null ? "" : contenidoLog).getBytes(Charset.forName(CHARSET_BODY));
            return this.enviarPost(new URL(urlCompleta), cuerpo);
        }
        catch (LimteDeTasa e) {
            throw e;
        }
        catch (Exception e) {
            CrashDetectorLogger.logException(e);
            return "Error: " + e.getMessage();
        }
    }

    private String enviarPost(URL url, byte[] cuerpo) throws IOException, LimteDeTasa {
        HttpURLConnection conexion = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
        conexion.setRequestMethod("POST");
        conexion.setConnectTimeout(30000);
        conexion.setReadTimeout(30000);
        conexion.setRequestProperty("Content-Type", "text/plain; charset=windows-1251");
        conexion.setRequestProperty("Content-Encoding", "gzip");
        conexion.setDoOutput(true);
        byte[] gz = this.comprimirGZIP(cuerpo);
        conexion.setFixedLengthStreamingMode(gz.length);
        try (OutputStream os = conexion.getOutputStream();){
            os.write(gz);
        }
        int code = conexion.getResponseCode();
        if (code == 429) {
            String msg = MonitorDePID.idioma.limite_de_solicitudes();
            try (InputStream es2 = conexion.getErrorStream();){
                String extra;
                if (es2 != null && (extra = new BufferedReader(new InputStreamReader(es2)).lines().collect(Collectors.joining("\n"))) != null && !extra.isEmpty()) {
                    msg = msg + "\n" + extra;
                }
            }
            catch (Throwable es2) {
                // empty catch block
            }
            throw new LimteDeTasa(msg);
        }
        if (code < 200 || code >= 300) {
            StringBuilder err = new StringBuilder("HTTP ").append(code);
            try (InputStream es3 = conexion.getErrorStream();){
                String extra;
                if (es3 != null && (extra = new BufferedReader(new InputStreamReader(es3)).lines().collect(Collectors.joining("\n"))) != null && !extra.isEmpty()) {
                    err.append(": ").append(extra);
                }
            }
            catch (Throwable es3) {
                // empty catch block
            }
            throw new IOException(err.toString());
        }
        try (InputStream is = conexion.getInputStream();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
    }

    private byte[] comprimirGZIP(byte[] datos) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(buffer);){
            gzip.write(datos);
        }
        return buffer.toByteArray();
    }

    @Override
    public String publicarTexto(String nombreSugerido, String contenido) throws ErrorConPublicar, LimteDeTasa {
        try {
            String req = this.logRequest("USER_CODE", contenido);
            String link = SecureLoggerAPI.extraerEnlace(req);
            if (link == null || link.isEmpty()) {
                throw new ErrorConPublicar("Respuesta sin enlace de SecureLogger");
            }
            return link;
        }
        catch (LimteDeTasa rl) {
            throw rl;
        }
        catch (Exception e) {
            throw new ErrorConPublicar(e.getMessage());
        }
    }

    @Override
    public boolean soporteEnlacesALinea() {
        return false;
    }

    @Override
    public String obtenerEnlaceDeLinea(int linea_numera) {
        return null;
    }

    @Override
    public ThreadLocal<String> grupoActual() {
        return this.grupoActual;
    }

    @Override
    public BiMap<String, Integer, APIdeSitioDeRegistro.ParteInfo> indicePartes() {
        return this.indicePartes;
    }

    @Override
    public List<String> publicarRegistroEnPartes(Consola registro) throws ErrorConPublicar, LimteDeTasa {
        String contenido = registro.obtainerContenidoParaPublicar() == null ? "" : registro.obtainerContenidoParaPublicar();
        byte[] sinComprimir = contenido.getBytes(Charset.forName(CHARSET_BODY));
        if (sinComprimir.length <= 0xA00000) {
            String base = registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt";
            String u = this.publicarTexto(base, contenido);
            ArrayList<String> unica = new ArrayList<String>();
            unica.add(u);
            return unica;
        }
        ArrayList<String> urls = new ArrayList<String>();
        String[] lineas = contenido.split("\n", -1);
        StringBuilder parte = new StringBuilder();
        int bytesParte = 0;
        int lineaDesde = 1;
        int acumuladas = 0;
        int indiceParte = 1;
        String gid = this.grupoActual().get();
        String base = registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt";
        for (int i = 0; i < lineas.length; ++i) {
            String l = lineas[i];
            String candidata = parte.length() == 0 ? l : "\n" + l;
            int bytesCand = candidata.getBytes(Charset.forName(CHARSET_BODY)).length;
            if (bytesParte + bytesCand <= 0xB00000) {
                parte.append(candidata);
                bytesParte += bytesCand;
                ++acumuladas;
                continue;
            }
            try {
                String izquierda;
                byte[] gzIzq;
                byte[] gz = this.comprimirGZIP(parte.toString().getBytes(Charset.forName(CHARSET_BODY)));
                if (gz.length <= 0xA00000) {
                    String u = this.publicarParte(base, indiceParte, parte.toString());
                    urls.add(u);
                    if (gid != null) {
                        this.registrarParte(gid, indiceParte++, u, lineaDesde, lineaDesde + acumuladas - 1);
                        lineaDesde += acumuladas;
                    }
                    parte.setLength(0);
                    bytesParte = 0;
                    acumuladas = 0;
                    --i;
                    continue;
                }
                int mid = parte.length() / 2;
                int split = parte.lastIndexOf("\n", mid);
                if (split <= 0) {
                    split = mid;
                }
                if ((gzIzq = this.comprimirGZIP((izquierda = parte.substring(0, split)).getBytes(Charset.forName(CHARSET_BODY)))).length > 0xA00000) {
                    int q = parte.length() / 4;
                    int s2 = parte.lastIndexOf("\n", q);
                    if (s2 > 0) {
                        split = s2;
                    }
                    izquierda = parte.substring(0, split);
                    gzIzq = this.comprimirGZIP(izquierda.getBytes(Charset.forName(CHARSET_BODY)));
                }
                String u = this.publicarParte(base, indiceParte, izquierda);
                urls.add(u);
                if (gid != null) {
                    int lineasIzq = izquierda.isEmpty() ? 0 : izquierda.split("\n", -1).length;
                    this.registrarParte(gid, indiceParte++, u, lineaDesde, lineaDesde + lineasIzq - 1);
                    lineaDesde += lineasIzq;
                }
                String derecha = parte.substring(split);
                parte.setLength(0);
                parte.append(derecha);
                bytesParte = derecha.getBytes(Charset.forName(CHARSET_BODY)).length;
                acumuladas = derecha.isEmpty() ? 0 : derecha.split("\n", -1).length;
                --i;
                continue;
            }
            catch (LimteDeTasa e) {
                throw e;
            }
            catch (Exception ex) {
                throw new ErrorConPublicar(ex.getMessage());
            }
        }
        if (parte.length() > 0) {
            String u = this.publicarParte(base, indiceParte, parte.toString());
            urls.add(u);
            if (gid != null) {
                this.registrarParte(gid, indiceParte, u, lineaDesde, lineaDesde + acumuladas - 1);
            }
        }
        return urls;
    }

    private String publicarParte(String base, int indiceParte, String texto) throws ErrorConPublicar, LimteDeTasa {
        String nombre = indiceParte > 1 ? base + " (parte " + indiceParte + ")" : base;
        return this.publicarTexto(nombre, texto);
    }
}

