/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.api_sito_registro;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.api_sito_registro.APIdeSitioDeRegistro;
import com.asbestosstar.crashdetector.api_sito_registro.DemasiadoGrande;
import com.asbestosstar.crashdetector.api_sito_registro.ErrorConPublicar;
import com.asbestosstar.crashdetector.mapas.BiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class StikkedAPI
implements APIdeSitioDeRegistro {
    private static final int MAX_SIZE_BYTES = 0x1000000;
    private static final int TIMEOUT_MS = 30000;
    private static final String UA = "CrashDetector/1.x (+stikked)";
    private final BiMap<String, Integer, APIdeSitioDeRegistro.ParteInfo> indicePartes = new BiMap();
    private final ThreadLocal<String> grupoActual = new ThreadLocal();

    @Override
    public String nombre() {
        return "stikked";
    }

    @Override
    public List<String> sitiosPorDefecto() {
        ArrayList<String> sitios = new ArrayList<String>();
        sitios.add("https://paste.mikumikudance.jp/api/create");
        sitios.add("https://paste.mikumikudance.jp/en/api/create");
        return sitios;
    }

    @Override
    public String publicarRegistro(Consola registro) throws DemasiadoGrande, ErrorConPublicar {
        String texto;
        String string = texto = registro.obtainerContenidoParaPublicar() == null ? "" : registro.obtainerContenidoParaPublicar().trim();
        if (texto.isEmpty()) {
            throw new ErrorConPublicar("Registro no tiene texto " + (registro.archivo == null ? "" : registro.archivo.toString()));
        }
        byte[] cuerpoTexto = texto.getBytes(StandardCharsets.UTF_8);
        if (cuerpoTexto.length > 0x1000000) {
            throw new DemasiadoGrande();
        }
        try {
            String titulo = registro.archivo != null ? registro.archivo.getFileName().toString() : "CrashLog";
            String params = StikkedAPI.construirParams(texto, titulo);
            URL url = new URL(APIdeSitioDeRegistro.sitioDeConfig());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setRequestProperty("User-Agent", UA);
            conn.setRequestProperty("Accept-Charset", "utf-8");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            byte[] body = params.getBytes(StandardCharsets.UTF_8);
            conn.setDoOutput(true);
            conn.setFixedLengthStreamingMode(body.length);
            try (OutputStream os = conn.getOutputStream();){
                os.write(body);
            }
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new ErrorConPublicar("HTTP error: " + code);
            }
            StringBuilder response = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
            }
            String out = response.toString();
            if (out.startsWith("Error:")) {
                throw new ErrorConPublicar(out);
            }
            return out;
        }
        catch (IOException e) {
            throw new ErrorConPublicar("error de red: " + e.getMessage());
        }
    }

    @Override
    public String publicarTexto(String nombreSugerido, String contenido) throws DemasiadoGrande, ErrorConPublicar {
        String texto;
        String string = texto = contenido == null ? "" : contenido.trim();
        if (texto.isEmpty()) {
            throw new ErrorConPublicar("Registro no tiene texto");
        }
        byte[] cuerpoTexto = texto.getBytes(StandardCharsets.UTF_8);
        if (cuerpoTexto.length > 0x1000000) {
            throw new DemasiadoGrande();
        }
        try {
            String titulo = nombreSugerido == null || nombreSugerido.trim().isEmpty() ? "CrashLog" : nombreSugerido.trim();
            String params = StikkedAPI.construirParams(texto, titulo);
            URL url = new URL(APIdeSitioDeRegistro.sitioDeConfig());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setRequestProperty("User-Agent", UA);
            conn.setRequestProperty("Accept-Charset", "utf-8");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            byte[] body = params.getBytes(StandardCharsets.UTF_8);
            conn.setDoOutput(true);
            conn.setFixedLengthStreamingMode(body.length);
            try (OutputStream os = conn.getOutputStream();){
                os.write(body);
            }
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new ErrorConPublicar("HTTP error: " + code);
            }
            StringBuilder response = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
            }
            String out = response.toString();
            if (out.startsWith("Error:")) {
                throw new ErrorConPublicar(out);
            }
            return out;
        }
        catch (IOException e) {
            throw new ErrorConPublicar("error de red: " + e.getMessage());
        }
    }

    private static String construirParams(String texto, String titulo) throws IOException {
        String textEnc = URLEncoder.encode(texto, StandardCharsets.UTF_8.toString());
        String titleEnc = URLEncoder.encode(titulo, StandardCharsets.UTF_8.toString());
        String nameEnc = URLEncoder.encode("CrashDetector", StandardCharsets.UTF_8.toString());
        String privEnc = URLEncoder.encode("1", StandardCharsets.UTF_8.toString());
        String langEnc = URLEncoder.encode("java", StandardCharsets.UTF_8.toString());
        StringBuilder sb = new StringBuilder(textEnc.length() + titleEnc.length() + 64);
        sb.append("text=").append(textEnc).append("&title=").append(titleEnc).append("&name=").append(nameEnc).append("&private=").append(privEnc).append("&lang=").append(langEnc);
        return sb.toString();
    }

    @Override
    public List<String> publicarRegistroEnPartes(Consola registro) throws ErrorConPublicar {
        String contenido = registro.obtainerContenidoParaPublicar();
        if (contenido == null) {
            contenido = "";
        }
        try {
            String enlace = this.publicarTexto(registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt", contenido);
            ArrayList<String> uno = new ArrayList<String>();
            uno.add(enlace);
            String gid = this.grupoActual().get();
            if (gid != null) {
                int totalLineas = contenido.split("\n", -1).length;
                this.registrarParte(gid, 1, enlace, 1, totalLineas);
            }
            return uno;
        }
        catch (DemasiadoGrande enlace) {
            int MAX_BYTES = 0x1000000;
            ArrayList<String> enlaces = new ArrayList<String>();
            byte[] src = contenido.getBytes(StandardCharsets.UTF_8);
            int ini = 0;
            int parte = 1;
            int lineaDesde = 1;
            String nombre = registro.archivo != null ? registro.archivo.getFileName().toString() : "log.txt";
            String gid = this.grupoActual().get();
            while (ini < src.length) {
                int fin = Math.min(src.length, ini + 0x1000000);
                if (fin < src.length) {
                    int back;
                    for (back = fin; back > ini && src[back - 1] != 10; --back) {
                    }
                    if (back > ini + 1024) {
                        fin = back;
                    }
                }
                String bloque = new String(src, ini, fin - ini, StandardCharsets.UTF_8);
                String etiqueta = nombre + " (parte " + parte + ")";
                try {
                    String url = this.publicarTexto(etiqueta, bloque);
                    enlaces.add(url);
                    if (gid != null) {
                        int lineasEnParte = bloque.split("\n", -1).length;
                        int lineaHasta = lineaDesde + lineasEnParte - 1;
                        this.registrarParte(gid, parte, url, lineaDesde, lineaHasta);
                        lineaDesde = lineaHasta + 1;
                    }
                    ++parte;
                    ini = fin;
                }
                catch (DemasiadoGrande ex) {
                    int recorte = Math.min(fin - ini, 0x800000);
                    if (recorte <= 0) {
                        throw new ErrorConPublicar("No se pudo dividir para Stikked.");
                    }
                    fin = ini + recorte;
                }
            }
            return enlaces;
        }
    }

    @Override
    public boolean soporteEnlacesALinea() {
        return true;
    }

    @Override
    public ThreadLocal<String> grupoActual() {
        return this.grupoActual;
    }

    @Override
    public BiMap<String, Integer, APIdeSitioDeRegistro.ParteInfo> indicePartes() {
        return this.indicePartes;
    }
}

