/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.buscar;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.Opcodes;

public class AnalizadorBytecodeASM {
    public static List<ArchivoDeMod.Constante> analizarConstantesEnMetodo(ArchivoDeMod mod, String nombreClase, String nombreMetodo, String descriptor) {
        byte[] bytesClase = mod.obtenerBytesClase(nombreClase);
        if (bytesClase == null) {
            return new ArrayList<ArchivoDeMod.Constante>();
        }
        try {
            ClassReader lector = new ClassReader(bytesClase);
            RecolectorConstantesMetodo recolector = new RecolectorConstantesMetodo(nombreMetodo, descriptor);
            lector.accept((ClassVisitor)recolector, 2);
            return recolector.obtenerResultados();
        }
        catch (Throwable t) {
            CrashDetectorLogger.logException(t);
            return new ArrayList<ArchivoDeMod.Constante>();
        }
    }

    public static List<ArchivoDeMod.InfoMetodo> analizarMetodos(ArchivoDeMod mod, String nombreClase) {
        byte[] bytesClase = mod.obtenerBytesClase(nombreClase);
        if (bytesClase == null) {
            return new ArrayList<ArchivoDeMod.InfoMetodo>();
        }
        try {
            ClassReader lector = new ClassReader(bytesClase);
            RecolectorInformacionMetodos recolector = new RecolectorInformacionMetodos();
            lector.accept((ClassVisitor)recolector, 2);
            return recolector.obtenerResultados();
        }
        catch (Throwable t) {
            CrashDetectorLogger.logException(t);
            return new ArrayList<ArchivoDeMod.InfoMetodo>();
        }
    }

    public static List<ArchivoDeMod.InfoCampo> analizarCampos(ArchivoDeMod mod, String nombreClase) {
        byte[] bytesClase = mod.obtenerBytesClase(nombreClase);
        if (bytesClase == null) {
            return new ArrayList<ArchivoDeMod.InfoCampo>();
        }
        try {
            ClassReader lector = new ClassReader(bytesClase);
            RecolectorInformacionCampos recolector = new RecolectorInformacionCampos();
            lector.accept((ClassVisitor)recolector, 2);
            return recolector.obtenerResultados();
        }
        catch (Throwable t) {
            CrashDetectorLogger.logException(t);
            return new ArrayList<ArchivoDeMod.InfoCampo>();
        }
    }

    public static List<ArchivoDeMod.Referencia> analizarReferenciasEnMetodo(ArchivoDeMod mod, String nombreClase, String nombreMetodo, String descriptor) {
        byte[] bytesClase = mod.obtenerBytesClase(nombreClase);
        if (bytesClase == null) {
            return new ArrayList<ArchivoDeMod.Referencia>();
        }
        try {
            ClassReader lector = new ClassReader(bytesClase);
            RecolectorReferenciasMetodo recolector = new RecolectorReferenciasMetodo(nombreMetodo, descriptor);
            lector.accept((ClassVisitor)recolector, 2);
            return recolector.obtenerResultados();
        }
        catch (Throwable t) {
            CrashDetectorLogger.logException(t);
            return new ArrayList<ArchivoDeMod.Referencia>();
        }
    }

    public static List<ArchivoDeMod.Referencia> analizarReferenciasAMetodo(ArchivoDeMod mod, String claseObjetivo, String metodoObjetivo, String descriptorObjetivo) {
        ArrayList<ArchivoDeMod.Referencia> resultados = new ArrayList<ArchivoDeMod.Referencia>();
        for (String nombreClase : mod.obtenerTodosLosNombresDeClases()) {
            byte[] bytesClase = mod.obtenerBytesClase(nombreClase);
            if (bytesClase == null) continue;
            try {
                ClassReader lector = new ClassReader(bytesClase);
                RecolectorLlamadasAMetodo recolector = new RecolectorLlamadasAMetodo(claseObjetivo, metodoObjetivo, descriptorObjetivo);
                lector.accept((ClassVisitor)recolector, 2);
                resultados.addAll(recolector.obtenerResultados());
            }
            catch (Throwable t) {
                CrashDetectorLogger.logException(t);
            }
        }
        return resultados;
    }

    static int obtenerVersionMaximaASM() {
        try {
            Class<Opcodes> clase = Opcodes.class;
            for (int i = 10; i >= 4; --i) {
                String nombreCampo = "ASM" + i;
                try {
                    Field campo = clase.getField(nombreCampo);
                    return campo.getInt(null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            return 262144;
        }
        catch (Exception e) {
            throw new RuntimeException("Error al obtener la versi\u00f3n ASM", e);
        }
    }

    public static List<String> obtenerNombreModuloInfo(byte[] classBytes) {
        final ArrayList<String> modulos = new ArrayList<String>();
        ClassReader classReader = new ClassReader(classBytes);
        ClassVisitor classVisitor = new ClassVisitor(AnalizadorBytecodeASM.obtenerVersionMaximaASM()){

            public ModuleVisitor visitModule(String name, int access, String version) {
                if (name != null && !name.isEmpty()) {
                    modulos.add(name);
                }
                return null;
            }
        };
        classReader.accept(classVisitor, 8);
        return modulos;
    }

    static class RecolectorConstantesMetodo
    extends ClassVisitor {
        private String claseActual;
        private final String metodoObjetivo;
        private final String descriptorObjetivo;
        private final List<ArchivoDeMod.Constante> resultados = new ArrayList<ArchivoDeMod.Constante>();

        public RecolectorConstantesMetodo(String metodo, String descriptor) {
            super(AnalizadorBytecodeASM.obtenerVersionMaximaASM());
            this.metodoObjetivo = metodo;
            this.descriptorObjetivo = descriptor;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.claseActual = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!name.equals(this.metodoObjetivo) || !desc.equals(this.descriptorObjetivo)) {
                return null;
            }
            return new MethodVisitor(AnalizadorBytecodeASM.obtenerVersionMaximaASM()){

                public void visitLdcInsn(Object cst) {
                    this.agregar(cst);
                }

                public void visitIntInsn(int opcode, int operand) {
                    if (opcode == 16 || opcode == 17) {
                        this.agregar(operand);
                    }
                }

                public void visitInsn(int opcode) {
                    switch (opcode) {
                        case 2: {
                            this.agregar(-1);
                            break;
                        }
                        case 3: {
                            this.agregar(0);
                            break;
                        }
                        case 4: {
                            this.agregar(1);
                            break;
                        }
                        case 5: {
                            this.agregar(2);
                            break;
                        }
                        case 6: {
                            this.agregar(3);
                            break;
                        }
                        case 7: {
                            this.agregar(4);
                            break;
                        }
                        case 8: {
                            this.agregar(5);
                            break;
                        }
                        case 9: {
                            this.agregar(0L);
                            break;
                        }
                        case 10: {
                            this.agregar(1L);
                            break;
                        }
                        case 11: {
                            this.agregar(Float.valueOf(0.0f));
                            break;
                        }
                        case 12: {
                            this.agregar(Float.valueOf(1.0f));
                            break;
                        }
                        case 13: {
                            this.agregar(Float.valueOf(2.0f));
                            break;
                        }
                        case 14: {
                            this.agregar(0.0);
                            break;
                        }
                        case 15: {
                            this.agregar(1.0);
                            break;
                        }
                    }
                }

                private void agregar(Object valor) {
                    String tipo = valor == null ? "null" : valor.getClass().getSimpleName();
                    resultados.add(new ArchivoDeMod.Constante(claseActual, metodoObjetivo, descriptorObjetivo, valor, tipo));
                }
            };
        }

        public List<ArchivoDeMod.Constante> obtenerResultados() {
            return new ArrayList<ArchivoDeMod.Constante>(this.resultados);
        }
    }

    static class RecolectorInformacionMetodos
    extends ClassVisitor {
        private final List<ArchivoDeMod.InfoMetodo> resultados = new ArrayList<ArchivoDeMod.InfoMetodo>();

        public RecolectorInformacionMetodos() {
            super(AnalizadorBytecodeASM.obtenerVersionMaximaASM());
        }

        public MethodVisitor visitMethod(int acceso, String nombre, String descriptor, String firma, String[] excepciones) {
            ArrayList<ArchivoDeMod.Referencia> referenciasMetodos = new ArrayList<ArchivoDeMod.Referencia>();
            ArrayList<ArchivoDeMod.Referencia> referenciasCampos = new ArrayList<ArchivoDeMod.Referencia>();
            return new RecolectorReferenciasMetodoInterno(nombre, descriptor, referenciasMetodos, referenciasCampos);
        }

        public List<ArchivoDeMod.InfoMetodo> obtenerResultados() {
            return new ArrayList<ArchivoDeMod.InfoMetodo>(this.resultados);
        }

        private class RecolectorReferenciasMetodoInterno
        extends MethodVisitor {
            private final String nombre;
            private final String descriptor;
            private final List<ArchivoDeMod.Referencia> referenciasMetodos;
            private final List<ArchivoDeMod.Referencia> referenciasCampos;

            public RecolectorReferenciasMetodoInterno(String nombre, String descriptor, List<ArchivoDeMod.Referencia> referenciasMetodos, List<ArchivoDeMod.Referencia> referenciasCampos) {
                super(AnalizadorBytecodeASM.obtenerVersionMaximaASM());
                this.nombre = nombre;
                this.descriptor = descriptor;
                this.referenciasMetodos = referenciasMetodos;
                this.referenciasCampos = referenciasCampos;
            }

            public void visitMethodInsn(int opcode, String propietario, String nombre, String descriptor, boolean esInterfaz) {
                this.referenciasMetodos.add(new ArchivoDeMod.Referencia(propietario, nombre, descriptor, true));
            }

            public void visitFieldInsn(int opcode, String propietario, String nombre, String descriptor) {
                this.referenciasCampos.add(new ArchivoDeMod.Referencia(propietario, nombre, descriptor, false));
            }

            public void visitEnd() {
                RecolectorInformacionMetodos.this.resultados.add(new ArchivoDeMod.InfoMetodo(this.nombre, this.descriptor, this.referenciasMetodos, this.referenciasCampos));
            }
        }
    }

    static class RecolectorInformacionCampos
    extends ClassVisitor {
        private final List<ArchivoDeMod.InfoCampo> resultados = new ArrayList<ArchivoDeMod.InfoCampo>();

        public RecolectorInformacionCampos() {
            super(AnalizadorBytecodeASM.obtenerVersionMaximaASM());
        }

        public FieldVisitor visitField(int acceso, String nombre, String descriptor, String firma, Object valor) {
            this.resultados.add(new ArchivoDeMod.InfoCampo(nombre, descriptor));
            return null;
        }

        public List<ArchivoDeMod.InfoCampo> obtenerResultados() {
            return new ArrayList<ArchivoDeMod.InfoCampo>(this.resultados);
        }
    }

    static class RecolectorReferenciasMetodo
    extends ClassVisitor {
        private final String metodoObjetivo;
        private final String descriptorObjetivo;
        private final List<ArchivoDeMod.Referencia> resultados = new ArrayList<ArchivoDeMod.Referencia>();

        public RecolectorReferenciasMetodo(String metodo, String descriptor) {
            super(AnalizadorBytecodeASM.obtenerVersionMaximaASM());
            this.metodoObjetivo = metodo;
            this.descriptorObjetivo = descriptor;
        }

        public MethodVisitor visitMethod(int acceso, String nombre, String descriptor, String firma, String[] excepciones) {
            if (nombre.equals(this.metodoObjetivo) && descriptor.equals(this.descriptorObjetivo)) {
                return new RecolectorReferencias();
            }
            return null;
        }

        public List<ArchivoDeMod.Referencia> obtenerResultados() {
            return new ArrayList<ArchivoDeMod.Referencia>(this.resultados);
        }

        private class RecolectorReferencias
        extends MethodVisitor {
            public RecolectorReferencias() {
                super(AnalizadorBytecodeASM.obtenerVersionMaximaASM());
            }

            public void visitMethodInsn(int opcode, String propietario, String nombre, String descriptor, boolean esInterfaz) {
                RecolectorReferenciasMetodo.this.resultados.add(new ArchivoDeMod.Referencia(propietario, nombre, descriptor, true));
            }

            public void visitFieldInsn(int opcode, String propietario, String nombre, String descriptor) {
                RecolectorReferenciasMetodo.this.resultados.add(new ArchivoDeMod.Referencia(propietario, nombre, descriptor, false));
            }
        }
    }

    static class RecolectorLlamadasAMetodo
    extends ClassVisitor {
        private final String claseObjetivo;
        private final String metodoObjetivo;
        private final String descriptorObjetivo;
        private final List<ArchivoDeMod.Referencia> resultados = new ArrayList<ArchivoDeMod.Referencia>();

        public RecolectorLlamadasAMetodo(String clase, String metodo, String descriptor) {
            super(AnalizadorBytecodeASM.obtenerVersionMaximaASM());
            this.claseObjetivo = clase;
            this.metodoObjetivo = metodo;
            this.descriptorObjetivo = descriptor;
        }

        public MethodVisitor visitMethod(int acceso, String nombre, String descriptor, String firma, String[] excepciones) {
            return new RecolectorLlamadas();
        }

        public List<ArchivoDeMod.Referencia> obtenerResultados() {
            return new ArrayList<ArchivoDeMod.Referencia>(this.resultados);
        }

        private class RecolectorLlamadas
        extends MethodVisitor {
            public RecolectorLlamadas() {
                super(AnalizadorBytecodeASM.obtenerVersionMaximaASM());
            }

            public void visitMethodInsn(int opcode, String propietario, String nombre, String descriptor, boolean esInterfaz) {
                if (propietario.equals(RecolectorLlamadasAMetodo.this.claseObjetivo) && nombre.equals(RecolectorLlamadasAMetodo.this.metodoObjetivo) && descriptor.equals(RecolectorLlamadasAMetodo.this.descriptorObjetivo)) {
                    RecolectorLlamadasAMetodo.this.resultados.add(new ArchivoDeMod.Referencia(propietario, nombre, descriptor, true));
                }
            }
        }
    }
}

