/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.buscar;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;

public class AnalizadorBytecodeJavassist {
    public static List<ArchivoDeMod.Constante> analizarConstantesEnMetodo(ArchivoDeMod mod, String nombreClase, String nombreMetodo, String descriptor) {
        byte[] bytesClase = mod.obtenerBytesClase(nombreClase);
        if (bytesClase == null) {
            return new ArrayList<ArchivoDeMod.Constante>();
        }
        try {
            ClassFile classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(bytesClase)));
            MethodInfo mi = null;
            for (MethodInfo m : classFile.getMethods()) {
                if (!m.getName().equals(nombreMetodo) || !m.getDescriptor().equals(descriptor)) continue;
                mi = m;
                break;
            }
            if (mi == null) {
                return new ArrayList<ArchivoDeMod.Constante>();
            }
            if ((mi.getAccessFlags() & 0x500) != 0) {
                return new ArrayList<ArchivoDeMod.Constante>();
            }
            CodeAttribute ca = mi.getCodeAttribute();
            if (ca == null) {
                return new ArrayList<ArchivoDeMod.Constante>();
            }
            ConstPool cp = classFile.getConstPool();
            CodeIterator it = ca.iterator();
            ArrayList<ArchivoDeMod.Constante> resultados = new ArrayList<ArchivoDeMod.Constante>();
            while (it.hasNext()) {
                int index = it.next();
                int op = it.byteAt(index) & 0xFF;
                switch (op) {
                    case 2: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, -1);
                        break;
                    }
                    case 3: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, 0);
                        break;
                    }
                    case 4: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, 1);
                        break;
                    }
                    case 5: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, 2);
                        break;
                    }
                    case 6: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, 3);
                        break;
                    }
                    case 7: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, 4);
                        break;
                    }
                    case 8: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, 5);
                        break;
                    }
                    case 9: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, 0L);
                        break;
                    }
                    case 10: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, 1L);
                        break;
                    }
                    case 11: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, Float.valueOf(0.0f));
                        break;
                    }
                    case 12: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, Float.valueOf(1.0f));
                        break;
                    }
                    case 13: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, Float.valueOf(2.0f));
                        break;
                    }
                    case 14: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, 0.0);
                        break;
                    }
                    case 15: {
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, 1.0);
                        break;
                    }
                    case 16: {
                        int val = (byte)it.byteAt(index + 1);
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, val);
                        break;
                    }
                    case 17: {
                        int val = it.s16bitAt(index + 1);
                        AnalizadorBytecodeJavassist.agregar(resultados, nombreClase, nombreMetodo, descriptor, val);
                        break;
                    }
                    case 18: {
                        int cpIndex = it.byteAt(index + 1) & 0xFF;
                        AnalizadorBytecodeJavassist.agregarDesdeConstPool(resultados, nombreClase, nombreMetodo, descriptor, cp, cpIndex);
                        break;
                    }
                    case 19: {
                        int cpIndex = it.u16bitAt(index + 1);
                        AnalizadorBytecodeJavassist.agregarDesdeConstPool(resultados, nombreClase, nombreMetodo, descriptor, cp, cpIndex);
                        break;
                    }
                    case 20: {
                        int cpIndex = it.u16bitAt(index + 1);
                        AnalizadorBytecodeJavassist.agregarDesdeConstPool(resultados, nombreClase, nombreMetodo, descriptor, cp, cpIndex);
                        break;
                    }
                }
            }
            return resultados;
        }
        catch (Throwable t) {
            CrashDetectorLogger.logException(t);
            return new ArrayList<ArchivoDeMod.Constante>();
        }
    }

    private static void agregar(List<ArchivoDeMod.Constante> out, String clase, String metodo, String desc, Object valor) {
        String tipo = valor == null ? "null" : valor.getClass().getSimpleName();
        out.add(new ArchivoDeMod.Constante(clase, metodo, desc, valor, tipo));
    }

    private static void agregarDesdeConstPool(List<ArchivoDeMod.Constante> out, String clase, String metodo, String desc, ConstPool cp, int index) {
        int tag = cp.getTag(index);
        switch (tag) {
            case 8: {
                AnalizadorBytecodeJavassist.agregar(out, clase, metodo, desc, cp.getStringInfo(index));
                break;
            }
            case 3: {
                AnalizadorBytecodeJavassist.agregar(out, clase, metodo, desc, cp.getIntegerInfo(index));
                break;
            }
            case 4: {
                AnalizadorBytecodeJavassist.agregar(out, clase, metodo, desc, Float.valueOf(cp.getFloatInfo(index)));
                break;
            }
            case 5: {
                AnalizadorBytecodeJavassist.agregar(out, clase, metodo, desc, cp.getLongInfo(index));
                break;
            }
            case 6: {
                AnalizadorBytecodeJavassist.agregar(out, clase, metodo, desc, cp.getDoubleInfo(index));
                break;
            }
            case 7: {
                AnalizadorBytecodeJavassist.agregar(out, clase, metodo, desc, cp.getClassInfo(index));
                break;
            }
            default: {
                AnalizadorBytecodeJavassist.agregar(out, clase, metodo, desc, "<constpool tag " + tag + ">");
            }
        }
    }

    public static List<ArchivoDeMod.InfoMetodo> analizarMetodos(ArchivoDeMod mod, String nombreClase) {
        byte[] bytesClase = mod.obtenerBytesClase(nombreClase);
        if (bytesClase == null) {
            return new ArrayList<ArchivoDeMod.InfoMetodo>();
        }
        try {
            ClassPool pool = new ClassPool();
            pool.appendSystemPath();
            ClassFile classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(bytesClase)));
            ArrayList<ArchivoDeMod.InfoMetodo> resultados = new ArrayList<ArchivoDeMod.InfoMetodo>();
            for (MethodInfo methodInfo : classFile.getMethods()) {
                String methodName = methodInfo.getName();
                String descriptor = methodInfo.getDescriptor();
                if ((methodInfo.getAccessFlags() & 0x500) != 0) {
                    resultados.add(new ArchivoDeMod.InfoMetodo(methodName, descriptor, new ArrayList<ArchivoDeMod.Referencia>(), new ArrayList<ArchivoDeMod.Referencia>()));
                    continue;
                }
                final ArrayList<ArchivoDeMod.Referencia> referenciasMetodos = new ArrayList<ArchivoDeMod.Referencia>();
                final ArrayList<ArchivoDeMod.Referencia> referenciasCampos = new ArrayList<ArchivoDeMod.Referencia>();
                CtClass ctClass = pool.makeClass(classFile, false);
                CtMethod ctMethod = ctClass.getMethod(methodName, descriptor);
                ctMethod.instrument(new ExprEditor(){

                    public void edit(MethodCall m) {
                        referenciasMetodos.add(AnalizadorBytecodeJavassist.convertirAMiReferencia(m));
                    }

                    public void edit(FieldAccess f) {
                        referenciasCampos.add(AnalizadorBytecodeJavassist.convertirAMiReferencia(f));
                    }
                });
                resultados.add(new ArchivoDeMod.InfoMetodo(methodName, descriptor, referenciasMetodos, referenciasCampos));
            }
            return resultados;
        }
        catch (Throwable t) {
            CrashDetectorLogger.logException(t);
            return new ArrayList<ArchivoDeMod.InfoMetodo>();
        }
    }

    public static List<ArchivoDeMod.InfoCampo> analizarCampos(ArchivoDeMod mod, String nombreClase) {
        byte[] bytesClase = mod.obtenerBytesClase(nombreClase);
        if (bytesClase == null) {
            return new ArrayList<ArchivoDeMod.InfoCampo>();
        }
        try {
            ClassFile classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(bytesClase)));
            ArrayList<ArchivoDeMod.InfoCampo> resultados = new ArrayList<ArchivoDeMod.InfoCampo>();
            for (FieldInfo fieldInfo : classFile.getFields()) {
                resultados.add(new ArchivoDeMod.InfoCampo(fieldInfo.getName(), fieldInfo.getDescriptor()));
            }
            return resultados;
        }
        catch (Throwable t) {
            CrashDetectorLogger.logException(t);
            return new ArrayList<ArchivoDeMod.InfoCampo>();
        }
    }

    public static List<ArchivoDeMod.Referencia> analizarReferenciasEnMetodo(ArchivoDeMod mod, String nombreClase, String nombreMetodo, String descriptor) {
        byte[] bytesClase = mod.obtenerBytesClase(nombreClase);
        if (bytesClase == null) {
            return new ArrayList<ArchivoDeMod.Referencia>();
        }
        try {
            ClassPool pool = new ClassPool();
            pool.appendSystemPath();
            ClassFile classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(bytesClase)));
            MethodInfo methodInfo = null;
            for (MethodInfo mi : classFile.getMethods()) {
                if (!mi.getName().equals(nombreMetodo) || !mi.getDescriptor().equals(descriptor)) continue;
                methodInfo = mi;
                break;
            }
            if (methodInfo == null || (methodInfo.getAccessFlags() & 0x500) != 0) {
                return new ArrayList<ArchivoDeMod.Referencia>();
            }
            final ArrayList<ArchivoDeMod.Referencia> resultados = new ArrayList<ArchivoDeMod.Referencia>();
            CtClass ctClass = pool.makeClass(classFile, false);
            CtMethod ctMethod = ctClass.getMethod(nombreMetodo, descriptor);
            ctMethod.instrument(new ExprEditor(){

                public void edit(MethodCall m) {
                    resultados.add(AnalizadorBytecodeJavassist.convertirAMiReferencia(m));
                }

                public void edit(FieldAccess f) {
                    resultados.add(AnalizadorBytecodeJavassist.convertirAMiReferencia(f));
                }
            });
            return resultados;
        }
        catch (Throwable t) {
            CrashDetectorLogger.logException(t);
            return new ArrayList<ArchivoDeMod.Referencia>();
        }
    }

    public static List<ArchivoDeMod.Referencia> analizarReferenciasAMetodo(ArchivoDeMod mod, final String claseObjetivo, final String metodoObjetivo, final String descriptorObjetivo) {
        final ArrayList<ArchivoDeMod.Referencia> resultados = new ArrayList<ArchivoDeMod.Referencia>();
        List<String> todosNombresClases = mod.obtenerTodosLosNombresDeClases();
        ClassPool pool = new ClassPool();
        pool.appendSystemPath();
        for (String className : todosNombresClases) {
            byte[] bytes = mod.obtenerBytesClase(className);
            if (bytes == null) continue;
            try {
                ClassFile classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(bytes)));
                CtClass ctClass = pool.makeClass(classFile, false);
                for (CtMethod method : ctClass.getDeclaredMethods()) {
                    if ((method.getMethodInfo().getAccessFlags() & 0x500) != 0) continue;
                    method.instrument(new ExprEditor(){

                        public void edit(MethodCall m) {
                            String owner = m.getClassName().replace('.', '/');
                            if (owner.equals(claseObjetivo) && m.getMethodName().equals(metodoObjetivo) && m.getSignature().equals(descriptorObjetivo)) {
                                resultados.add(new ArchivoDeMod.Referencia(owner, metodoObjetivo, descriptorObjetivo, true));
                            }
                        }
                    });
                }
            }
            catch (Throwable t) {
                CrashDetectorLogger.logException(t);
            }
        }
        return resultados;
    }

    public static ArchivoDeMod.Referencia convertirAMiReferencia(MethodCall m) {
        return new ArchivoDeMod.Referencia(m.getClassName().replace('.', '/'), m.getMethodName(), m.getSignature(), true);
    }

    public static ArchivoDeMod.Referencia convertirAMiReferencia(FieldAccess f) {
        return new ArchivoDeMod.Referencia(f.getClassName().replace('.', '/'), f.getFieldName(), f.getSignature(), false);
    }

    public static List<String> obtenerNombreModuloInfo(byte[] classBytes) {
        ArrayList<String> modulos = new ArrayList<String>();
        try {
            ClassFile classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(classBytes)));
            ConstPool constPool = classFile.getConstPool();
            for (int i = 1; i < constPool.getSize(); ++i) {
                String moduleName;
                if (constPool.getTag(i) != 19 || (moduleName = constPool.getModuleInfo(i)) == null || moduleName.isEmpty()) continue;
                modulos.add(moduleName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return modulos;
    }
}

