/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.buscar;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.anon.AnonimizadorDeRuta;
import com.asbestosstar.crashdetector.buscar.AnalizadorBytecodeASM;
import com.asbestosstar.crashdetector.buscar.AnalizadorBytecodeJavassist;
import com.asbestosstar.crashdetector.cargador.Cargador;
import java.util.ArrayList;
import java.util.List;

public interface ArchivoDeMod {
    public static final ArchivoDeMod origin = new Origin();
    public static final boolean ASM_DISPONIBLE = ArchivoDeMod.verificarClaseEnClasspath("org.objectweb.asm.ClassReader");
    public static final boolean JAVASSIST_DISPONIBLE = ArchivoDeMod.verificarClaseEnClasspath("javassist.bytecode.ClassFile");

    public ArchivoDeMod obtenerDesde();

    public List<ArchivoDeMod> mods_en_mods();

    public List<String> nombre();

    public String ubicacion();

    default public String ubicacion_para_publicar() {
        return AnonimizadorDeRuta.anonimizarNombreDeUsuario(this.ubicacion());
    }

    public List<String> clases();

    public boolean tieneNombreRecursivo(String var1);

    public String obtenerNombreRecursivo(String var1);

    public boolean tieneArchivoRecursivo(String var1);

    public String obtenerArchivoRecursivo(String var1);

    public List<String> archivos();

    public List<ArchivoDeMod> buscarModsCon(String var1);

    public static boolean verificarClaseEnClasspath(String nombreClase) {
        try {
            Class.forName(nombreClase);
            CrashDetectorLogger.log("tiene clase " + nombreClase);
            return true;
        }
        catch (ClassNotFoundException e) {
            CrashDetectorLogger.log("NO tiene clase " + nombreClase);
            return false;
        }
    }

    public static boolean esAnalisisDeBytecodeDisponible() {
        return ASM_DISPONIBLE || JAVASSIST_DISPONIBLE;
    }

    public boolean existeClase(String var1);

    default public List<InfoMetodo> obtenerMetodosConReferencias(String nombreClase) {
        if (ASM_DISPONIBLE) {
            return AnalizadorBytecodeASM.analizarMetodos(this, nombreClase);
        }
        if (JAVASSIST_DISPONIBLE) {
            return AnalizadorBytecodeJavassist.analizarMetodos(this, nombreClase);
        }
        return new ArrayList<InfoMetodo>();
    }

    default public List<InfoCampo> obtenerCampos(String nombreClase) {
        if (ASM_DISPONIBLE) {
            return AnalizadorBytecodeASM.analizarCampos(this, nombreClase);
        }
        if (JAVASSIST_DISPONIBLE) {
            return AnalizadorBytecodeJavassist.analizarCampos(this, nombreClase);
        }
        return new ArrayList<InfoCampo>();
    }

    default public List<Referencia> buscarReferenciasEnMetodo(String nombreClase, String nombreMetodo, String descriptor) {
        if (ASM_DISPONIBLE) {
            return AnalizadorBytecodeASM.analizarReferenciasEnMetodo(this, nombreClase, nombreMetodo, descriptor);
        }
        if (JAVASSIST_DISPONIBLE) {
            return AnalizadorBytecodeJavassist.analizarReferenciasEnMetodo(this, nombreClase, nombreMetodo, descriptor);
        }
        return new ArrayList<Referencia>();
    }

    default public List<Referencia> buscarReferenciasAMetodo(String claseObjetivo, String metodoObjetivo, String descriptorObjetivo) {
        if (ASM_DISPONIBLE) {
            return AnalizadorBytecodeASM.analizarReferenciasAMetodo(this, claseObjetivo, metodoObjetivo, descriptorObjetivo);
        }
        if (JAVASSIST_DISPONIBLE) {
            return AnalizadorBytecodeJavassist.analizarReferenciasAMetodo(this, claseObjetivo, metodoObjetivo, descriptorObjetivo);
        }
        return new ArrayList<Referencia>();
    }

    default public List<String> obtenerNombresDeModuleInfo(byte[] moduleinfo) {
        if (ASM_DISPONIBLE) {
            return AnalizadorBytecodeASM.obtenerNombreModuloInfo(moduleinfo);
        }
        if (JAVASSIST_DISPONIBLE) {
            return AnalizadorBytecodeJavassist.obtenerNombreModuloInfo(moduleinfo);
        }
        return new ArrayList<String>();
    }

    public byte[] obtenerBytesClase(String var1);

    public List<String> obtenerTodosLosNombresDeClases();

    public List<Cargador> cargadores();

    default public boolean funcionarConCargadoresActuales() {
        for (Cargador car : this.cargadores()) {
            if (!Cargador.cargadores_activados.contains(car)) continue;
            return true;
        }
        return false;
    }

    default public boolean MetaDataTieneReferenciaDeMCReator() {
        return false;
    }

    default public List<Constante> buscarConstantesEnMetodo(String nombreClase, String nombreMetodo, String descriptorMetodo) {
        if (ASM_DISPONIBLE) {
            return AnalizadorBytecodeASM.analizarConstantesEnMetodo(this, nombreClase, nombreMetodo, descriptorMetodo);
        }
        if (JAVASSIST_DISPONIBLE) {
            return AnalizadorBytecodeJavassist.analizarConstantesEnMetodo(this, nombreClase, nombreMetodo, descriptorMetodo);
        }
        return new ArrayList<Constante>();
    }

    public int precargarTodasLasClasesRecursivo();

    public static class Origin
    implements ArchivoDeMod {
        @Override
        public ArchivoDeMod obtenerDesde() {
            return origin;
        }

        @Override
        public List<ArchivoDeMod> mods_en_mods() {
            return new ArrayList<ArchivoDeMod>();
        }

        @Override
        public List<String> nombre() {
            return new ArrayList<String>();
        }

        @Override
        public String ubicacion() {
            return "";
        }

        @Override
        public List<String> clases() {
            return new ArrayList<String>();
        }

        @Override
        public boolean tieneNombreRecursivo(String nombre) {
            return false;
        }

        @Override
        public String obtenerNombreRecursivo(String nombre) {
            return null;
        }

        @Override
        public boolean tieneArchivoRecursivo(String paquete) {
            return false;
        }

        @Override
        public String obtenerArchivoRecursivo(String paquete) {
            return null;
        }

        @Override
        public List<String> archivos() {
            return new ArrayList<String>();
        }

        @Override
        public List<ArchivoDeMod> buscarModsCon(String termino) {
            return new ArrayList<ArchivoDeMod>();
        }

        @Override
        public boolean existeClase(String nombreClase) {
            return false;
        }

        @Override
        public byte[] obtenerBytesClase(String nombreClase) {
            return null;
        }

        @Override
        public List<String> obtenerTodosLosNombresDeClases() {
            return new ArrayList<String>();
        }

        @Override
        public List<Cargador> cargadores() {
            return new ArrayList<Cargador>();
        }

        @Override
        public int precargarTodasLasClasesRecursivo() {
            return 0;
        }
    }

    public static class Constante {
        private final String clase;
        private final String metodo;
        private final String descriptorMetodo;
        private final Object valor;
        private final String tipo;

        public Constante(String clase, String metodo, String descriptorMetodo, Object valor, String tipo) {
            this.clase = clase;
            this.metodo = metodo;
            this.descriptorMetodo = descriptorMetodo;
            this.valor = valor;
            this.tipo = tipo;
        }

        public String obtenerClase() {
            return this.clase;
        }

        public String obtenerMetodo() {
            return this.metodo;
        }

        public String obtenerDescriptorMetodo() {
            return this.descriptorMetodo;
        }

        public Object obtenerValor() {
            return this.valor;
        }

        public String obtenerTipo() {
            return this.tipo;
        }

        public String toString() {
            return "Constante{clase=" + this.clase + ", metodo=" + this.metodo + ", desc=" + this.descriptorMetodo + ", tipo=" + this.tipo + ", valor=" + String.valueOf(this.valor) + "}";
        }
    }

    public static class Referencia {
        private final String clase;
        private final String nombre;
        private final String descriptor;
        private final boolean esMetodo;

        public Referencia(String clase, String nombre, String descriptor, boolean esMetodo) {
            this.clase = clase;
            this.nombre = nombre;
            this.descriptor = descriptor;
            this.esMetodo = esMetodo;
        }

        public String obtenerClase() {
            return this.clase;
        }

        public String obtenerNombre() {
            return this.nombre;
        }

        public String obtenerDescriptor() {
            return this.descriptor;
        }

        public boolean esMetodo() {
            return this.esMetodo;
        }

        public boolean esCampo() {
            return !this.esMetodo;
        }
    }

    public static class InfoCampo {
        private final String nombre;
        private final String descriptor;

        public InfoCampo(String nombre, String descriptor) {
            this.nombre = nombre;
            this.descriptor = descriptor;
        }

        public String obtenerNombre() {
            return this.nombre;
        }

        public String obtenerDescriptor() {
            return this.descriptor;
        }
    }

    public static class InfoMetodo {
        private final String nombre;
        private final String descriptor;
        private final List<Referencia> referenciasAMetodos;
        private final List<Referencia> referenciasACampos;

        public InfoMetodo(String nombre, String descriptor, List<Referencia> referenciasAMetodos, List<Referencia> referenciasACampos) {
            this.nombre = nombre;
            this.descriptor = descriptor;
            this.referenciasAMetodos = new ArrayList<Referencia>(referenciasAMetodos);
            this.referenciasACampos = new ArrayList<Referencia>(referenciasACampos);
        }

        public String obtenerNombre() {
            return this.nombre;
        }

        public String obtenerDescriptor() {
            return this.descriptor;
        }

        public List<Referencia> obtenerReferenciasAMetodos() {
            return new ArrayList<Referencia>(this.referenciasAMetodos);
        }

        public List<Referencia> obtenerReferenciasACampos() {
            return new ArrayList<Referencia>(this.referenciasACampos);
        }
    }
}

