/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.buscar;

import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.anon.AnonimizadorDeRuta;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.ModCarpeta;
import com.asbestosstar.crashdetector.buscar.ModPKZip;
import com.asbestosstar.crashdetector.cargador.Cargador;
import com.asbestosstar.crashdetector.cargador.CargadorDangerZone;
import com.asbestosstar.crashdetector.cargador.CargadorFabric;
import com.asbestosstar.crashdetector.cargador.CargadorFeatureCreep;
import com.asbestosstar.crashdetector.cargador.CargadorMCForge;
import com.asbestosstar.crashdetector.cargador.CargadorNXOpen;
import com.asbestosstar.crashdetector.cargador.CargadorNeoForge;
import com.asbestosstar.crashdetector.config.ConfigBoolean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Buscardor {
    public static Set<ArchivoDeMod> mods = Collections.newSetFromMap(new ConcurrentHashMap());
    public static ConfigBoolean hablicar = ConfigBoolean.de("hablicar_buscardor", true);
    public static boolean cargado = false;
    public static volatile boolean cargadotodos = false;

    public static void cargar() {
        if (!cargado && hablicar.obtener().booleanValue()) {
            try {
                String[] rutasMods = MonitorDePID.leer_archivo(MonitorDePID.ultimo_mods).split(MonitorDePID.nl);
                if (rutasMods.length == 0) {
                    cargado = true;
                    return;
                }
                int numeroHilos = Buscardor.calcularHilosOptimos(rutasMods.length);
                ThreadPoolExecutor ejecutor = Buscardor.crearThreadPoolExecutor(numeroHilos);
                Buscardor.procesarModsEnParalelo(rutasMods, ejecutor);
                Buscardor.cerrarThreadPoolExecutor(ejecutor);
                cargado = true;
            }
            catch (IOException e) {
                CrashDetectorLogger.logException(e);
            }
        }
    }

    public static void cargarYPrecargarClasesEnCache() {
        if (cargadotodos) {
            return;
        }
        Buscardor.cargar();
        Buscardor.precargarClasesEnCacheParaModsCargados();
        cargadotodos = true;
    }

    public static void precargarClasesEnCacheParaModsCargados() {
        if (Buscardor.obtenerTodosLosModsYSubmodsRecursivos().isEmpty()) {
            return;
        }
        int numeroHilos = Buscardor.calcularHilosOptimos(mods.size());
        ThreadPoolExecutor ejecutor = Buscardor.crearThreadPoolExecutor(numeroHilos);
        AtomicInteger totalPrecargadas = new AtomicInteger(0);
        for (ArchivoDeMod mod : mods) {
            ejecutor.submit(() -> {
                try {
                    int count = Buscardor.precargarClasesDeUnMod(mod);
                    int total = totalPrecargadas.addAndGet(count);
                    if (count > 0) {
                        CrashDetectorLogger.log("Precargadas " + count + " clases en " + mod.ubicacion() + " (acumulado=" + total + ")");
                    }
                }
                catch (Throwable t) {
                    CrashDetectorLogger.log("Error precargando clases en " + mod.ubicacion() + ": " + t.getMessage());
                    CrashDetectorLogger.logException(t);
                }
            });
        }
        Buscardor.cerrarThreadPoolExecutor(ejecutor);
    }

    private static int precargarClasesDeUnMod(ArchivoDeMod mod) {
        return mod.precargarTodasLasClasesRecursivo();
    }

    private static ThreadPoolExecutor crearThreadPoolExecutor(int numeroHilos) {
        int tamanoPoolNucleo = Math.max(1, numeroHilos / 2);
        int tamanoPoolMaximo = numeroHilos;
        long tiempoVidaHilos = 30L;
        LinkedBlockingQueue<Runnable> colaTrabajo = new LinkedBlockingQueue<Runnable>();
        ThreadFactory fabricaHilos = new ThreadFactory(){
            private final AtomicInteger contador = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("CargadorMods-" + this.contador.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        };
        ThreadPoolExecutor.CallerRunsPolicy manejadorRechazo = new ThreadPoolExecutor.CallerRunsPolicy();
        return new ThreadPoolExecutor(tamanoPoolNucleo, tamanoPoolMaximo, tiempoVidaHilos, TimeUnit.SECONDS, colaTrabajo, fabricaHilos, manejadorRechazo);
    }

    private static int calcularHilosOptimos(int numeroMods) {
        int cpus = ManagementFactory.getThreadMXBean().getThreadCount();
        int hilosOptimos = Math.min(numeroMods, cpus * 4);
        return Math.max(1, Math.min(hilosOptimos, 512));
    }

    private static void procesarModsEnParalelo(String[] rutasMods, ThreadPoolExecutor ejecutor) {
        String[] stringArray = rutasMods;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String modPath;
            String rutaActual = modPath = stringArray[i];
            File archivoActual = new File(modPath);
            CrashDetectorLogger.log("buscardor mod " + rutaActual);
            ejecutor.submit(() -> {
                block10: {
                    try {
                        if (archivoActual.isFile()) {
                            if (archivoActual.getName().endsWith("deactivation") || archivoActual.getName().endsWith("disabled") || archivoActual.getName().endsWith("nil.jar") || archivoActual.getName().endsWith("nil") || archivoActual.getName().endsWith("rpm")) break block10;
                            CrashDetectorLogger.log("prearchivo mod " + archivoActual.getName());
                            try (FileInputStream fis = new FileInputStream(archivoActual);){
                                CrashDetectorLogger.log("En Stream " + archivoActual.getName() + " cargado correctamente");
                                ModPKZip modObj = new ModPKZip(rutaActual, ArchivoDeMod.origin, fis);
                                CrashDetectorLogger.log("crear " + archivoActual.getName() + " cargado correctamente");
                                mods.add(modObj);
                                CrashDetectorLogger.log("archivo mod " + archivoActual.getName() + " cargado correctamente");
                                break block10;
                            }
                            catch (IOException e) {
                                CrashDetectorLogger.log("Error al cargar mod ZIP " + archivoActual.getName() + ": " + e.getMessage());
                                CrashDetectorLogger.logException(e);
                            }
                            break block10;
                        }
                        CrashDetectorLogger.log("precarpeta mod " + archivoActual.getName());
                        Path rutaRaiz = archivoActual.toPath();
                        ModCarpeta modObj = new ModCarpeta(rutaActual, ArchivoDeMod.origin, rutaRaiz);
                        mods.add(modObj);
                        CrashDetectorLogger.log("carpeta mod " + archivoActual.getName() + " cargada correctamente");
                    }
                    catch (Exception e) {
                        CrashDetectorLogger.log("Error inesperado al procesar mod " + rutaActual + ": " + e.getMessage());
                        CrashDetectorLogger.logException(e);
                    }
                }
            });
        }
    }

    private static void cerrarThreadPoolExecutor(ThreadPoolExecutor ejecutor) {
        ejecutor.shutdown();
        try {
            if (!ejecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                List<Runnable> tareasPendientes = ejecutor.shutdownNow();
                if (!tareasPendientes.isEmpty()) {
                    CrashDetectorLogger.log("Se cancelaron " + tareasPendientes.size() + " tareas pendientes de carga de mods");
                }
                ejecutor.awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            CrashDetectorLogger.logException(e);
            ejecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static List<ArchivoDeMod> obtenerTodosLosModsYSubmodsRecursivos() {
        ArrayList<ArchivoDeMod> modsYSubmods = new ArrayList<ArchivoDeMod>();
        for (ArchivoDeMod mod : mods) {
            modsYSubmods.add(mod);
            Buscardor.agregarSubmodsRecursivos(mod, modsYSubmods);
        }
        return modsYSubmods;
    }

    public static void agregarSubmodsRecursivos(ArchivoDeMod mod, List<ArchivoDeMod> modsYSubmods) {
        List<ArchivoDeMod> submods = mod.mods_en_mods();
        for (ArchivoDeMod submod : submods) {
            modsYSubmods.add(submod);
            Buscardor.agregarSubmodsRecursivos(submod, modsYSubmods);
        }
    }

    public static String rutaParaPublicar(String ruta) {
        boolean anonimo = ConfigMundial.obtenerInstancia().esAnonimizarRegistros();
        if (anonimo) {
            return AnonimizadorDeRuta.anonimizarNombreDeUsuario(ruta.toString());
        }
        return ruta.toString();
    }

    public static List<String> obtenerModsConNombre(String nombre) {
        ArrayList<String> modsConNombre = new ArrayList<String>();
        for (ArchivoDeMod mod : Buscardor.obtenerTodosLosModsYSubmodsRecursivos()) {
            if (!mod.tieneNombreRecursivo(nombre)) continue;
            CrashDetectorLogger.log("tiene recursivo nombre " + mod.ubicacion_para_publicar());
            modsConNombre.add(Buscardor.rutaParaPublicar(mod.obtenerNombreRecursivo(nombre)));
        }
        return modsConNombre;
    }

    public static List<ArchivoDeMod> buscarModsConTermino(String termino) {
        ArrayList<ArchivoDeMod> resultados = new ArrayList<ArchivoDeMod>();
        for (ArchivoDeMod mod : Buscardor.obtenerTodosLosModsYSubmodsRecursivos()) {
            resultados.addAll(mod.buscarModsCon(termino));
        }
        return resultados;
    }

    public static byte[] obtenerBytesDeClase(String nombreClase) {
        if (nombreClase == null || nombreClase.isEmpty()) {
            return null;
        }
        String claseInterna = Buscardor.normalizarNombreClaseInterno(nombreClase);
        for (ArchivoDeMod mod : Buscardor.obtenerTodosLosModsYSubmodsRecursivos()) {
            try {
                if (!mod.existeClase(claseInterna)) continue;
                CrashDetectorLogger.log("tenemos clase " + claseInterna + " en mod " + mod.ubicacion_para_publicar());
                byte[] bytes = mod.obtenerBytesClase(claseInterna);
                if (bytes != null) {
                    return bytes;
                }
                CrashDetectorLogger.log("no bytes");
            }
            catch (Throwable t) {
                CrashDetectorLogger.log("Error obteniendo bytes de " + claseInterna + " en " + mod.ubicacion_para_publicar());
                CrashDetectorLogger.logException(t);
            }
        }
        return null;
    }

    private static String normalizarNombreClaseInterno(String nombre) {
        if (nombre == null) {
            return null;
        }
        String s = nombre.trim();
        if (s.isEmpty()) {
            return s;
        }
        if (s.startsWith("L") && s.endsWith(";")) {
            s = s.substring(1, s.length() - 1);
        }
        if (s.toLowerCase().endsWith(".class")) {
            s = s.substring(0, s.length() - ".class".length());
        }
        s = s.replace('.', '/');
        return s;
    }

    public static List<String> obtenerUbicaciones(List<ArchivoDeMod> mods) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ArchivoDeMod mod : mods) {
            ret.add(mod.ubicacion_para_publicar());
        }
        return ret;
    }

    public static boolean existeClaseEnAlgunMod(String nombreClase) {
        for (ArchivoDeMod mod : Buscardor.obtenerTodosLosModsYSubmodsRecursivos()) {
            if (!mod.existeClase(nombreClase)) continue;
            return true;
        }
        return false;
    }

    public static List<InfoMetodoMod> obtenerMetodosConReferenciasDeClase(String nombreClase) {
        if (!ArchivoDeMod.esAnalisisDeBytecodeDisponible()) {
            return new ArrayList<InfoMetodoMod>();
        }
        ArrayList<InfoMetodoMod> resultados = new ArrayList<InfoMetodoMod>();
        for (ArchivoDeMod mod : Buscardor.obtenerTodosLosModsYSubmodsRecursivos()) {
            if (!mod.existeClase(nombreClase)) continue;
            List<ArchivoDeMod.InfoMetodo> metodos = mod.obtenerMetodosConReferencias(nombreClase);
            for (ArchivoDeMod.InfoMetodo metodo : metodos) {
                resultados.add(new InfoMetodoMod(mod, metodo));
            }
        }
        return resultados;
    }

    public static List<InfoCampoMod> obtenerCamposDeClase(String nombreClase) {
        if (!ArchivoDeMod.esAnalisisDeBytecodeDisponible()) {
            return new ArrayList<InfoCampoMod>();
        }
        ArrayList<InfoCampoMod> resultados = new ArrayList<InfoCampoMod>();
        for (ArchivoDeMod mod : Buscardor.obtenerTodosLosModsYSubmodsRecursivos()) {
            if (!mod.existeClase(nombreClase)) continue;
            List<ArchivoDeMod.InfoCampo> campos = mod.obtenerCampos(nombreClase);
            for (ArchivoDeMod.InfoCampo campo : campos) {
                resultados.add(new InfoCampoMod(mod, campo));
            }
        }
        return resultados;
    }

    public static List<ArchivoDeMod.Referencia> buscarReferenciasEnMetodoEnMods(String nombreClase, String nombreMetodo, String descriptor) {
        if (!ArchivoDeMod.esAnalisisDeBytecodeDisponible()) {
            return new ArrayList<ArchivoDeMod.Referencia>();
        }
        ArrayList<ArchivoDeMod.Referencia> resultados = new ArrayList<ArchivoDeMod.Referencia>();
        for (ArchivoDeMod mod : Buscardor.obtenerTodosLosModsYSubmodsRecursivos()) {
            if (!mod.existeClase(nombreClase)) continue;
            resultados.addAll(mod.buscarReferenciasEnMetodo(nombreClase, nombreMetodo, descriptor));
        }
        return resultados;
    }

    public static List<ReferenciaMod> buscarReferenciasDeMetodoEnMods(String claseObjetivo, String metodoObjetivo, String descriptorObjetivo) {
        if (!ArchivoDeMod.esAnalisisDeBytecodeDisponible()) {
            return new ArrayList<ReferenciaMod>();
        }
        ArrayList<ReferenciaMod> resultados = new ArrayList<ReferenciaMod>();
        for (ArchivoDeMod mod : Buscardor.obtenerTodosLosModsYSubmodsRecursivos()) {
            List<ArchivoDeMod.Referencia> referencias = mod.buscarReferenciasAMetodo(claseObjetivo, metodoObjetivo, descriptorObjetivo);
            for (ArchivoDeMod.Referencia ref : referencias) {
                resultados.add(new ReferenciaMod(mod, ref));
            }
        }
        return resultados;
    }

    public static String convertirFormatoClase(String nombreClase) {
        if (nombreClase.contains("/")) {
            return nombreClase;
        }
        if (nombreClase.contains(".")) {
            return nombreClase.replace('.', '/');
        }
        return nombreClase;
    }

    public static String convertirFormatoClasePuntos(String nombreClase) {
        if (nombreClase.contains(".")) {
            return nombreClase;
        }
        if (nombreClase.contains("/")) {
            return nombreClase.replace('/', '.');
        }
        return nombreClase;
    }

    public static List<ReferenciaMod> buscarReferenciasHaciaMetodo(String claseObjetivo, String metodoObjetivo, String descriptorObjetivo) {
        if (!ArchivoDeMod.esAnalisisDeBytecodeDisponible()) {
            return new ArrayList<ReferenciaMod>();
        }
        ArrayList<ReferenciaMod> resultados = new ArrayList<ReferenciaMod>();
        for (ArchivoDeMod mod : Buscardor.obtenerTodosLosModsYSubmodsRecursivos()) {
            List<ArchivoDeMod.Referencia> referencias = mod.buscarReferenciasAMetodo(claseObjetivo, metodoObjetivo, descriptorObjetivo);
            for (ArchivoDeMod.Referencia ref : referencias) {
                resultados.add(new ReferenciaMod(mod, ref));
            }
        }
        return resultados;
    }

    public static boolean puedeAnalizarElContentidoDeClase() {
        if (ArchivoDeMod.ASM_DISPONIBLE) {
            return true;
        }
        return ArchivoDeMod.JAVASSIST_DISPONIBLE;
    }

    public static void cargadoresPredetermindado() {
        Cargador.cargadores.add(new CargadorFeatureCreep());
        Cargador.cargadores.add(new CargadorFabric());
        Cargador.cargadores.add(new CargadorMCForge());
        Cargador.cargadores.add(new CargadorNeoForge());
        Cargador.cargadores.add(new CargadorDangerZone());
        Cargador.cargadores.add(new CargadorNXOpen());
    }

    public static class InfoMetodoMod {
        private final ArchivoDeMod mod;
        private final ArchivoDeMod.InfoMetodo infoMetodo;

        public InfoMetodoMod(ArchivoDeMod mod, ArchivoDeMod.InfoMetodo infoMetodo) {
            this.mod = mod;
            this.infoMetodo = infoMetodo;
        }

        public ArchivoDeMod obtenerMod() {
            return this.mod;
        }

        public ArchivoDeMod.InfoMetodo obtenerInfoMetodo() {
            return this.infoMetodo;
        }
    }

    public static class InfoCampoMod {
        private final ArchivoDeMod mod;
        private final ArchivoDeMod.InfoCampo infoCampo;

        public InfoCampoMod(ArchivoDeMod mod, ArchivoDeMod.InfoCampo infoCampo) {
            this.mod = mod;
            this.infoCampo = infoCampo;
        }

        public ArchivoDeMod obtenerMod() {
            return this.mod;
        }

        public ArchivoDeMod.InfoCampo obtenerInfoCampo() {
            return this.infoCampo;
        }
    }

    public static class ReferenciaMod {
        private final ArchivoDeMod mod;
        private final ArchivoDeMod.Referencia referencia;

        public ReferenciaMod(ArchivoDeMod mod, ArchivoDeMod.Referencia referencia) {
            this.mod = mod;
            this.referencia = referencia;
        }

        public ArchivoDeMod obtenerMod() {
            return this.mod;
        }

        public ArchivoDeMod.Referencia obtenerReferencia() {
            return this.referencia;
        }
    }
}

