/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.buscar;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.ModPKZip;
import com.asbestosstar.crashdetector.buscar.ProcesadorManifiesto;
import com.asbestosstar.crashdetector.cargador.Cargador;
import com.asbestosstar.crashdetector.cargador.CargadorFeatureCreep;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Manifest;

public class ModCarpeta
implements ArchivoDeMod {
    public ArchivoDeMod desde;
    public String ubicacion;
    public List<ArchivoDeMod> mods_en_mod = new ArrayList<ArchivoDeMod>();
    public List<String> nombres = new ArrayList<String>();
    public List<String> clases = new ArrayList<String>();
    public List<String> archivos = new ArrayList<String>();
    private final Map<String, Path> mapaRutasClase = new ConcurrentHashMap<String, Path>();
    private final Map<String, byte[]> cacheBytesClase = new ConcurrentHashMap<String, byte[]>();
    private long totalTamanoClases = 0L;
    private int totalConteoClases = 0;
    private static final int EAGER_MAX_CLASES = 150;
    private static final long EAGER_MAX_BYTES = 1500000L;
    private final Path rutaRaiz;
    public List<Cargador> cargadores_de_mod = new ArrayList<Cargador>();

    public ModCarpeta(String ubicacion, ArchivoDeMod desde, Path rutaRaiz) {
        this.ubicacion = ubicacion;
        this.desde = desde;
        this.rutaRaiz = rutaRaiz;
        try {
            this.procesarCarpeta(rutaRaiz, true);
            this.precargarSiPequeno();
        }
        catch (Exception e) {
            CrashDetectorLogger.logException(e);
        }
    }

    private boolean procesarCarpeta(Path ruta, boolean esRaiz) {
        boolean contieneDefinicionMod = false;
        try (DirectoryStream<Path> flujoDirectorio = Files.newDirectoryStream(ruta);){
            for (Path entrada : flujoDirectorio) {
                String nombre = entrada.getFileName().toString();
                this.archivos.add(nombre);
                if (Files.isDirectory(entrada, new LinkOption[0])) {
                    boolean subContieneDefinicionMod = this.procesarCarpeta(entrada, false);
                    if (!subContieneDefinicionMod || !esRaiz) continue;
                    String nuevaUbicacion = this.ubicacion + "/" + nombre;
                    this.mods_en_mod.add(new ModCarpeta(nuevaUbicacion, this, entrada));
                    continue;
                }
                if (nombre.endsWith("modules.xml") || nombre.endsWith(".mod")) {
                    contieneDefinicionMod = true;
                    if (nombre.endsWith("modules.xml")) {
                        this.nombres.addAll(CargadorFeatureCreep.parsearNombreModuloJBoss(Files.readAllBytes(entrada)));
                        continue;
                    }
                    if (!nombre.endsWith(".mod")) continue;
                    this.nombres.addAll(CargadorFeatureCreep.parsearNombreModHOI4(Files.readAllBytes(entrada)));
                    continue;
                }
                if (nombre.endsWith(".class")) {
                    this.procesarClase(entrada);
                    continue;
                }
                if (nombre.endsWith("MANIFEST.MF")) {
                    this.nombres.addAll(ProcesadorManifiesto.obtenerNombresDeModulo(new Manifest(new FileInputStream(entrada.toAbsolutePath().toString()))));
                    continue;
                }
                if (!this.esArchivoAnidado(nombre)) continue;
                this.procesarArchivoAnidado(entrada, nombre);
            }
            for (Cargador cargador : Cargador.cargadores) {
                if (!cargador.modEsDeCargador(this)) continue;
                this.cargadores_de_mod.add(cargador);
            }
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
        }
        return contieneDefinicionMod;
    }

    private void procesarClase(Path entrada) {
        byte[] bytes;
        String nombreClaseJava = entrada.toString().replace(this.rutaRaiz.toString(), "").replace(File.separator, ".").replace(".class", "");
        if (nombreClaseJava.startsWith(".")) {
            nombreClaseJava = nombreClaseJava.substring(1);
        }
        this.clases.add(nombreClaseJava);
        String nombreInterno = entrada.toString().replace(this.rutaRaiz.toString(), "").substring(1).replace(File.separator, "/").replace(".class", "");
        this.mapaRutasClase.put(nombreInterno, entrada);
        ++this.totalConteoClases;
        try {
            this.totalTamanoClases += Files.size(entrada);
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
        }
        if (nombreClaseJava.endsWith("module-info") && (bytes = this.obtenerBytesClase(nombreClaseJava)) != null) {
            this.nombre().addAll(this.obtenerNombresDeModuleInfo(bytes));
        }
    }

    private void precargarSiPequeno() {
        if (this.totalConteoClases <= 150 && this.totalTamanoClases <= 1500000L) {
            for (Map.Entry<String, Path> e : this.mapaRutasClase.entrySet()) {
                try {
                    this.cacheBytesClase.put(e.getKey(), Files.readAllBytes(e.getValue()));
                }
                catch (IOException ex) {
                    CrashDetectorLogger.logException(ex);
                }
            }
        }
    }

    private void procesarArchivoAnidado(Path entrada, String nombre) {
        try (FileInputStream inputStream = new FileInputStream(entrada.toFile());){
            String nuevaUbicacion = this.ubicacion + "/" + nombre;
            this.mods_en_mod.add(new ModPKZip(nuevaUbicacion, this, inputStream));
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
        }
    }

    private boolean esArchivoAnidado(String nombreArchivo) {
        return nombreArchivo.endsWith(".jar") || nombreArchivo.endsWith(".zip") || nombreArchivo.endsWith(".fpm") || nombreArchivo.endsWith(".litemod") || nombreArchivo.endsWith(".war") || nombreArchivo.endsWith(".ear") || nombreArchivo.endsWith(".rar");
    }

    @Override
    public ArchivoDeMod obtenerDesde() {
        return this.desde;
    }

    @Override
    public List<ArchivoDeMod> mods_en_mods() {
        return this.mods_en_mod;
    }

    @Override
    public List<String> nombre() {
        return this.nombres;
    }

    @Override
    public String ubicacion() {
        return this.ubicacion;
    }

    @Override
    public List<String> clases() {
        return this.clases;
    }

    @Override
    public boolean tieneNombreRecursivo(String nombre) {
        if (this.nombres.contains(nombre)) {
            return true;
        }
        for (ArchivoDeMod mod : this.mods_en_mods()) {
            if (!mod.tieneNombreRecursivo(nombre)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String obtenerNombreRecursivo(String nombre) {
        if (this.tieneNombreRecursivo(nombre)) {
            if (this.nombres.contains(nombre)) {
                return this.ubicacion();
            }
            for (ArchivoDeMod mod : this.mods_en_mods()) {
                String resultado = mod.obtenerNombreRecursivo(nombre);
                if (resultado == null) continue;
                return resultado;
            }
        }
        return null;
    }

    @Override
    public boolean tieneArchivoRecursivo(String archivo) {
        if (this.archivos().contains(archivo)) {
            return true;
        }
        for (ArchivoDeMod mod : this.mods_en_mods()) {
            if (!mod.tieneArchivoRecursivo(archivo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String obtenerArchivoRecursivo(String archivo) {
        if (this.tieneArchivoRecursivo(archivo)) {
            if (this.archivos().contains(archivo)) {
                return this.ubicacion() + "/" + archivo;
            }
            for (ArchivoDeMod mod : this.mods_en_mods()) {
                String resultado = mod.obtenerArchivoRecursivo(archivo);
                if (resultado == null) continue;
                return resultado;
            }
        }
        return null;
    }

    @Override
    public List<String> archivos() {
        return this.archivos;
    }

    @Override
    public List<ArchivoDeMod> buscarModsCon(String termino) {
        boolean tienePaquete;
        int back;
        ArrayList<ArchivoDeMod> resultados = new ArrayList<ArchivoDeMod>();
        if (termino == null || termino.isEmpty()) {
            return resultados;
        }
        String t = termino;
        if (t.endsWith(".class")) {
            t = t.substring(0, t.length() - 6);
        }
        String tDots = t.replace('/', '.');
        String tSlashes = t.replace('.', '/');
        String baseName = t;
        int slash = baseName.lastIndexOf(47);
        if (slash >= 0) {
            baseName = baseName.substring(slash + 1);
        }
        if ((back = baseName.lastIndexOf(92)) >= 0) {
            baseName = baseName.substring(back + 1);
        }
        boolean tieneArchivo = this.archivos.contains(termino) || this.archivos.contains(baseName) || this.archivos.contains(baseName + ".class");
        boolean tieneClaseExacta = this.clases.contains(tDots) || this.mapaRutasClase.containsKey(tSlashes);
        boolean bl = tienePaquete = this.mapaRutasClase.keySet().stream().anyMatch(c -> c.startsWith(tSlashes)) || this.clases.stream().anyMatch(c -> c.startsWith(tDots));
        if (tieneArchivo || tieneClaseExacta || tienePaquete) {
            resultados.add(this);
        }
        for (ArchivoDeMod mod : this.mods_en_mod) {
            resultados.addAll(mod.buscarModsCon(termino));
        }
        return resultados;
    }

    @Override
    public boolean existeClase(String nombreClase) {
        if (nombreClase == null || nombreClase.isEmpty()) {
            return false;
        }
        String interno = ModCarpeta.normalizarNombreInterno(nombreClase);
        if (this.mapaRutasClase.containsKey(interno)) {
            return true;
        }
        String dots = interno.replace('/', '.');
        return this.clases.contains(dots);
    }

    @Override
    public byte[] obtenerBytesClase(String nombreClase) {
        if (nombreClase == null || nombreClase.isEmpty()) {
            return null;
        }
        String interno = ModCarpeta.normalizarNombreInterno(nombreClase);
        byte[] cached = this.cacheBytesClase.get(interno);
        if (cached != null) {
            return cached;
        }
        Path ruta = this.mapaRutasClase.get(interno);
        if (ruta == null) {
            return null;
        }
        try {
            byte[] bytes = Files.readAllBytes(ruta);
            byte[] prev = this.cacheBytesClase.putIfAbsent(interno, bytes);
            return prev != null ? prev : bytes;
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
            return null;
        }
    }

    @Override
    public List<String> obtenerTodosLosNombresDeClases() {
        return new ArrayList<String>(this.mapaRutasClase.keySet());
    }

    @Override
    public List<Cargador> cargadores() {
        return this.cargadores_de_mod;
    }

    public int precargarTodasLasClases() {
        int cargadas = 0;
        for (Map.Entry<String, Path> e : this.mapaRutasClase.entrySet()) {
            String interno = e.getKey();
            if (this.cacheBytesClase.containsKey(interno)) continue;
            try {
                byte[] data = Files.readAllBytes(e.getValue());
                if (data == null) continue;
                this.cacheBytesClase.put(interno, data);
                ++cargadas;
            }
            catch (IOException ex) {
                CrashDetectorLogger.logException(ex);
            }
        }
        return cargadas;
    }

    @Override
    public int precargarTodasLasClasesRecursivo() {
        int total = this.precargarTodasLasClases();
        for (ArchivoDeMod hijo : this.mods_en_mod) {
            try {
                if (hijo instanceof ModCarpeta) {
                    total += ((ModCarpeta)hijo).precargarTodasLasClasesRecursivo();
                    continue;
                }
                if (!(hijo instanceof ModPKZip)) continue;
                total += ((ModPKZip)hijo).precargarTodasLasClasesRecursivo();
            }
            catch (Throwable t) {
                CrashDetectorLogger.logException(t);
            }
        }
        return total;
    }

    private static String normalizarNombreInterno(String nombre) {
        String n = nombre;
        if (n.endsWith(".class")) {
            n = n.substring(0, n.length() - 6);
        }
        n = n.replace('.', '/');
        return n;
    }
}

