/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.buscar;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.ProcesadorManifiesto;
import com.asbestosstar.crashdetector.cargador.Cargador;
import com.asbestosstar.crashdetector.cargador.CargadorFabric;
import com.asbestosstar.crashdetector.cargador.CargadorFeatureCreep;
import com.asbestosstar.crashdetector.cargador.CargadorMCForge;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ModPKZip
implements ArchivoDeMod {
    public ArchivoDeMod desde;
    public String ubicacion;
    public List<ArchivoDeMod> mods_en_mod = new ArrayList<ArchivoDeMod>();
    public List<String> nombres = new ArrayList<String>();
    public List<String> clases = new ArrayList<String>();
    public List<String> archivos = new ArrayList<String>();
    private final byte[] bytesZip;
    private final Map<String, String> mapaEntradaPorClase = new HashMap<String, String>();
    private final Map<String, byte[]> cacheBytesEntrada = new ConcurrentHashMap<String, byte[]>();
    private final Map<String, byte[]> cacheBytesClase = new ConcurrentHashMap<String, byte[]>();
    public List<Cargador> cargadores_de_mod = new ArrayList<Cargador>();
    public boolean meta_tiene_referencia_de_mcreator = false;

    public ModPKZip(String ubicacion, ArchivoDeMod desde, InputStream inputStream) {
        CrashDetectorLogger.log("en mod pkzip " + ubicacion);
        this.ubicacion = ubicacion;
        this.desde = desde;
        try {
            this.bytesZip = ModPKZip.leerTodo(inputStream);
            this.indexarYProcesarMetadatos();
            this.descubrirCargadores();
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
            throw new RuntimeException(e);
        }
    }

    private static byte[] leerTodo(InputStream in) throws IOException {
        int n;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(Math.max(32768, in.available()));
        byte[] tmp = new byte[65536];
        while ((n = in.read(tmp)) != -1) {
            buf.write(tmp, 0, n);
        }
        return buf.toByteArray();
    }

    private void indexarYProcesarMetadatos() throws IOException {
        try (JarInputStream zip = new JarInputStream(new ByteArrayInputStream(this.bytesZip));){
            ZipEntry e;
            Manifest man = zip.getManifest();
            if (man != null) {
                this.nombres.addAll(ProcesadorManifiesto.obtenerNombresDeModulo(man));
            }
            while ((e = zip.getNextEntry()) != null) {
                byte[] content;
                String nombreArchivo = e.getName();
                this.archivos.add(nombreArchivo);
                if (this.esArchivoAnidado(nombreArchivo)) {
                    byte[] bytesAnidado = this.leerEntrada(nombreArchivo);
                    if (bytesAnidado != null) {
                        ByteArrayInputStream nested = new ByteArrayInputStream(bytesAnidado);
                        String nuevaUbicacion = this.ubicacion + "!/" + nombreArchivo;
                        this.mods_en_mod.add(new ModPKZip(nuevaUbicacion, this, nested));
                    }
                } else if (nombreArchivo.endsWith(".class")) {
                    byte[] bytes;
                    String nombreClaseJava = nombreArchivo.replace('/', '.').replace(".class", "");
                    this.clases.add(nombreClaseJava);
                    String nombreInterno = nombreArchivo.substring(0, nombreArchivo.length() - 6);
                    this.mapaEntradaPorClase.put(nombreInterno, nombreArchivo);
                    if (nombreClaseJava.endsWith("module-info") && (bytes = this.obtenerBytesClase(nombreClaseJava)) != null) {
                        this.nombres.addAll(this.obtenerNombresDeModuleInfo(bytes));
                    }
                } else if (nombreArchivo.endsWith("modules.xml")) {
                    content = this.leerEntrada(nombreArchivo);
                    if (content != null) {
                        this.nombres.addAll(CargadorFeatureCreep.parsearNombreModuloJBoss(content));
                    }
                } else if (nombreArchivo.endsWith(".mod")) {
                    content = this.leerEntrada(nombreArchivo);
                    if (content != null) {
                        this.nombres.addAll(CargadorFeatureCreep.parsearNombreModHOI4(content));
                    }
                } else if (nombreArchivo.equals("fabric.mod.json")) {
                    content = this.leerEntrada(nombreArchivo);
                    if (content != null) {
                        String texto = new String(content, StandardCharsets.UTF_8);
                        this.nombres.addAll(CargadorFabric.parsearIdModFabric(texto));
                        if (texto.toLowerCase().contains("mcreator")) {
                            this.meta_tiene_referencia_de_mcreator = true;
                        }
                    }
                } else if (nombreArchivo.endsWith("mods.toml") && (content = this.leerEntrada(nombreArchivo)) != null) {
                    String toml = new String(content, StandardCharsets.UTF_8);
                    this.nombres.addAll(CargadorMCForge.parsearIdModMCForge(toml));
                    if (toml.toLowerCase().contains("mcreator")) {
                        this.meta_tiene_referencia_de_mcreator = true;
                    }
                }
                zip.closeEntry();
            }
        }
    }

    private void descubrirCargadores() {
        for (Cargador cargador : Cargador.cargadores) {
            try {
                if (!cargador.modEsDeCargador(this)) continue;
                this.cargadores_de_mod.add(cargador);
            }
            catch (Throwable t) {
                CrashDetectorLogger.logException(t);
            }
        }
    }

    private byte[] leerEntrada(String nombreEntrada) throws IOException {
        byte[] cache = this.cacheBytesEntrada.get(nombreEntrada);
        if (cache != null) {
            return cache;
        }
        try (ZipInputStream zip = new ZipInputStream(new ByteArrayInputStream(this.bytesZip));){
            ZipEntry e;
            while ((e = zip.getNextEntry()) != null) {
                if (nombreEntrada.equals(e.getName())) {
                    byte[] data = ModPKZip.leer(zip);
                    this.cacheBytesEntrada.put(nombreEntrada, data);
                    zip.closeEntry();
                    byte[] byArray = data;
                    return byArray;
                }
                zip.closeEntry();
            }
        }
        return null;
    }

    private static byte[] leer(InputStream input) throws IOException {
        int bytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[65536];
        while ((bytesRead = input.read(data)) != -1) {
            buffer.write(data, 0, bytesRead);
        }
        return buffer.toByteArray();
    }

    private boolean esArchivoAnidado(String nombreArchivo) {
        return nombreArchivo.endsWith(".jar") || nombreArchivo.endsWith(".zip") || nombreArchivo.endsWith(".fpm") || nombreArchivo.endsWith(".litemod") || nombreArchivo.endsWith(".war") || nombreArchivo.endsWith(".ear") || nombreArchivo.endsWith(".rar");
    }

    @Override
    public ArchivoDeMod obtenerDesde() {
        return this.desde;
    }

    @Override
    public List<ArchivoDeMod> mods_en_mods() {
        return this.mods_en_mod;
    }

    @Override
    public List<String> nombre() {
        return this.nombres;
    }

    @Override
    public String ubicacion() {
        return this.ubicacion;
    }

    @Override
    public List<String> clases() {
        return this.clases;
    }

    @Override
    public boolean tieneNombreRecursivo(String nombre) {
        if (this.nombres.contains(nombre)) {
            return true;
        }
        for (ArchivoDeMod mod : this.mods_en_mods()) {
            if (!mod.tieneNombreRecursivo(nombre)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String obtenerNombreRecursivo(String nombre) {
        if (this.tieneNombreRecursivo(nombre)) {
            if (this.nombres.contains(nombre)) {
                return this.ubicacion();
            }
            for (ArchivoDeMod mod : this.mods_en_mods()) {
                String resultado = mod.obtenerNombreRecursivo(nombre);
                if (resultado == null) continue;
                return resultado;
            }
        }
        return null;
    }

    @Override
    public boolean tieneArchivoRecursivo(String archivo) {
        if (this.archivos().contains(archivo)) {
            return true;
        }
        for (ArchivoDeMod mod : this.mods_en_mods()) {
            if (!mod.tieneArchivoRecursivo(archivo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String obtenerArchivoRecursivo(String archivo) {
        if (this.tieneArchivoRecursivo(archivo)) {
            if (this.archivos.contains(archivo)) {
                return this.ubicacion() + "!/" + archivo;
            }
            for (ArchivoDeMod mod : this.mods_en_mods()) {
                String resultado = mod.obtenerArchivoRecursivo(archivo);
                if (resultado == null) continue;
                return resultado;
            }
        }
        return null;
    }

    @Override
    public List<String> archivos() {
        return this.archivos;
    }

    @Override
    public List<ArchivoDeMod> buscarModsCon(String termino) {
        boolean tienePaquete;
        ArrayList<ArchivoDeMod> resultados = new ArrayList<ArchivoDeMod>();
        if (termino == null || termino.isEmpty()) {
            return resultados;
        }
        String t = termino;
        if (t.endsWith(".class")) {
            t = t.substring(0, t.length() - 6);
        }
        String tDots = t.replace('/', '.');
        String tSlashes = t.replace('.', '/');
        boolean tieneArchivo = this.archivos.contains(termino) || this.archivos.contains(tSlashes + ".class") || this.archivos.contains(tDots);
        boolean tieneClaseExacta = this.clases.contains(tDots) || this.mapaEntradaPorClase.containsKey(tSlashes) || this.mapaEntradaPorClase.containsKey(ModPKZip.normalizarNombreInterno(t));
        boolean bl = tienePaquete = this.mapaEntradaPorClase.keySet().stream().anyMatch(c -> c.startsWith(tSlashes)) || this.clases.stream().anyMatch(c -> c.startsWith(tDots));
        if (tieneArchivo || tieneClaseExacta || tienePaquete) {
            resultados.add(this);
        }
        for (ArchivoDeMod mod : this.mods_en_mod) {
            resultados.addAll(mod.buscarModsCon(termino));
        }
        return resultados;
    }

    @Override
    public boolean existeClase(String nombreClase) {
        if (nombreClase == null || nombreClase.isEmpty()) {
            return false;
        }
        String interno = ModPKZip.normalizarNombreInterno(nombreClase);
        if (this.mapaEntradaPorClase.containsKey(interno)) {
            return true;
        }
        String dots = interno.replace('/', '.');
        return this.clases.contains(dots);
    }

    @Override
    public byte[] obtenerBytesClase(String nombreClase) {
        if (nombreClase == null || nombreClase.isEmpty()) {
            return null;
        }
        String interno = ModPKZip.normalizarNombreInterno(nombreClase);
        byte[] cached = this.cacheBytesClase.get(interno);
        if (cached != null) {
            return cached;
        }
        String nombreEntrada = this.mapaEntradaPorClase.get(interno);
        if (nombreEntrada == null) {
            return null;
        }
        try {
            byte[] data = this.leerEntrada(nombreEntrada);
            if (data != null) {
                this.cacheBytesClase.put(interno, data);
            }
            return data;
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
            return null;
        }
    }

    @Override
    public List<String> obtenerTodosLosNombresDeClases() {
        return new ArrayList<String>(this.mapaEntradaPorClase.keySet());
    }

    @Override
    public List<Cargador> cargadores() {
        return this.cargadores_de_mod;
    }

    @Override
    public boolean MetaDataTieneReferenciaDeMCReator() {
        return this.meta_tiene_referencia_de_mcreator;
    }

    public int precargarTodasLasClases() {
        int cargadas = 0;
        try (ZipInputStream zip = new ZipInputStream(new ByteArrayInputStream(this.bytesZip));){
            ZipEntry entrada;
            while ((entrada = zip.getNextEntry()) != null) {
                byte[] data;
                String nombreInterno;
                String nombreEntrada = entrada.getName();
                if (nombreEntrada.endsWith(".class") && this.mapaEntradaPorClase.containsKey(nombreInterno = nombreEntrada.substring(0, nombreEntrada.length() - 6)) && !this.cacheBytesClase.containsKey(nombreInterno) && (data = ModPKZip.leer(zip)) != null) {
                    this.cacheBytesClase.put(nombreInterno, data);
                    ++cargadas;
                }
                zip.closeEntry();
            }
        }
        catch (IOException ex) {
            CrashDetectorLogger.logException(ex);
        }
        return cargadas;
    }

    @Override
    public int precargarTodasLasClasesRecursivo() {
        int total = this.precargarTodasLasClases();
        for (ArchivoDeMod hijo : this.mods_en_mod) {
            if (!(hijo instanceof ModPKZip)) continue;
            total += ((ModPKZip)hijo).precargarTodasLasClasesRecursivo();
        }
        return total;
    }

    private static String normalizarNombreInterno(String nombre) {
        String n = nombre;
        if (n.endsWith(".class")) {
            n = n.substring(0, n.length() - 6);
        }
        n = n.replace('.', '/');
        return n;
    }
}

