/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.cargador;

import com.asbestosstar.crashdetector.cargador.AnalizadorModsTomlForgeElectronwill;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AnalizadorModsTomlForge {
    public static boolean electronwillDisponible() {
        try {
            Class.forName("com.electronwill.nightconfig.toml.TomlParser", false, AnalizadorModsTomlForge.class.getClassLoader());
            Class.forName("com.electronwill.nightconfig.core.UnmodifiableConfig", false, AnalizadorModsTomlForge.class.getClassLoader());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static List<String> extraerModIds(String toml) {
        if (AnalizadorModsTomlForge.electronwillDisponible()) {
            return AnalizadorModsTomlForgeElectronwill.extraerModIds(toml);
        }
        return AnalizadorModsTomlForge.extraerModIdsPorRegex(toml);
    }

    private static List<String> extraerModIdsPorRegex(String toml) {
        ArrayList<String> nombres = new ArrayList<String>();
        Pattern pMods = Pattern.compile("\\[\\[mods\\]\\][^\\[]*?modId\\s*\\=\\s*\"([^\"]+)\"", 32);
        Matcher mMods = pMods.matcher(toml);
        if (mMods.find()) {
            String modIdPrincipal = mMods.group(1).trim();
            if (!modIdPrincipal.isEmpty() && !nombres.contains(modIdPrincipal)) {
                nombres.add(modIdPrincipal);
            }
        } else {
            nombres.add("Mod Forge desconocido");
        }
        Pattern pDep = Pattern.compile("\\[\\[dependencies\\.([a-zA-Z0-9_\\-]+)\\]\\]");
        Matcher mDep = pDep.matcher(toml);
        while (mDep.find()) {
            String modid = mDep.group(1).trim();
            if (modid.isEmpty() || nombres.contains(modid)) continue;
            nombres.add(modid);
        }
        return nombres;
    }
}

