/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.cargador;

import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.cargador.Cargador;
import com.asbestosstar.crashdetector.json.Json;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CargadorFabric
implements Cargador {
    @Override
    public boolean modEsDeCargador(ArchivoDeMod mod) {
        for (String archivo : mod.archivos()) {
            String norm = archivo.replace('\\', '/');
            String lower = norm.toLowerCase(Locale.ROOT);
            if (!lower.equals("fabric.mod.json")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cargadorEsActivado() {
        return Cargador.claseExiste("net.fabricmc.loader.api.FabricLoader");
    }

    @Override
    public String id() {
        return "fabric";
    }

    public static List<String> parsearIdModFabric(String texto) throws IOException {
        ArrayList<String> salida = new ArrayList<String>();
        try {
            Json.Nodo provides;
            Json.Nodo raiz = Json.leer(texto);
            String id = raiz.obtener("id").comoCadena();
            if (id != null && !id.isEmpty() && !salida.contains(id)) {
                salida.add(id);
            }
            if ((provides = raiz.obtener("provides")) != null && provides.esArreglo()) {
                for (int i = 0; i < provides.tamano(); ++i) {
                    String p = provides.en(i).comoCadena();
                    if (p == null || p.isEmpty() || salida.contains(p)) continue;
                    salida.add(p);
                }
            }
            return salida;
        }
        catch (Throwable t) {
            Pattern pprov;
            Matcher mprov;
            String id;
            Pattern pid = Pattern.compile("\"id\"\\s*:\\s*\"([^\"]+)\"");
            Matcher mid = pid.matcher(texto);
            if (mid.find() && !(id = mid.group(1).trim()).isEmpty() && !salida.contains(id)) {
                salida.add(id);
            }
            if ((mprov = (pprov = Pattern.compile("\"provides\"\\s*:\\s*\\[(.*?)\\]", 32)).matcher(texto)).find()) {
                String dentro = mprov.group(1);
                Matcher mitem = Pattern.compile("\"([^\"]+)\"").matcher(dentro);
                while (mitem.find()) {
                    String p = mitem.group(1).trim();
                    if (p.isEmpty() || salida.contains(p)) continue;
                    salida.add(p);
                }
            }
            return salida;
        }
    }
}

