/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.cargador;

import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.cargador.AnalizadorModsTomlForge;
import com.asbestosstar.crashdetector.cargador.Cargador;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class CargadorMCForge
implements Cargador {
    @Override
    public boolean modEsDeCargador(ArchivoDeMod mod) {
        if (mod.ubicacion_para_publicar().contains("kotlinforforge")) {
            return true;
        }
        for (String archivo : mod.archivos()) {
            String servicio;
            String norm = archivo.replace('\\', '/');
            String lower = norm.toLowerCase(Locale.ROOT);
            if (lower.equals("meta-inf/mods.toml")) {
                return true;
            }
            if (!lower.startsWith("meta-inf/services/") || !(servicio = lower.substring("meta-inf/services/".length())).startsWith("cpw") && !servicio.startsWith("net.minecraftforge")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cargadorEsActivado() {
        return !Cargador.claseExiste("cpw.mods.modlauncher.api.TargetType") && !Cargador.claseExiste("net.neoforged.neoforgespi.transformation.ClassProcessor") && Cargador.claseExiste("cpw.mods.modlauncher.api.ITransformationService");
    }

    @Override
    public String id() {
        return "minecraftforge";
    }

    public static List<String> parsearIdModMCForge(String toml) throws IOException {
        return AnalizadorModsTomlForge.extraerModIds(toml);
    }
}

