/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.cargador;

import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.cargador.Cargador;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CargadorNeoForge
implements Cargador {
    @Override
    public boolean modEsDeCargador(ArchivoDeMod mod) {
        for (String archivo : mod.archivos()) {
            String servicio;
            String norm = archivo.replace('\\', '/');
            String lower = norm.toLowerCase(Locale.ROOT);
            if (lower.equals("meta-inf/neoforge.mods.toml")) {
                return true;
            }
            if (!lower.startsWith("meta-inf/services/") || !(servicio = lower.substring("meta-inf/services/".length())).startsWith("cpw") && !servicio.startsWith("net.neoforged")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cargadorEsActivado() {
        return Cargador.claseExiste("cpw.mods.modlauncher.api.TargetType") && Cargador.claseExiste("cpw.mods.modlauncher.api.ITransformationService") || Cargador.claseExiste("net.neoforged.neoforgespi.transformation.ClassProcessor");
    }

    @Override
    public String id() {
        return "neoforge";
    }

    public static List<String> parsearIdModNeoForge(byte[] contenido) throws IOException {
        String toml = new String(contenido, StandardCharsets.UTF_8);
        ArrayList<String> nombres = new ArrayList<String>();
        Pattern modPattern = Pattern.compile("\\[\\[mods\\]\\][^\\[]*modId\\s*=\\s*\"([^\"]+)\"", 32);
        Matcher modMatcher = modPattern.matcher(toml);
        String modIdPrincipal = "Mod Forge desconocido";
        if (modMatcher.find()) {
            modIdPrincipal = modMatcher.group(1);
        }
        nombres.add(modIdPrincipal);
        Pattern depPattern = Pattern.compile("\\[\\[dependencies\\.([a-zA-Z0-9_]+)\\]\\]");
        Matcher depMatcher = depPattern.matcher(toml);
        while (depMatcher.find()) {
            String nombreDependencia = depMatcher.group(1);
            nombres.add(nombreDependencia);
        }
        return nombres;
    }
}

