/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.config;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import java.util.function.Supplier;

public class ConfigBoolean
implements ElementoConfig<Boolean> {
    private final String clave;
    public Supplier<String> nombre;
    public boolean def;

    private ConfigBoolean(String clave, boolean def) {
        this.clave = clave;
        this.def = def;
    }

    @Override
    public String clave() {
        return this.clave;
    }

    @Override
    public Boolean obtener() {
        String valor = Config.obtenerInstancia().propiedadesConfig.getProperty(this.clave);
        if (valor == null) {
            throw new IllegalArgumentException("La clave de configuraci\u00f3n no existe: " + this.clave);
        }
        String trimmed = valor.trim().toLowerCase();
        if (!trimmed.equals("true") && !trimmed.equals("false")) {
            throw new IllegalStateException("El valor de la clave no es un booleano v\u00e1lido: " + valor);
        }
        return Boolean.parseBoolean(trimmed);
    }

    @Override
    public void escribir(Boolean valor) {
        Config.obtenerInstancia().propiedadesConfig.setProperty(this.clave, Boolean.toString(valor));
        Config.obtenerInstancia().guardar();
    }

    public static ConfigBoolean de(String clave, boolean valorPorDefecto) throws IllegalStateException {
        Config config = Config.obtenerInstancia();
        String valor = config.propiedadesConfig.getProperty(clave);
        if (valor == null) {
            config.propiedadesConfig.setProperty(clave, Boolean.toString(valorPorDefecto));
            config.guardar();
            return new ConfigBoolean(clave, valorPorDefecto);
        }
        String trimmed = valor.trim().toLowerCase();
        if (!trimmed.equals("true") && !trimmed.equals("false")) {
            throw new IllegalStateException("El valor de la clave no representa un booleano v\u00e1lido: " + valor);
        }
        return new ConfigBoolean(clave, valorPorDefecto);
    }

    @Override
    public String obtenerNombreParaMostrar() {
        if (this.nombre != null && this.nombre.get() != null) {
            return this.nombre.get();
        }
        return this.clave;
    }

    @Override
    public void establecerNombreParaMostrar(Supplier<String> nombre) {
        this.nombre = nombre;
    }

    @Override
    public Boolean obtenerValorPorDefecto() {
        return this.def;
    }
}

