/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.config;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import java.awt.Color;
import java.util.function.Supplier;

public class ConfigColor
implements ElementoConfig<Color> {
    private final String clave;
    public Supplier<String> nombre;
    public Color def;

    private ConfigColor(String clave, Color def) {
        this.clave = clave;
        this.def = def;
    }

    @Override
    public String clave() {
        return this.clave;
    }

    @Override
    public Color obtener() {
        String valor = Config.obtenerInstancia().propiedadesConfig.getProperty(this.clave);
        if (valor == null) {
            throw new IllegalArgumentException("La clave de configuraci\u00f3n no existe: " + this.clave);
        }
        try {
            return Config.convertirAColor(valor);
        }
        catch (Exception e) {
            throw new IllegalStateException("El valor de la clave no es un color v\u00e1lido: " + valor, e);
        }
    }

    @Override
    public void escribir(Color valor) {
        Config.obtenerInstancia().propiedadesConfig.setProperty(this.clave, Config.colorAHexHtml(valor));
        Config.obtenerInstancia().guardar();
    }

    public static ConfigColor de(String clave, Color valorPorDefecto) throws IllegalStateException {
        Config config = Config.obtenerInstancia();
        String valor = config.propiedadesConfig.getProperty(clave);
        if (valor == null) {
            config.propiedadesConfig.setProperty(clave, Config.colorAHexHtml(valorPorDefecto));
            config.guardar();
            return new ConfigColor(clave, valorPorDefecto);
        }
        try {
            Config.convertirAColor(valor);
        }
        catch (Exception e) {
            throw new IllegalStateException("El valor de la clave no representa un color v\u00e1lido: " + valor, e);
        }
        return new ConfigColor(clave, valorPorDefecto);
    }

    @Override
    public String obtenerNombreParaMostrar() {
        if (this.nombre != null && this.nombre.get() != null) {
            return this.nombre.get();
        }
        return this.clave;
    }

    @Override
    public void establecerNombreParaMostrar(Supplier<String> nombre) {
        this.nombre = nombre;
    }

    @Override
    public Color obtenerValorPorDefecto() {
        return this.def;
    }
}

