/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.config;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import java.util.function.Supplier;

public class ConfigDouble
implements ElementoConfig<Double> {
    private final String clave;
    public Supplier<String> nombre;
    public double def;

    private ConfigDouble(String clave, double def) {
        this.clave = clave;
        this.def = def;
    }

    @Override
    public String clave() {
        return this.clave;
    }

    @Override
    public Double obtener() {
        String valor = Config.obtenerInstancia().propiedadesConfig.getProperty(this.clave);
        if (valor == null) {
            throw new IllegalArgumentException("La clave de configuraci\u00f3n no existe: " + this.clave);
        }
        try {
            return Double.parseDouble(valor.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("El valor de la clave no es un n\u00famero v\u00e1lido: " + valor, e);
        }
    }

    @Override
    public void escribir(Double valor) {
        Config.obtenerInstancia().propiedadesConfig.setProperty(this.clave, Double.toString(valor));
        Config.obtenerInstancia().guardar();
    }

    public static ConfigDouble de(String clave, double valorPorDefecto) throws IllegalStateException {
        Config config = Config.obtenerInstancia();
        String valor = config.propiedadesConfig.getProperty(clave);
        if (valor == null) {
            config.propiedadesConfig.setProperty(clave, Double.toString(valorPorDefecto));
            config.guardar();
            return new ConfigDouble(clave, valorPorDefecto);
        }
        try {
            Double.parseDouble(valor.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("El valor de la clave no representa un n\u00famero v\u00e1lido: " + valor, e);
        }
        return new ConfigDouble(clave, valorPorDefecto);
    }

    @Override
    public String obtenerNombreParaMostrar() {
        if (this.nombre != null && this.nombre.get() != null) {
            return this.nombre.get();
        }
        return this.clave;
    }

    @Override
    public void establecerNombreParaMostrar(Supplier<String> nombre) {
        this.nombre = nombre;
    }

    @Override
    public Double obtenerValorPorDefecto() {
        return this.def;
    }
}

