/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.config;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.config.ElementoConfig;
import java.util.function.Supplier;

public class ConfigString
implements ElementoConfig<String> {
    private final String clave;
    public Supplier<String> nombre;
    public String def;

    private ConfigString(String clave, String def) {
        this.clave = clave;
        this.def = def;
    }

    @Override
    public String clave() {
        return this.clave;
    }

    @Override
    public String obtener() {
        String valor = Config.obtenerInstancia().propiedadesConfig.getProperty(this.clave);
        if (valor == null) {
            throw new IllegalArgumentException("La clave de configuraci\u00f3n no existe: " + this.clave);
        }
        return valor;
    }

    @Override
    public void escribir(String valor) {
        Config.obtenerInstancia().propiedadesConfig.setProperty(this.clave, valor);
        Config.obtenerInstancia().guardar();
    }

    public static ConfigString de(String clave, String valorPorDefecto) {
        Config config = Config.obtenerInstancia();
        String valor = config.propiedadesConfig.getProperty(clave);
        if (valor == null) {
            config.propiedadesConfig.setProperty(clave, valorPorDefecto);
            config.guardar();
            return new ConfigString(clave, valorPorDefecto);
        }
        return new ConfigString(clave, valorPorDefecto);
    }

    @Override
    public String obtenerNombreParaMostrar() {
        if (this.nombre != null && this.nombre.get() != null) {
            return this.nombre.get();
        }
        return this.clave;
    }

    @Override
    public void establecerNombreParaMostrar(Supplier<String> nombre) {
        this.nombre = nombre;
    }

    @Override
    public String obtenerValorPorDefecto() {
        return this.def;
    }
}

